/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.secrity.AESUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.util.AESUtil;
import com.kingdee.shr.base.syssetting.web.util.UserUtil;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/downloadfile"})
public class DownloadFileController
extends WebComponentController {
    private static final Logger logger = Logger.getLogger(DownloadFileController.class);
    public static final String AES_ENCRNUMBER_STR = "4i4AAAAbYAWogfPn";

    @RequestMapping(params={"method=tmp"})
    public void downloadTempFile(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String file = UserUtil.getEncryRealFileName(ctx, request.getParameter("file"));
        String filename = request.getParameter("filename");
        this.checkPermission(request);
        if (!this.verifParam(file, filename)) {
            return;
        }
        try {
            String filePath = UserUtil.getUserTempDirAbsolutePath(request.getSession()) + File.separator + file;
            File file1 = new File(SHRCheck.checkFilePath((String)filePath));
            if (!file1.exists()) {
                throw new ShrWebBizException(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"file_not_exist", (Context)ctx), filename));
            }
            response.reset();
            this.setResponseHeader(request, response, filename);
            this.outWriteFile(response, filePath);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    @RequestMapping(params={"method=file"})
    public void downloadFromDir(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String file = request.getParameter("file");
        String filename = request.getParameter("filename");
        String ipkey = request.getParameter("ipkey");
        this.checkPermission(request);
        if (!this.verifParam(file, filename)) {
            return;
        }
        this.downloadFile(request, response, modelMap, file, filename, ipkey);
    }

    private void checkPermission(HttpServletRequest request) throws SHRWebException {
        String _p_v_s_ = request.getParameter("_p_v_s_");
        String file = request.getParameter("file");
        String filename = request.getParameter("filename");
        try {
            if (StringUtils.isEmpty((String)_p_v_s_)) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            Context ctx = SHRContext.getInstance().getContext();
            String _p_v_s_0 = AESUtils.cbcDecrypt((String)_p_v_s_, (String)AESUtils.getUrlParamEncryptKey());
            if (StringUtils.isEmpty((String)_p_v_s_0)) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            String[] _p_v_s_1 = _p_v_s_0.split(",");
            if (_p_v_s_1.length != 3) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            String file0 = "";
            String filename0 = "";
            String userId0 = "";
            for (String s : _p_v_s_1) {
                String key = s.substring(0, s.indexOf("="));
                String value = s.substring(s.indexOf("=") + 1);
                if ("file".equals(key)) {
                    file0 = value;
                }
                if ("filename".equals(key)) {
                    filename0 = value;
                }
                if (!"userId".equals(key)) continue;
                userId0 = value;
            }
            if (!(file0.equals(file) && filename0.equals(filename) && userId0.equals(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()))) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
        }
        catch (ShrPermissionException e) {
            throw new ShrWebBizException(e);
        }
        catch (Exception e) {
            throw new SHRWebException(e);
        }
    }

    @RequestMapping(params={"method=export"})
    public void downloadExport(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String file = request.getParameter("file");
        String filename = request.getParameter("filename");
        String ipkey = request.getParameter("ipkey");
        this.checkPermission(request);
        String msgId = request.getParameter("msgId");
        if (!StringUtils.isEmpty((String)msgId)) {
            Context ctx = SHRContext.getInstance().getContext();
            try {
                BMCMessageInfo info = new BMCMessageInfo();
                info.setId(BOSUuid.read((String)msgId));
                info.setStatus(MsgStatus.READED);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("status"));
                BMCMessageFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)info, selectors);
                ClassificationStatCacheManager manager = ClassificationStatCacheManager.get((Context)ctx);
                manager.expire(ctx.getCaller().toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!this.verifParam(file, filename)) {
            return;
        }
        String fileDir = "shrExport" + File.separator + file;
        try {
            this.downloadFile(request, response, modelMap, fileDir, filename, ipkey);
        }
        catch (Exception e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected void downloadFile(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String file, String filename, String ipkey) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String realFile = UserUtil.getEncryRealFileName(ctx, file);
        if (StringUtils.isEmpty((String)ipkey)) {
            this.downloadLocalFile(request, response, filename, realFile);
        } else {
            try {
                String ipport = AESUtil.aesDecrypt(ipkey, AESUtils.getUrlParamEncryptKey());
                String[] ipports = ipport.split(":");
                String ip = ipports[0];
                String port = ipports[1];
                String thisIp = InetAddress.getLocalHost().getHostAddress();
                if (thisIp.equals(ip)) {
                    this.downloadLocalFile(request, response, filename, realFile);
                } else {
                    this.donwloadRemoteFile(request, response, filename, realFile, ip, port);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SHRWebException(e.getMessage(), e);
            }
        }
    }

    protected void downloadLocalFile(HttpServletRequest request, HttpServletResponse response, String filename, String file) throws SHRWebException {
        try {
            String filePath = request.getSession().getServletContext().getRealPath("/") + file;
            File file1 = new File(SHRCheck.checkFilePath((String)filePath));
            if (!file1.exists()) {
                throw new ShrWebBizException(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"file_not_exist", (Context)SHRContext.getInstance().getContext()), filename));
            }
            response.reset();
            this.setResponseHeader(request, response, filename);
            this.outWriteFile(response, filePath);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    protected void donwloadRemoteFile(HttpServletRequest request, HttpServletResponse response, String filename, String file, String remoteIp, String remotePort) throws SHRWebException {
        block18: {
            Context ctx = SHRContext.getInstance().getContext();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            CloseableHttpClient httpClient = httpClientBuilder.build();
            StringBuilder urlSb = new StringBuilder();
            urlSb.append(request.getScheme()).append("://").append(remoteIp).append(":").append(remotePort).append(request.getContextPath());
            urlSb.append("/downloadFileForMulMachine.do?");
            try {
                urlSb.append("method=file").append("&file=").append(URLEncoder.encode(file, "UTF-8")).append("&filename=").append(URLEncoder.encode(filename, "UTF-8")).append("&ctxId=").append(URLEncoder.encode(ctx.getContextID(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            HttpGet httpGet = new HttpGet(urlSb.toString());
            CloseableHttpResponse rep = null;
            try {
                httpGet.addHeader("java_inner_call", AESUtils.cbcEncrypt((String)AESUtils.getUrlParamEncryptKey(), (String)AESUtils.getUrlParamEncryptKey()));
                RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(true).build();
                httpGet.setConfig(requestConfig);
                rep = httpClient.execute((HttpUriRequest)httpGet);
                HttpEntity responseEntity = rep.getEntity();
                if (responseEntity == null) break block18;
                byte[] fileByte = EntityUtils.toByteArray((HttpEntity)responseEntity);
                try {
                    response.reset();
                    this.setResponseHeader(request, response, filename);
                    try {
                        ServletOutputStream out = response.getOutputStream();
                        out.write(fileByte);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    throw new SHRWebException(e.getMessage(), e);
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new SHRWebException(e.getMessage(), e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SHRWebException(e.getMessage(), e);
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (rep != null) {
                        rep.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outWriteFile(HttpServletResponse response, String filePath) throws IOException {
        ServletOutputStream os = null;
        BufferedInputStream in = null;
        try {
            os = response.getOutputStream();
            in = new BufferedInputStream(new FileInputStream(SHRCheck.checkFilePath((String)filePath)));
            byte[] data = new byte[1024];
            int length = -1;
            while ((length = in.read(data)) != -1) {
                os.write(data, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    protected boolean verifParam(String file, String fileName) {
        return !StringUtils.isEmpty((String)file) && !StringUtils.isEmpty((String)fileName) && !file.contains("../") && !file.contains("..\\");
    }

    private void setResponseHeader(HttpServletRequest request, HttpServletResponse response, String filename) throws UnsupportedEncodingException {
        String encodeFileName = WebUtil.convertFileNameForDownload(request, filename);
        String fileType = "attachment";
        String contentType = "application/octet-stream; charset=utf-8";
        if ("true".equals(request.getParameter("pdfview"))) {
            fileType = "inline";
            contentType = "application/pdf; charset=utf-8";
        }
        response.setHeader("Content-Disposition", fileType + ";filename*=utf-8''" + SHRCheck.checkFileNameForSetResponseHeader((String)encodeFileName));
        response.setContentType(contentType);
    }
}

