/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.IOfficialAccount;
import com.kingdee.eas.base.uiframe.OfficialAccountFactory;
import com.kingdee.eas.base.uiframe.OfficialAccountInfo;
import com.kingdee.eas.base.uiframe.utils.UIFrameUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.VersionManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.gzh.GZHSinatureUtil;
import com.kingdee.shr.base.syssetting.web.gzh.HashHmacCrypto;
import com.kingdee.shr.base.syssetting.web.gzh.XushaochunGZHProperties;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/gzhService"})
public class GzhServiceController {
    private static Logger logger = Logger.getLogger(GzhServiceController.class);
    private String CLIENT_ID = EasCloud.CLIENT_ID;
    private String CLIENT_SECRET = EasCloud.CLIENT_SECRET;
    private String MY_BUINESS_NUMBER = "5998498670981230171";

    @RequestMapping(value={"/gzhInfo"})
    public String getTokenAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        result.put("success", true);
        result.put("message", "");
        try {
            String oql;
            UserInfo _ = ContextUtil.getCurrentUserInfo((Context)ctx);
            UserInfo u = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(_.getId().toString()));
            if (StringUtils.isEmpty((String)u.getUid())) {
                u.setUid("unknown");
            }
            String tokenInfo = null;
            IOfficialAccount iOfficialAccount = OfficialAccountFactory.getLocalInstance((Context)ctx);
            if (iOfficialAccount.exists(oql = "where creator.id = '" + u.getId().toString() + "'")) {
                tokenInfo = (String)iOfficialAccount.getObjectBaseInfo(oql).get("token");
            }
            if (StringUtils.isEmpty(tokenInfo)) {
                TreeMap<String, String> params = this.getTokenParams(request, u);
                String url = XushaochunGZHProperties.getInstance().getTokenApiUrl() + "?" + this.concatUrl(params);
                this.setTokenHeaders(params);
                params.put("tokenUrl", url);
                result.put("tokenPreInfo", params);
            } else {
                result.put("homePageInfo", this.getHomePageParam(request, u, tokenInfo));
            }
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("message", e.getMessage());
        }
        JSONUtils.writeJson(response, result);
        return null;
    }

    @RequestMapping(value={"/clearToken"})
    public String clearTokenAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        OfficialAccountInfo tokenInfo = null;
        try {
            IOfficialAccount iOfficialAccount = OfficialAccountFactory.getLocalInstance((Context)ctx);
            String oql = "where creator.id = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
            if (iOfficialAccount.exists(oql)) {
                tokenInfo = (OfficialAccountInfo)iOfficialAccount.getObjectBaseInfo(oql);
            }
            if (null == tokenInfo || StringUtils.isEmpty((String)tokenInfo.getToken())) {
                return null;
            }
            tokenInfo.setToken(null);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("token"));
            iOfficialAccount.updatePartial((CoreBaseInfo)tokenInfo, selectors);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return null;
    }

    @RequestMapping(value={"/saveToken"})
    public String saveTokenAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        String tokenInfo = request.getParameter("token");
        result.put("success", true);
        result.put("message", "");
        try {
            String oql;
            UserInfo _ = ContextUtil.getCurrentUserInfo((Context)ctx);
            UserInfo u = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(_.getId().toString()));
            if (StringUtils.isEmpty((String)u.getUid())) {
                u.setUid("unknown");
            }
            OfficialAccountInfo model = null;
            IOfficialAccount iOfficialAccount = OfficialAccountFactory.getLocalInstance((Context)ctx);
            if (iOfficialAccount.exists(oql = "where creator.id = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'")) {
                model = (OfficialAccountInfo)iOfficialAccount.getObjectBaseInfo(oql);
            }
            if (null == model) {
                model = new OfficialAccountInfo();
                model.setToken(tokenInfo);
            } else {
                model.setToken(tokenInfo);
            }
            iOfficialAccount.save((CoreBaseInfo)model);
            result.put("homePageInfo", this.getHomePageParam(request, u, tokenInfo));
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("message", e.getMessage());
        }
        JSONUtils.writeJson(response, result);
        return null;
    }

    private TreeMap<Object, Object> getHomePageParam(HttpServletRequest request, UserInfo u, String tokenInfo) throws SHRWebException, LicenseException {
        HashMap token = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), tokenInfo);
        TreeMap<Object, Object> params = new TreeMap<Object, Object>();
        String timestamp = null;
        Date getGMT8Time = this.getGMT8Time();
        if (getGMT8Time != null) {
            timestamp = String.valueOf(getGMT8Time.getTime());
        }
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        params.put("clientid", this.CLIENT_ID);
        params.put("uid", u.getUid());
        params.put("erpId", u.getId().toString());
        String prodSN = baseInfo.getSerialNum();
        params.put("prodSN", prodSN);
        params.put("timestamp", timestamp);
        String accessToken = GZHSinatureUtil.aesSign(params, String.valueOf(token.get("accessToken")));
        params.put("accessToken", accessToken);
        params.put("tokenInfo", tokenInfo);
        params.put("homePageUrl", XushaochunGZHProperties.getInstance().getPageApiUrl());
        params.put("messageUrl", XushaochunGZHProperties.getInstance().getMessageApiUrl());
        return params;
    }

    private TreeMap<String, String> getTokenParams(HttpServletRequest request, UserInfo u) throws Exception {
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("clientId", this.CLIENT_ID);
        params.put("uid", u.getUid());
        params.put("erpId", u.getId().toString());
        params.put("erpName", u.getName());
        String erpPhone = u.getCell();
        params.put("erpPhone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
        String erpEmail = u.getEmail();
        params.put("erpEmail", StringUtils.isEmpty((String)erpEmail) ? "unknown" : erpEmail);
        String prodInstCode = StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID();
        params.put("prodInstCode", prodInstCode);
        String prodSN = StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum();
        params.put("prodSN", prodSN);
        params.put("prodName", "EAS");
        String version = this.getEASversion();
        params.put("prodVersion", StringUtils.isEmpty((String)version) ? "unknown" : version);
        params.put("prodCategoryCode", "SHR");
        params.put("prodDeployWay", "OfflineERP");
        params.put("prodClientType", "WEB");
        String prodSoftcode = StringUtils.isEmpty((String)baseInfo.getMechineCode()) ? "unknown" : baseInfo.getMechineCode();
        params.put("prodSoftcode", prodSoftcode);
        params.put("prodDomain", "unknown");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
        params.put("userRole", "Normal");
        params.put("userSource", "Product");
        params.put("customerLevel", "unknown");
        String customerName = baseInfo.getLicenseTo();
        params.put("customerName", StringUtils.isEmpty((String)customerName) ? "unknown" : URLEncoder.encode(customerName, "utf-8"));
        params.put("extParam", this.buildExtParam(baseInfo, u));
        return params;
    }

    private String concatUrl(TreeMap<String, String> parameters) throws UnsupportedEncodingException {
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, String> element : parameters.entrySet()) {
            String value = URLEncoder.encode(element.getValue(), "utf-8");
            params.append(element.getKey());
            params.append("=");
            params.append(value);
            params.append("&");
        }
        int iLen = params.length();
        if (iLen > 0) {
            params = params.deleteCharAt(iLen - 1);
        }
        return params.toString();
    }

    private String buildExtParam(LicenseBaseInfo baseInfo, UserInfo u) throws Exception {
        JSONObject rs = new JSONObject();
        String phone = u.getCell();
        String email = u.getEmail();
        if (StringUtils.isEmpty((String)phone)) {
            phone = "";
        }
        if (StringUtils.isEmpty((String)email)) {
            email = "";
        }
        JSONObject noneParam = new JSONObject();
        noneParam.put("client_id", (Object)this.CLIENT_ID);
        JSONObject ksm = new JSONObject();
        ksm.put("client_id", (Object)this.CLIENT_ID);
        String productCode = baseInfo.getSerialNum();
        ksm.put("productCode", (Object)productCode);
        ksm.put("userId", (Object)u.getId().toString());
        String account = "";
        String licenseTo = baseInfo.getLicenseTo();
        if (!StringUtils.isEmpty((String)licenseTo)) {
            account = new String(Base64Encoder.base64ToByteArray((String)licenseTo), "GBK");
        }
        ksm.put("account", (Object)account);
        ksm.put("username", (Object)u.getName());
        ksm.put("email", (Object)email);
        ksm.put("telephone", (Object)phone);
        rs.put("SHR_KSM", (Object)ksm);
        rs.put("SHR_COMMUNITY", (Object)noneParam);
        rs.put("SHR_COURSE", noneParam.clone());
        JSONObject myBusiness = new JSONObject();
        String hash = MD5Util.getMD5String((String)(phone + this.MY_BUINESS_NUMBER));
        myBusiness.put("cellephone", (Object)phone);
        myBusiness.put("account", (Object)u.getNumber());
        myBusiness.put("name", (Object)u.getName());
        myBusiness.put("source", (Object)"s-HR");
        myBusiness.put("hash", (Object)hash);
        myBusiness.put("client_id", (Object)this.CLIENT_ID);
        myBusiness.put("company", (Object)"");
        rs.put("SHR_OPPORTUNITY", (Object)myBusiness);
        return rs.toJSONString();
    }

    private Date getGMT8Time() {
        Date gmt8 = null;
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"), Locale.CHINESE);
            Calendar day = Calendar.getInstance();
            day.set(1, cal.get(1));
            day.set(2, cal.get(2));
            day.set(5, cal.get(5));
            day.set(11, cal.get(11));
            day.set(12, cal.get(12));
            day.set(13, cal.get(13));
            gmt8 = day.getTime();
        }
        catch (Exception e) {
            gmt8 = null;
        }
        return gmt8;
    }

    private String getEASversion() {
        String version = UIFrameUtils.getEASOrBOSVersionFromServerAtProperties((String)"EAS", (Locale)SHRContext.getInstance().getContext().getLocale());
        if (null == version) {
            VersionManager vmeas = new VersionManager();
            try {
                version = vmeas.getMetadataVersion();
            }
            catch (Exception var3) {
                version = "unknown";
            }
        }
        System.setProperty("productVersion", version);
        return version;
    }

    private String getSignature(TreeMap<String, String> data, String nonce, String timestamp) {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        headMap.put("X-Api-Nonce", nonce);
        headMap.put("X-Api-TimeStamp", timestamp);
        String sign = "";
        try {
            sign = HashHmacCrypto.sign("POST", XushaochunGZHProperties.getInstance().getXushaochunGZHProperty("token_api_name").toString(), data, headMap, this.CLIENT_SECRET);
            sign = sign.replaceAll(System.getProperty("line.separator"), "");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sign;
    }

    private void setTokenHeaders(TreeMap<String, String> data) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String signature = this.getSignature(data, nonce, timestamp);
        data.put("timestamp", timestamp);
        data.put("nonce", nonce);
        data.put("signature", signature);
    }

    @RequestMapping(value={"/isShowContactUs"})
    public String isShowContactUsAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Context ctx = SHRContext.getInstance().getContext();
        String isShowContactUs = ParamManager.getParamValue((Context)ctx, null, (String)"isShowContactUs");
        if (!StringUtils.isEmpty((String)isShowContactUs) && Boolean.parseBoolean(isShowContactUs)) {
            result.put("isShowContactUs", true);
        } else {
            result.put("isShowContactUs", false);
        }
        JSONUtils.writeJson(response, result);
        return null;
    }
}

