/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.sso.client.util.SSOLogUtil;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContext;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.web.EASWebLicenceHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.guilogin.EASServiceHelper;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.cache.MLCacheHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/shr_loginout"})
public class SHRLogInOutController {
    private static Logger logger = Logger.getLogger((String)SHRLogInOutController.class.getName());

    @RequestMapping(value={"/logout"})
    public String logoutAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        HttpSession session = request.getSession();
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx == null) {
            ctx = SHRLogInOutController.getRealEasContext(request);
        } else {
            SSOLogUtil.logLogout((Context)ctx);
        }
        return "/shr/gui/logout";
    }

    @RequestMapping(value={"/logoutAndReleaseResource"})
    public String logoutAndReleaseResourceAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        HttpSession session = request.getSession();
        if (session == null) {
            return null;
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (ctx != null) {
            SSOLogUtil.logLogout((Context)ctx);
            EASServiceHelper helper = new EASServiceHelper();
            helper.deleteUserMonitor(request);
            MenuCacheFactory.getLocalInstance((Context)ctx).updateMenuCacheByUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        } else {
            logger.error((Object)"easserviceimpl deleteUserMonitor ctx is null!");
        }
        try {
            session.setAttribute("UserContext", null);
            session.setAttribute("org.apache.struts.action.LOCALE", null);
            session.setAttribute("pureWebContext", null);
            session.setAttribute("_const_cas_assertion_", null);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }

    @RequestMapping(value={"/loginCheck"})
    public String loginCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        PortalContext portalContext = (PortalContext)request.getSession().getAttribute("portal_context");
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        if (ctx != null) {
            request.getSession().setAttribute("pureWebContext", (Object)ctx);
        } else {
            request.setAttribute("message", (Object)"Context is nul,Pleas Login first");
        }
        LicenseUserInfo licenseUserInfo = EASWebLicenceHelper.createLicenseUserInfo((HttpServletRequest)request, (Context)ctx);
        try {
            int n = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).requestLicenseOnInvalid(licenseUserInfo, "com.kingdee.eas.portal.web.action.PortalAction");
        }
        catch (LicenseException e) {
            e.printStackTrace();
        }
        String result = null;
        String isNotCheckRelogin = request.getParameter("isNotCheckRelogin");
        if (!"true".equals(isNotCheckRelogin)) {
            result = this.checkRelogin(request, ctx);
        }
        if (result != null) {
            return result;
        }
        this.addUserMonitorInfo(ctx, request);
        return null;
    }

    @RequestMapping(value={"/addToUserMonitor"})
    public String addToUserMonitorAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        boolean success = false;
        String localErr = null;
        try {
            Context ctx = (Context)((PortalContext)request.getSession().getAttribute("portal_context")).getMetaInfo().get("eas_context");
            this.addUserMonitorInfo(ctx, request);
            success = true;
        }
        catch (Exception ex) {
            success = false;
            localErr = ex.getMessage();
        }
        Object result = null;
        String tempResult = "";
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("errinfo", localErr);
        ajaxData.put("result", tempResult);
        JSONUtils.writeJson(response, ajaxData);
        return null;
    }

    public static Context getRealEasContext(HttpServletRequest request) {
        WebContext webContext = SHRLogInOutController.getWebContext(request);
        Context ctx = null;
        if (webContext != null) {
            String sessionID = webContext.getSessionId();
            try {
                ctx = SessionManager.getInstance().getSession(sessionID).getContext();
            }
            catch (Exception e) {
                logger.error((Object)("[Eas portal]get eas user server context fails. context is null." + e.getMessage()), (Throwable)e);
            }
        } else {
            logger.debug((Object)"[Eas portal]webContext is null.");
        }
        return ctx;
    }

    public static WebContext getWebContext(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebContext webContext = (WebContext)session.getAttribute("easWebContextSessionId");
        return webContext;
    }

    private String checkRelogin(HttpServletRequest request, Context ctx) throws EASBizException, BOSException {
        request.getSession().removeAttribute("isReachUserLimitCount");
        List userList = UserMonitorFactory.getLocalInstance((Context)ctx).findUsers(ctx.getAIS(), ctx.getUserName());
        boolean findUser = false;
        if (userList.size() > 0) {
            String sessionId = ctx.getContextID();
            for (UMRegistryInfo info : userList) {
                if (!info.getId().equals(sessionId)) continue;
                return null;
            }
            for (UMRegistryInfo info : userList) {
                if (info.getId().equals(sessionId)) continue;
                findUser = true;
                break;
            }
            logger.error((Object)("checkRelogin findUser===" + findUser));
            if (findUser) {
                boolean allowRelogin = true;
                UserInfo user = UserFactory.getRemoteInstance().getUserInfoByNumber(ctx.getUserName());
                if (user != null) {
                    allowRelogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(user.getId().toString());
                }
                logger.error((Object)("checkRelogin allowRelogin===" + allowRelogin));
                if (allowRelogin) {
                    boolean isReachUserLimitCount = true;
                    isReachUserLimitCount = UserMonitorFactory.getLocalInstance((Context)ctx).isOverLicenseCount(ctx.getUserName(), ctx.getAIS(), ctx.getContextID());
                    logger.error((Object)("checkRelogin isReachUserLimitCount===" + isReachUserLimitCount));
                    request.getSession().setAttribute("isReachUserLimitCount", (Object)String.valueOf(isReachUserLimitCount));
                    Map m = MLCacheHelper.getResource((Context)ctx, (ResourceType)ResourceType.JSP, (String)"framework.jsp");
                    request.setAttribute("jspMultiLan", (Object)m);
                    if (isReachUserLimitCount) {
                        request.setAttribute("username", (Object)ctx.getUserName());
                        request.setAttribute("dbcenter", (Object)ctx.getAIS());
                        request.setAttribute("isReachUserLimitCount", (Object)isReachUserLimitCount);
                        return "loginAgain";
                    }
                    boolean isAwoke = this.isAwokeAtUserReLogin(ctx);
                    logger.error((Object)("checkRelogin isAwoke===" + isAwoke));
                    if (isAwoke) {
                        request.setAttribute("username", (Object)ctx.getUserName());
                        request.setAttribute("dbcenter", (Object)ctx.getAIS());
                        request.setAttribute("isReachUserLimitCount", (Object)isReachUserLimitCount);
                        return "loginAgain";
                    }
                } else {
                    request.getSession().setAttribute("reloginNotAllow", (Object)"true");
                    return "reloginNotAllow";
                }
            }
        }
        return null;
    }

    public boolean isAwokeAtUserReLogin(Context userCtx) {
        boolean flag = true;
        String paramkey = "isAwokeAtUserReLoginForPortal";
        try {
            String paravalue = ParamManager.getParamValue((Context)userCtx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            logger.error((Object)"login check error:", (Throwable)e);
        }
        return flag;
    }

    private void addUserMonitorInfo(Context ctx, HttpServletRequest httpRequest) {
        Locale userLocale = null;
        UserMonitorSessionInfo userMonitorSessionInfo = new UserMonitorSessionInfo();
        if (ctx != null) {
            userLocale = ctx.getLocale();
            userMonitorSessionInfo.setId(ctx.getContextID());
        } else {
            String defaultLanguage = httpRequest.getSession().getServletContext().getInitParameter("com.kingdee.eas.portal.defaultLanguage");
            if (defaultLanguage == null || "".equals(defaultLanguage)) {
                defaultLanguage = "L2";
            }
            userLocale = new Locale(defaultLanguage);
        }
        userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
        userMonitorSessionInfo.setLastUpdateTime(new Date());
        userMonitorSessionInfo.setLastCheckTickedTime(new Date());
        userMonitorSessionInfo.setLoginType(LoginType.PORTAL);
        HttpSession session = httpRequest.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
        session.setAttribute("userMonitorSessionInfo", (Object)userMonitorSessionInfo);
    }
}

