/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.HRMenuItemCollection;
import com.kingdee.shr.base.syssetting.HRMenuItemFactory;
import com.kingdee.shr.base.syssetting.HRMenuItemInfo;
import com.kingdee.shr.base.syssetting.IHRMenuItem;
import com.kingdee.shr.base.syssetting.ServiceFactory;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ShrTreeMenu;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/treeMenu"})
public class TreeMenuController
extends WebComponentController {
    @RequestMapping(params={"method=getMenuItems"})
    @Action
    public void getMenuItems(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean i2 = false;
        String dbCacheTime = MenuCacheFactory.getRemoteInstance().getCacheTimeByUserid(userInfo.getId().toString());
        String cacheTime = request.getParameter("UserMenuCacheTime");
        if (!StringUtils.isEmpty((String)cacheTime) && !"null".equals(cacheTime) && dbCacheTime != null && dbCacheTime.equals(cacheTime)) {
            JSONUtils.SUCCESS("UserMenuCache");
            return;
        }
        HRMenuItemCollection collection = null;
        try {
            collection = HRMenuItemFactory.getRemoteInstance().getInitMenuData();
            ShrTreeMenu root = this.convertRootTreeMenu(collection);
            root.setCacheTimeStr(dbCacheTime);
            JSONUtils.SUCCESS(root);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            JSONUtils.ERROR(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "get_menuinfo_fail"), (Exception)((Object)e));
        }
    }

    @RequestMapping(params={"method=getMenuItemsIfLeaf"})
    @Action
    public void getMenuItemsIfLeaf(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        IHRMenuItem hrMenuItem = HRMenuItemFactory.getRemoteInstance();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("parent.parent.*"));
        sic.add(new SelectorItemInfo("permItem.*"));
        entityViewInfo.setSelector(sic);
        CoreBaseCollection coll = hrMenuItem.getCollection(entityViewInfo);
        Document document = new Document();
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                HRMenuItemInfo hrMenuItemInfo = (HRMenuItemInfo)coll.get(i);
                Element service = new Element("service");
                service.setAttribute("name", hrMenuItemInfo.getLongNumber() != null ? hrMenuItemInfo.getLongNumber() : "");
                service.setAttribute("alias", hrMenuItemInfo.getName() != null ? hrMenuItemInfo.getName() : "");
                service.setAttribute("type", "task");
                Element desc = new Element("desc");
                desc.setText(hrMenuItemInfo.getDescription());
                service.addContent((Content)desc);
                Element categorys = new Element("categorys");
                if (hrMenuItemInfo.getLevel() == 3 || hrMenuItemInfo.getLevel() == 4) {
                    Element cate1 = new Element("cate");
                    cate1.setAttribute("number", hrMenuItemInfo.getParent().getNumber());
                    cate1.setAttribute("alias", hrMenuItemInfo.getParent().getName());
                    cate1.setAttribute("order", String.valueOf(hrMenuItemInfo.getIndex()));
                    cate1.setAttribute("parent", "");
                    categorys.addContent((Content)cate1);
                }
                service.addContent((Content)categorys);
                Element permission = new Element("permission");
                permission.setAttribute("name", hrMenuItemInfo.getPermItem() != null ? (hrMenuItemInfo.getPermItem().getName() != null ? hrMenuItemInfo.getPermItem().getName() : "") : "");
                service.addContent((Content)permission);
                Element url = new Element("url");
                String type = hrMenuItemInfo.getType().getValue();
                String value = null;
                url.setAttribute("type", type);
                value = "view".equals(type) ? (hrMenuItemInfo.getUipk() != null ? hrMenuItemInfo.getUipk() : "") : (hrMenuItemInfo.getUrl() != null ? hrMenuItemInfo.getUrl() : "");
                url.setAttribute("value", value);
                service.addContent((Content)url);
                Element index = new Element("index");
                index.setAttribute("value", hrMenuItemInfo.getIndex() + "");
                service.addContent((Content)index);
                document.setRootElement(service);
                String domStr = XMLUtil.getXMLOutputter().outputString(document);
                ServiceInfo info = new ServiceInfo();
                info.setContent(domStr);
                Context ctx = SHRContext.getInstance().getContext();
                ServiceFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
            }
        }
    }

    private ShrTreeMenu convertRootTreeMenu(HRMenuItemCollection collection) {
        HashMap<String, ShrTreeMenu> map = new HashMap<String, ShrTreeMenu>();
        HRMenuItemInfo info = null;
        ShrTreeMenu root = null;
        ShrTreeMenu parent = null;
        ShrTreeMenu treeMenuItem = null;
        String parentLongNumber = null;
        String longNumber = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            treeMenuItem = this.assembleMenuItemInfo(info);
            if (info.getParent() != null) {
                longNumber = info.getLongNumber();
                parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                parent = (ShrTreeMenu)map.get(parentLongNumber);
                if (parent != null) {
                    if (parent.children == null) {
                        parent.children = new ArrayList<ShrTreeMenu>();
                    }
                    parent.children.add(treeMenuItem);
                }
            } else {
                root = treeMenuItem;
            }
            if (info.isIsLeaf()) continue;
            map.put(info.getLongNumber(), treeMenuItem);
        }
        if (root != null) {
            root.sort();
        }
        return root;
    }

    private ShrTreeMenu assembleMenuItemInfo(HRMenuItemInfo info) {
        ShrTreeMenu tshrTreeMenu = new ShrTreeMenu();
        tshrTreeMenu.setId(info.getId().toString());
        tshrTreeMenu.setIsLeaf(info.isIsLeaf() + "");
        tshrTreeMenu.setModel(info.getModel());
        tshrTreeMenu.setName(info.getName());
        tshrTreeMenu.setType(info.getType().getName());
        tshrTreeMenu.setUri(info.getUri());
        tshrTreeMenu.setUrl(info.getUrl());
        tshrTreeMenu.setServiceName(info.getService());
        tshrTreeMenu.setIndex(info.getIndex());
        return tshrTreeMenu;
    }
}

