/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FormUIViewInfo;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;

public class DynamicFormUIViewInfo
extends FormUIViewInfo {
    private String scheme;

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        List<FieldInfo> fields = this.getFields();
        String fieldName = null;
        Object dataType = null;
        for (FieldInfo fieldInfo : fields) {
            fieldName = fieldInfo.getName();
            sic.add(new SelectorItemInfo(fieldName));
        }
        return sic;
    }

    public Object convertValue(Object value, String fieldName) {
        block31: {
            String tempValue = (String)value;
            if (StringUtils.isEmpty((String)tempValue)) {
                return null;
            }
            if (fieldName.equals("id")) {
                return BOSUuid.read((String)tempValue);
            }
            FieldInfo fieldInfo = this.getField(fieldName);
            if (fieldInfo == null) {
                return null;
            }
            Object result = null;
            DataType dataType = fieldInfo.getDataType();
            if (DataType.STRING.equals((Object)dataType)) {
                return tempValue;
            }
            if (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
                try {
                    return DateTimeUtils.parseDate((String)tempValue);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    break block31;
                }
            }
            if (DataType.INTEGER.equals((Object)dataType)) {
                return Integer.parseInt(tempValue);
            }
            if (DataType.LONG.equals((Object)dataType)) {
                return Long.parseLong(tempValue);
            }
            if (DataType.SHORT.equals((Object)dataType)) {
                return Short.parseShort(tempValue);
            }
            if (DataType.DOUBLE.equals((Object)dataType)) {
                return Double.parseDouble(tempValue);
            }
            if (DataType.DECIMAL.equals((Object)dataType)) {
                return new BigDecimal(tempValue);
            }
            if (DataType.FLOAT.equals((Object)dataType)) {
                return Float.valueOf(Float.parseFloat(tempValue));
            }
            if (DataType.UUID.equals((Object)dataType)) {
                return BOSUuid.read((String)tempValue);
            }
            if (DataType.ENUM.equals((Object)dataType)) {
                BizEnumInfo enumInfo = ((OwnPropertyInfo)fieldInfo.getProperty()).getEnumType();
                String enumSource = enumInfo.getClassName();
                try {
                    Class<?> enumClass = Class.forName(enumSource);
                    if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                        Method method = enumClass.getMethod("getEnum", String.class);
                        return method.invoke((Object)dataType, tempValue);
                    }
                    if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                        Method method = enumClass.getMethod("getEnum", Integer.TYPE);
                        return method.invoke((Object)dataType, Integer.parseInt(tempValue));
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                if (DataType.BOOLEAN.equals((Object)dataType)) {
                    if ("0".equals(tempValue)) {
                        return Boolean.FALSE;
                    }
                    if ("1".equals(tempValue)) {
                        return Boolean.TRUE;
                    }
                    return null;
                }
                if (DataType.OBJECTVALUE.equals((Object)dataType)) {
                    Context ctx = SHRContext.getInstance().getContext();
                    try {
                        QueryConfigFieldInfo fInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)ctx, (String)this.getScheme(), (String)fieldName);
                        EntityObjectInfo entityObjInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(fInfo.getFactField().getStructureConfig().getEntityName()));
                        CoreBaseInfo objInfo = (CoreBaseInfo)Utils.newObjectValueInstance((EntityObjectInfo)entityObjInfo);
                        objInfo.setId(BOSUuid.read((String)tempValue));
                        return objInfo;
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public String getEntityNameByPropertyInfo(String entityName, PropertyInfo propertyInfo) {
        String subEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo && entityName.equals(subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName())) {
            subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getClientObject().getFullName();
        }
        return subEntityName;
    }
}

