/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BelongDomainType;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jdom2.Document;
import org.jdom2.Element;

public class OSFCheckUtil {
    public static void checkImplClass(Context ctx, boolean isMoblie) throws BOSException, SHRWebException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT T0.FCONFIG,T1.FCONFIG FCONFIGEXT, T0.FSERVICENAME, T0.FSTATE,T0.FBELONGDOMAIN");
        sb.append(" FROM T_BD_MSFCONFIG T0 LEFT OUTER JOIN T_BD_MSFCONFIGEXT T1 ON T1.FPARENTID = T0.FID ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT COUNT(*)  CC FROM T_BD_MSFCONFIG");
            int total = 0;
            while (rs.next()) {
                total = rs.getInt("CC");
            }
            int rows = 200;
            int times = total / 200 + 1;
            PagingHelper p = new PagingHelper();
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            Sheet sheet = workbook.createSheet("data");
            int rowindex = 0;
            Row row = sheet.createRow(rowindex++);
            OSFCheckUtil.fillHeaders(row);
            for (int i = 0; i < times; ++i) {
                String querysql = p.getPagingSqlNoOptmize(ctx, sb.toString(), i * rows, rows);
                rs = DbUtil.executeQuery((Context)ctx, (String)querysql);
                while (rs.next()) {
                    String config = rs.getString("FCONFIG");
                    String configext = rs.getString("FCONFIGEXT");
                    String servicename = rs.getString("FSERVICENAME");
                    int state = rs.getInt("FSTATE");
                    String belongdomain = rs.getString("FBELONGDOMAIN");
                    String checkContext = config;
                    if (!StringUtils.isEmpty((String)configext)) {
                        checkContext = configext;
                    }
                    try {
                        Document doc = XMLUtil.parseXML((String)checkContext);
                        Element rootElement = doc.getRootElement();
                        String classz = rootElement.getAttributeValue("class");
                        String inz = rootElement.getAttributeValue("interface");
                        ServiceLocator.getInstance().createService(ctx, servicename, classz, inz);
                        if (!isMoblie || !classz.contains("com.kingdee.shr.shrmobile")) continue;
                        row = sheet.createRow(rowindex++);
                        row.createCell(0).setCellValue(servicename);
                        row.createCell(1).setCellValue(StateEnum.getEnum((int)state).getAlias());
                        row.createCell(2).setCellValue(BelongDomainType.getEnum((String)belongdomain).getAlias());
                        row.createCell(3).setCellValue(classz);
                    }
                    catch (Exception e) {
                        if (isMoblie) continue;
                        row = sheet.createRow(rowindex++);
                        row.createCell(0).setCellValue(servicename);
                        row.createCell(1).setCellValue(StateEnum.getEnum((int)state).getAlias());
                        if (null != BelongDomainType.getEnum((String)belongdomain)) {
                            row.createCell(2).setCellValue(BelongDomainType.getEnum((String)belongdomain).getAlias());
                        } else {
                            row.createCell(2).setCellValue("");
                        }
                        row.createCell(3).setCellValue("impl class not exist, other error:" + e.getMessage());
                    }
                }
            }
            if (isMoblie) {
                OSFCheckUtil.writeExcelFile((Workbook)workbook, OSFCheckUtil.getFile("checkOsfImplCassIsMoblie.xlsx"));
            } else {
                OSFCheckUtil.writeExcelFile((Workbook)workbook, OSFCheckUtil.getFile("osfImplClassNotExists.xlsx"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void fillHeaders(Row row) {
        String[] headers = new String[]{"OSF\u670d\u52a1\u540d\u79f0", "\u6240\u5c5e\u9886\u57df", "\u72b6\u6001", "\u5217\u51fa\u539f\u56e0"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static String getFile(String fileName) {
        StringBuilder dir = new StringBuilder();
        dir.append(SHRSyssettingUtil.getIotmpdir());
        File f = new File(dir.toString());
        if (!f.exists()) {
            f.mkdir();
        }
        StringBuilder filePath0 = new StringBuilder();
        filePath0.append(dir.toString()).append(File.separator).append(fileName);
        return filePath0.toString();
    }

    private static void writeExcelFile(Workbook workbook, String fileName) throws SHRWebException {
        FileOutputStream fileOut = null;
        try {
            File f = new File(fileName);
            if (f.exists()) {
                f.delete();
            } else {
                f.createNewFile();
            }
            fileOut = new FileOutputStream(f);
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != fileOut) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                workbook.close();
                workbook = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

