/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.IUIViewExt;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewExtCollection;
import com.kingdee.shr.base.syssetting.UIViewExtFactory;
import com.kingdee.shr.base.syssetting.UIViewExtInfo;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.permission.CheckFunctionPermissionUtil;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ListUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewAndPermItemBean;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ZipUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdom2.Document;
import org.jdom2.Element;

public class UIViewAndPermItemUtil {
    private static Logger logger = Logger.getLogger(UIViewAndPermItemUtil.class);
    private static String excelFileName = "premItemUrl.xlsx";
    private static String sqlFileName = "premItemUrl.sql";

    private UIViewAndPermItemUtil() {
    }

    private static String getSQL(String filter, String domainNumber, boolean isInner) {
        StringBuffer s = new StringBuffer();
        s.append("SELECT t0.*\n");
        s.append(",t1.fid permItemUrlId,t1.fname permItemUrlName\n");
        s.append(",t2.fid permItemId,t2.fnumber permItemNumber,t2.fname permItemName,t2.falias_l2 permItemAlias,t2.flongnumber permItemLongnumber\n");
        s.append(" FROM (\n");
        s.append(" SELECT sbu.fid uiviewId,sbu.fuipk, '/dynamic.do?method=initalize#uri='||sbu.fuipk permItemUrl ,sbut.fname_l2 domainName,sbut.fnumber domainNumber, sbu.fname_l2 uiviewName \n");
        s.append(" FROM s_bs_uiview sbu\n");
        s.append(" left join S_BS_UIViewTree sbut on sbut.fid = sbu.ftreeid\n");
        s.append(" where sbu.ftype ").append(filter).append(" and sbu.finner = ");
        if (isInner) {
            s.append(1);
        } else {
            s.append(0);
        }
        s.append(" and sbu.FUIPK not in(").append(UIViewAndPermItemUtil.getUipkWhiteList()).append(")");
        s.append("\n");
        if (!StringUtils.isEmpty((String)domainNumber)) {
            s.append(" and sbut.fnumber =? \n");
        }
        s.append(" ) t0\n");
        s.append(" left join t_pm_permitemurl t1 on t0.permItemUrl = t1.FURL \n");
        s.append(" left join t_pm_permitem t2 on t1.fparentid = t2.fid \n");
        return s.toString();
    }

    private static String getUipkWhiteList() {
        Set<String> us = CheckFunctionPermissionUtil.getUipkWhiteList();
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String key : us) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("'").append(key).append("'");
            ++index;
        }
        return sb.toString();
    }

    public static void aysUIViewAndPermItem(Context ctx, String domianNumber, boolean isInner) throws SHRWebException {
        HashMap<String, UIViewAndPermItemBean> existsPermItemOnListView = new HashMap<String, UIViewAndPermItemBean>();
        HashMap<String, UIViewAndPermItemBean> notExistsPermItemOnListView = new HashMap<String, UIViewAndPermItemBean>();
        HashMap<String, UIViewAndPermItemBean> existsPermItemOnFormView = new HashMap<String, UIViewAndPermItemBean>();
        HashMap<String, UIViewAndPermItemBean> existsPermItemOnOtherView = new HashMap<String, UIViewAndPermItemBean>();
        HashMap<String, UIViewAndPermItemBean> notExistsPermItemOnFormView = new HashMap<String, UIViewAndPermItemBean>();
        HashSet<String> formViewGenSql = new HashSet<String>();
        UIViewAndPermItemUtil.initListViewData(ctx, existsPermItemOnListView, notExistsPermItemOnListView, domianNumber, isInner);
        UIViewAndPermItemUtil.initFormViewData(ctx, notExistsPermItemOnFormView, existsPermItemOnFormView, domianNumber, isInner);
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        UIViewAndPermItemUtil.outCoreViewData(ctx, domianNumber, (Workbook)workbook, existsPermItemOnOtherView, isInner);
        UIViewAndPermItemUtil.outWizardViewData(ctx, domianNumber, (Workbook)workbook, existsPermItemOnOtherView, isInner);
        UIViewAndPermItemUtil.outListViewData(ctx, notExistsPermItemOnListView, (Workbook)workbook);
        UIViewAndPermItemUtil.outFormViewSqlFile(ctx, existsPermItemOnListView, notExistsPermItemOnFormView, formViewGenSql);
        UIViewAndPermItemUtil.outFormViewData(ctx, notExistsPermItemOnFormView, formViewGenSql, (Workbook)workbook);
        UIViewAndPermItemUtil.outputExistsUIView(ctx, existsPermItemOnListView, existsPermItemOnFormView, existsPermItemOnOtherView);
        UIViewAndPermItemUtil.writeExcelFile((Workbook)workbook, UIViewAndPermItemUtil.getFile("uiview_hasnot_permission.xlsx"));
        existsPermItemOnListView = null;
        existsPermItemOnFormView = null;
        existsPermItemOnOtherView = null;
        notExistsPermItemOnListView = null;
        notExistsPermItemOnFormView = null;
        formViewGenSql = null;
        StringBuffer filePath = new StringBuffer();
        filePath.append(SHRSyssettingUtil.getIotmpdir()).append(File.separator).append("permItemUrl");
        StringBuffer filePath0 = new StringBuffer();
        filePath0.append(SHRSyssettingUtil.getIotmpdir()).append(File.separator).append("permItemUrl.zip");
        File f = new File(filePath0.toString());
        if (f.exists()) {
            f.delete();
        } else {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ZipUtils.toZip(new String[]{filePath.toString()}, filePath0.toString(), true);
    }

    private static void outputExistsUIView(Context ctx, Map<String, UIViewAndPermItemBean> existsPermItemOnListView, Map<String, UIViewAndPermItemBean> existsPermItemOnFormView, Map<String, UIViewAndPermItemBean> existsPermItemOnOtherView) throws SHRWebException {
        UIViewAndPermItemBean each;
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        Sheet sheet = workbook.createSheet("existsdata");
        int rowindex = 0;
        Row row = sheet.createRow(rowindex++);
        UIViewAndPermItemUtil.fillSqlHeaders(row);
        for (Map.Entry<String, UIViewAndPermItemBean> entry : existsPermItemOnListView.entrySet()) {
            each = entry.getValue();
            row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.writeRowData(each, row);
        }
        for (Map.Entry<String, UIViewAndPermItemBean> entry : existsPermItemOnFormView.entrySet()) {
            each = entry.getValue();
            row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.writeRowData(each, row);
        }
        for (Map.Entry<String, UIViewAndPermItemBean> entry : existsPermItemOnOtherView.entrySet()) {
            each = entry.getValue();
            row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.writeRowData(each, row);
        }
        UIViewAndPermItemUtil.writeExcelFile((Workbook)workbook, UIViewAndPermItemUtil.getFile("uiview_exists_mapping.xlsx"));
    }

    private static void outWizardViewData(Context ctx, String domianNumber, Workbook workbook, Map<String, UIViewAndPermItemBean> existsPermItemOnOtherView, boolean isInner) throws SHRWebException {
        StringBuffer s = new StringBuffer();
        s.append(UIViewAndPermItemUtil.getSQL("= 'wizard'", domianNumber, isInner));
        try {
            IRowSet rs = null;
            HashMap<String, UIViewAndPermItemBean> notExistsPermItemOnWizardView = new HashMap<String, UIViewAndPermItemBean>();
            rs = !StringUtils.isEmpty((String)domianNumber) ? DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{domianNumber}) : DbUtil.executeQuery((Context)ctx, (String)s.toString());
            while (rs.next()) {
                UIViewAndPermItemBean bean = UIViewAndPermItemUtil.genUIViewAndPermItemBean(rs);
                if (StringUtils.isEmpty((String)bean.getPermItemId())) {
                    notExistsPermItemOnWizardView.put(bean.getUipk(), bean);
                    continue;
                }
                existsPermItemOnOtherView.put(bean.getUipk(), bean);
            }
            Sheet sheet = workbook.createSheet("wizard");
            int rowindex = 0;
            Row row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.fillHeaders(row);
            for (Map.Entry entry : notExistsPermItemOnWizardView.entrySet()) {
                UIViewAndPermItemBean bean = (UIViewAndPermItemBean)entry.getValue();
                row = sheet.createRow(rowindex++);
                UIViewAndPermItemUtil.fillCell(bean, row);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
    }

    private static void outCoreViewData(Context ctx, String domianNumber, Workbook workbook, Map<String, UIViewAndPermItemBean> existsPermItemOnOtherView, boolean isInner) throws SHRWebException {
        StringBuffer s = new StringBuffer();
        s.append(UIViewAndPermItemUtil.getSQL("= 'core'", domianNumber, isInner));
        try {
            IRowSet rs = null;
            HashMap<String, UIViewAndPermItemBean> notExistsPermItemOnCoreView = new HashMap<String, UIViewAndPermItemBean>();
            rs = !StringUtils.isEmpty((String)domianNumber) ? DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{domianNumber}) : DbUtil.executeQuery((Context)ctx, (String)s.toString());
            while (rs.next()) {
                UIViewAndPermItemBean bean = UIViewAndPermItemUtil.genUIViewAndPermItemBean(rs);
                if (StringUtils.isEmpty((String)bean.getPermItemId())) {
                    notExistsPermItemOnCoreView.put(bean.getUipk(), bean);
                    continue;
                }
                existsPermItemOnOtherView.put(bean.getUipk(), bean);
            }
            Sheet sheet = workbook.createSheet("core");
            int rowindex = 0;
            Row row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.fillHeaders(row);
            for (Map.Entry entry : notExistsPermItemOnCoreView.entrySet()) {
                UIViewAndPermItemBean bean = (UIViewAndPermItemBean)entry.getValue();
                row = sheet.createRow(rowindex++);
                UIViewAndPermItemUtil.fillCell(bean, row);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
    }

    private static void initListViewData(Context ctx, Map<String, UIViewAndPermItemBean> existsPermItemOnListView, Map<String, UIViewAndPermItemBean> notExistsPermItemOnListView, String domianNumber, boolean isInner) throws SHRWebException {
        String sql = UIViewAndPermItemUtil.getSQL("in ('list','dynamicList')", domianNumber, isInner);
        try {
            IRowSet rs = null;
            rs = !StringUtils.isEmpty((String)domianNumber) ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{domianNumber}) : DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                UIViewAndPermItemBean bean = UIViewAndPermItemUtil.genUIViewAndPermItemBean(rs);
                if (StringUtils.isEmpty((String)bean.getPermItemUrlId())) {
                    notExistsPermItemOnListView.put(bean.getUipk(), bean);
                    continue;
                }
                existsPermItemOnListView.put(bean.getUipk(), bean);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
    }

    private static void initFormViewData(Context ctx, Map<String, UIViewAndPermItemBean> notExistsPermItemOnFormView, Map<String, UIViewAndPermItemBean> existsPermItemOnFormView, String domianNumber, boolean isInner) throws SHRWebException {
        StringBuffer s = new StringBuffer();
        s.append(UIViewAndPermItemUtil.getSQL("= 'form'", domianNumber, isInner));
        try {
            IRowSet rs = null;
            rs = !StringUtils.isEmpty((String)domianNumber) ? DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])new Object[]{domianNumber}) : DbUtil.executeQuery((Context)ctx, (String)s.toString());
            while (rs.next()) {
                UIViewAndPermItemBean bean = UIViewAndPermItemUtil.genUIViewAndPermItemBean(rs);
                if (StringUtils.isEmpty((String)bean.getPermItemId())) {
                    notExistsPermItemOnFormView.put(bean.getUipk(), bean);
                    continue;
                }
                existsPermItemOnFormView.put(bean.getUipk(), bean);
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
    }

    private static void outListViewData(Context ctx, Map<String, UIViewAndPermItemBean> notExistsPermItemOnListView, Workbook workbook) throws SHRWebException {
        Sheet sheet = workbook.createSheet("list");
        int rowindex = 0;
        Row row = sheet.createRow(rowindex++);
        UIViewAndPermItemUtil.fillHeaders(row);
        for (Map.Entry<String, UIViewAndPermItemBean> entry : notExistsPermItemOnListView.entrySet()) {
            UIViewAndPermItemBean bean = entry.getValue();
            row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.fillCell(bean, row);
        }
    }

    private static void outFormViewSqlFile(Context ctx, Map<String, UIViewAndPermItemBean> existsPermItemOnListView, Map<String, UIViewAndPermItemBean> notExistsPermItemOnFormView, Set<String> formViewGenSql) throws SHRWebException {
        StringBuffer sb;
        UIViewAndPermItemBean list;
        HashMap<String, StringBuffer> sqlOutput = new HashMap<String, StringBuffer>();
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        Sheet sheet = workbook.createSheet("gendata");
        int rowindex = 0;
        Row row = sheet.createRow(rowindex++);
        UIViewAndPermItemUtil.fillSqlHeaders(row);
        for (Map.Entry<String, UIViewAndPermItemBean> entry : existsPermItemOnListView.entrySet()) {
            ListUIViewInfo listUIViewInfo = (ListUIViewInfo)UIViewUtil.getUIViewInfoByUIPK(ctx, entry.getKey());
            if (StringUtils.isEmpty((String)listUIViewInfo.getEditView()) || !notExistsPermItemOnFormView.containsKey(listUIViewInfo.getEditView())) continue;
            UIViewAndPermItemBean form = notExistsPermItemOnFormView.get(listUIViewInfo.getEditView());
            list = entry.getValue();
            sb = (StringBuffer)sqlOutput.get(form.getDomainNumber());
            if (null == sb) {
                sb = new StringBuffer();
                sqlOutput.put(form.getDomainNumber(), sb);
            }
            row = sheet.createRow(rowindex++);
            sb.append(UIViewAndPermItemUtil.genPermItemUrlSQL(ctx, form, list, row));
            formViewGenSql.add(form.getUipk());
        }
        for (Map.Entry<String, UIViewAndPermItemBean> entry : notExistsPermItemOnFormView.entrySet()) {
            if (formViewGenSql.contains(entry.getKey())) continue;
            UIViewAndPermItemBean form = entry.getValue();
            com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo formUIViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, entry.getKey());
            list = existsPermItemOnListView.get(formUIViewInfo.getModel() + ".list");
            if (null == list) continue;
            sb = (StringBuffer)sqlOutput.get(form.getDomainNumber());
            if (null == sb) {
                sb = new StringBuffer();
                sqlOutput.put(form.getDomainNumber(), sb);
            }
            row = sheet.createRow(rowindex++);
            sb.append(UIViewAndPermItemUtil.genPermItemUrlSQL(ctx, form, list, row));
            formViewGenSql.add(form.getUipk());
        }
        for (Map.Entry<String, UIViewAndPermItemBean> entry : sqlOutput.entrySet()) {
            UIViewAndPermItemUtil.writeSQLFile(((StringBuffer)((Object)entry.getValue())).toString(), entry.getKey() + ".sql");
        }
        UIViewAndPermItemUtil.writeExcelFile((Workbook)workbook, UIViewAndPermItemUtil.getFile("uiview_gensql_mapping.xlsx"));
    }

    private static void fillSqlHeaders(Row row) {
        String[] headers = new String[]{"\u89c6\u56fe\u5206\u7c7b\u540d\u79f0", "\u89c6\u56fe\u5206\u7c7b\u7f16\u7801", "\u5f53\u524d\u89c6\u56fe\u540d\u79f0", "\u5f53\u524dUIPK", "URL", "\u6302\u9760\u6743\u9650\u9879ID", "\u6302\u9760\u6743\u9650\u9879\u540d\u79f0", "\u6302\u9760\u6743\u9650\u9879\u7f16\u7801", "\u6302\u9760\u89c6\u56fe\u540d\u79f0", "\u6302\u9760UIPK", "\u6302\u9760URL"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static void outFormViewData(Context ctx, Map<String, UIViewAndPermItemBean> notExistsPermItemOnFormView, Set<String> formViewGenSql, Workbook workbook) throws SHRWebException {
        Sheet sheet = workbook.createSheet("form");
        int rowindex = 0;
        Row row = sheet.createRow(rowindex++);
        UIViewAndPermItemUtil.fillHeaders(row);
        for (Map.Entry<String, UIViewAndPermItemBean> entry : notExistsPermItemOnFormView.entrySet()) {
            if (formViewGenSql.contains(entry.getKey())) continue;
            UIViewAndPermItemBean bean = entry.getValue();
            row = sheet.createRow(rowindex++);
            UIViewAndPermItemUtil.fillCell(bean, row);
        }
    }

    private static void fillHeaders(Row row) {
        String[] headers = new String[]{"\u9886\u57df\u7f16\u7801", "\u9886\u57df\u540d\u79f0", "UIPK", "\u89c6\u56fe\u540d\u79f0", "URL", "\u6743\u9650\u9879ID"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static void fillCell(UIViewAndPermItemBean bean, Row row) {
        Cell cell0 = row.createCell(0);
        cell0.setCellValue(bean.getDomainNumber());
        Cell cell1 = row.createCell(1);
        cell1.setCellValue(bean.getDomainName());
        Cell cell2 = row.createCell(2);
        cell2.setCellValue(bean.getUipk());
        Cell cell3 = row.createCell(3);
        cell3.setCellValue(bean.getUiviewName());
        Cell cell4 = row.createCell(4);
        cell4.setCellValue(bean.getPermItemUrl());
    }

    private static UIViewAndPermItemBean genUIViewAndPermItemBean(IRowSet rs) throws SQLException {
        UIViewAndPermItemBean bean = new UIViewAndPermItemBean();
        bean.setUiviewId(rs.getString("uiviewId"));
        bean.setUipk(rs.getString("fuipk"));
        bean.setPermItemUrl(rs.getString("permItemUrl"));
        bean.setDomainName(rs.getString("domainName"));
        bean.setDomainNumber(rs.getString("domainNumber"));
        bean.setPermItemUrlId(rs.getString("permItemUrlId"));
        bean.setPermItemUrlName(rs.getString("permItemUrlName"));
        bean.setPermItemId(rs.getString("permItemId"));
        bean.setPermItemNumber(rs.getString("permItemNumber"));
        bean.setPermItemName(rs.getString("permItemName"));
        bean.setPermItemAlias(rs.getString("permItemAlias"));
        bean.setPermItemLongnumber(rs.getString("permItemLongnumber"));
        bean.setUiviewName(rs.getString("uiviewName"));
        return bean;
    }

    private static String getFile(String fileName) {
        StringBuffer dir = new StringBuffer();
        dir.append(SHRSyssettingUtil.getIotmpdir()).append(File.separator).append("permItemUrl");
        File f = new File(dir.toString());
        if (!f.exists()) {
            f.mkdir();
        }
        StringBuffer filePath0 = new StringBuffer();
        filePath0.append(dir.toString()).append(File.separator).append(fileName);
        return filePath0.toString();
    }

    private static String getAttachmentFile(String fileName) {
        StringBuffer dir = new StringBuffer();
        dir.append(SHRSyssettingUtil.getIotmpdir());
        File f = new File(dir.toString());
        if (!f.exists()) {
            f.mkdir();
        }
        StringBuffer filePath0 = new StringBuffer();
        filePath0.append(dir.toString()).append(File.separator).append(fileName);
        return filePath0.toString();
    }

    private static void writeSQLFile(String text, String fileName) throws SHRWebException {
        FileOutputStream fileOut = null;
        try {
            File f = new File(UIViewAndPermItemUtil.getFile(fileName));
            if (f.exists()) {
                f.delete();
            } else {
                f.createNewFile();
            }
            fileOut = new FileOutputStream(f);
            fileOut.write(text.getBytes());
            fileOut.flush();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != fileOut) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void writeExcelFile(Workbook workbook, String fileName) throws SHRWebException {
        FileOutputStream fileOut = null;
        try {
            File f = new File(fileName);
            if (f.exists()) {
                f.delete();
            } else {
                f.createNewFile();
            }
            fileOut = new FileOutputStream(f);
            workbook.write((OutputStream)fileOut);
            fileOut.flush();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != fileOut) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                workbook.close();
                workbook = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void genSQlFileByReadExcel() throws SHRWebException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(SHRSyssettingUtil.getEASHomePath() + File.separator + excelFileName);
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)input);
            int sheetNum = xssfWorkbook.getNumberOfSheets();
            StringBuilder sBuilder = new StringBuilder();
            for (int i = 0; i < sheetNum; ++i) {
                XSSFSheet sheet = xssfWorkbook.getSheetAt(i);
                if (null == sheet) continue;
                int maxRow = sheet.getLastRowNum();
                for (int row = 1; row <= maxRow; ++row) {
                    ArrayList<String> list = new ArrayList<String>();
                    int maxRol = sheet.getRow(row).getLastCellNum();
                    for (int col = 0; col < maxRol; ++col) {
                        String rows = sheet.getRow(row).getCell(col).toString();
                        if (StringUtils.isEmpty((String)rows)) continue;
                        list.add(rows);
                    }
                    String sql = UIViewAndPermItemUtil.genPermItemUrlSql(list);
                    sBuilder.append(sql).append("\n");
                }
            }
            UIViewAndPermItemUtil.writeSQLFile(sBuilder.toString());
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    private static void writeSQLFile(String text) throws SHRWebException {
        FileOutputStream fileOut = null;
        try {
            File f = new File(UIViewAndPermItemUtil.getFile(sqlFileName));
            if (f.exists()) {
                f.delete();
            } else {
                f.createNewFile();
            }
            fileOut = new FileOutputStream(f);
            fileOut.write(text.getBytes());
            fileOut.flush();
        }
        catch (FileNotFoundException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            if (null != fileOut) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String genPermItemUrlSql(List<String> list) {
        StringBuilder sb = new StringBuilder();
        Calendar canlender = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        sb.append("--").append(list.get(2)).append("\n");
        sb.append("if not exists(select * from t_pm_permitemurl where FUrl='").append(list.get(3)).append("')\n");
        sb.append("insert into t_pm_permitemurl(FUrl, FParentID, FUipk, FAction, FID, FName)\n");
        String id = BOSUuid.create((String)"8AFAE318").toString();
        sb.append("values(N'").append(list.get(3)).append("', '").append(list.get(4)).append("', null, null, '").append(id).append("', N'").append(list.get(2)).append("system").append("_").append(simpleDateFormat.format(canlender.getTime())).append("');\n");
        return sb.toString();
    }

    private static void writeRowData(UIViewAndPermItemBean each, Row row) {
        String[] values = new String[]{each.getDomainName(), each.getDomainNumber(), each.getUiviewName(), each.getUipk(), each.getPermItemUrl(), each.getPermItemId(), each.getPermItemName(), each.getPermItemNumber(), each.getUiviewName(), each.getUipk(), each.getPermItemUrl()};
        UIViewAndPermItemUtil.writeRowData(values, row);
    }

    private static void writeRowData(String[] values, Row row) {
        int index = 0;
        for (String value : values) {
            Cell cell = row.createCell(index++);
            cell.setCellValue(value);
        }
    }

    private static String genPermItemUrlSQL(Context ctx, UIViewAndPermItemBean form, UIViewAndPermItemBean list, Row row) throws SHRWebException {
        String[] values = new String[]{form.getDomainName(), form.getDomainNumber(), form.getUiviewName(), form.getUipk(), form.getPermItemUrl(), list.getPermItemId(), list.getPermItemName(), list.getPermItemNumber(), list.getUiviewName(), list.getUipk(), list.getPermItemUrl()};
        UIViewAndPermItemUtil.writeRowData(values, row);
        StringBuffer sb = new StringBuffer();
        sb.append("if not exists(select * from t_pm_permitemurl where FUrl='").append(form.getPermItemUrl()).append("')\n");
        sb.append("insert into t_pm_permitemurl(FUrl, FParentID, FUipk, FAction, FID, FName)\n");
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, form.getUipk());
        String urlName = uiviewInfo.getName() + "_\u67e5\u770b_" + form.getDomainNumber() + "_" + DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        String id = BOSUuid.create((String)"8AFAE318").toString();
        sb.append("values(N'").append(form.getPermItemUrl()).append("', '").append(list.getPermItemId()).append("', null, null, '").append(id).append("', N'").append(urlName).append("');\n");
        return sb.toString();
    }

    public static void aynUIViewAttachment(Context ctx, boolean isInner) throws SHRWebException {
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            Sheet sheet = workbook.createSheet("\u9700\u624b\u52a8\u8c03\u6574\u7684\u591a\u9644\u4ef6\u89c6\u56fe");
            Sheet sheet1 = workbook.createSheet("\u5df2\u81ea\u52a8\u8c03\u6574\u7684\u591a\u9644\u4ef6\u89c6\u56fe");
            int rowindex = 0;
            int rowindex1 = 0;
            Row row = sheet.createRow(rowindex++);
            Row row1 = sheet1.createRow(rowindex1++);
            UIViewAndPermItemUtil.fillAttachHeaders(row);
            UIViewAndPermItemUtil.fillAttachHeaders1(row1);
            if (isInner) {
                IUIView iUIView = UIViewFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("inner", (Object)true));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)UIType.F7, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)UIType.search, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("type", (Object)UIType.wizard, CompareType.NOTEQUALS));
                view.setFilter(filter);
                SelectorItemCollection seletor = new SelectorItemCollection();
                seletor.add(new SelectorItemInfo("uipk"));
                seletor.add(new SelectorItemInfo("model"));
                seletor.add(new SelectorItemInfo("name"));
                seletor.add(new SelectorItemInfo("content"));
                seletor.add(new SelectorItemInfo("tree.name"));
                seletor.add(new SelectorItemInfo("tree.number"));
                view.setSelector(seletor);
                UIViewCollection coll = iUIView.getUIViewCollection(view);
                if (null != coll && !coll.isEmpty()) {
                    int total = coll.size();
                    for (int i = 0; i < total; ++i) {
                        UIViewInfo bean = coll.get(i);
                        ArrayList<String[]> l = new ArrayList<String[]>();
                        String config = UIViewAndPermItemUtil.getDatas(ctx, bean, bean.getContent(), l);
                        if (!StringUtils.isEmpty((String)config)) {
                            UIViewInfo updateInfo = new UIViewInfo();
                            updateInfo.setId(bean.getId());
                            updateInfo.setContent(config);
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("content"));
                            iUIView.updatePartial((CoreBaseInfo)updateInfo, selector);
                            row1 = sheet1.createRow(rowindex1++);
                            UIViewAndPermItemUtil.fillAttachCell(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName()}, row1);
                        }
                        if (l.isEmpty()) continue;
                        for (String[] each : l) {
                            row = sheet.createRow(rowindex++);
                            UIViewAndPermItemUtil.fillAttachCell(each, row);
                        }
                    }
                }
            } else {
                IUIViewExt iUIViewExt = UIViewExtFactory.getLocalInstance((Context)ctx);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.type", (Object)UIType.F7, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("parent.type", (Object)UIType.search, CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("parent.type", (Object)UIType.wizard, CompareType.NOTEQUALS));
                view.setFilter(filter);
                SelectorItemCollection seletor = new SelectorItemCollection();
                seletor.add(new SelectorItemInfo("parent.uipk"));
                seletor.add(new SelectorItemInfo("parent.model"));
                seletor.add(new SelectorItemInfo("parent.name"));
                seletor.add(new SelectorItemInfo("content"));
                seletor.add(new SelectorItemInfo("parent.id"));
                seletor.add(new SelectorItemInfo("parent.tree.name"));
                seletor.add(new SelectorItemInfo("parent.tree.number"));
                view.setSelector(seletor);
                UIViewExtCollection coll = iUIViewExt.getUIViewExtCollection(view);
                if (null != coll && !coll.isEmpty()) {
                    int total = coll.size();
                    for (int i = 0; i < total; ++i) {
                        UIViewExtInfo bean = coll.get(i);
                        ArrayList<String[]> l = new ArrayList<String[]>();
                        String config = UIViewAndPermItemUtil.getDatas(ctx, bean.getParent(), bean.getContent(), l);
                        if (!StringUtils.isEmpty((String)config)) {
                            UIViewExtInfo updateInfo = new UIViewExtInfo();
                            updateInfo.setId(bean.getId());
                            updateInfo.setContent(config);
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("content"));
                            iUIViewExt.updatePartial((CoreBaseInfo)updateInfo, selector);
                            row1 = sheet1.createRow(rowindex1++);
                            UIViewAndPermItemUtil.fillAttachCell(new String[]{bean.getParent().getTree().getNumber(), bean.getParent().getTree().getName(), bean.getParent().getUipk(), bean.getParent().getName()}, row1);
                        }
                        if (l.isEmpty()) continue;
                        for (String[] each : l) {
                            row = sheet.createRow(rowindex++);
                            UIViewAndPermItemUtil.fillAttachCell(each, row);
                        }
                    }
                }
            }
            UIViewAndPermItemUtil.writeExcelFile((Workbook)workbook, UIViewAndPermItemUtil.getAttachmentFile("uiview_attachment_result.xlsx"));
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
    }

    public static String getAttachmentFileName() {
        return "\u591a\u9644\u4ef6\u89c6\u56fe\u68c0\u67e5\u6e05\u5355.xlsx";
    }

    private static String getDatas(Context ctx, UIViewInfo bean, String config, List<String[]> l) throws BOSException {
        if (StringUtils.isEmpty((String)config)) {
            return null;
        }
        Document doc = XMLUtil.parseXML((String)config);
        Element rootElement = doc.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        XMLUtil.getElements((Element)rootElement, (String)"attachment", list);
        if (list.isEmpty() || list.size() == 1) {
            return null;
        }
        HashMap<String, Integer> attachmentMap = new HashMap<String, Integer>();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        UIViewUtil.checkAttachmentDump(list, attachmentMap, itemMap);
        ISHRAttachmentExt iSHRAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        for (Element e : list) {
            List ll = e.getChildren("item");
            String attachmentField = e.getAttributeValue("field");
            if (StringUtils.isEmpty((String)attachmentField)) {
                attachmentField = "";
            }
            if (null == ll || ll.isEmpty()) {
                if (StringUtils.isEmpty((String)attachmentField)) continue;
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bunding", (Object)("%" + bean.getUipk() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("propertyName", (Object)attachmentField, CompareType.EQUALS));
                if ((Integer)itemMap.get(attachmentField) <= 1) continue;
                try {
                    String message;
                    if (iSHRAttachmentExt.exists(filter)) {
                        message = UIViewAndPermItemUtil.getProposal("attachment", attachmentField, (Integer)itemMap.get(attachmentField) - 1, "1");
                        l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u5426", "", message});
                        continue;
                    }
                    message = UIViewAndPermItemUtil.getProposal("attachment", attachmentField, (Integer)itemMap.get(attachmentField) - 1, "2");
                    l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u5426", "", message});
                }
                catch (EASBizException e1) {
                    String message = UIViewAndPermItemUtil.getProposal("attachment", attachmentField, (Integer)itemMap.get(attachmentField) - 1, "2");
                    l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u5426", "", message});
                }
                continue;
            }
            for (Element ee : ll) {
                String itemField = ee.getAttributeValue("field");
                if (StringUtils.isEmpty((String)itemField)) {
                    itemField = "";
                }
                if ((Integer)itemMap.get(itemField) <= 1 || StringUtils.isEmpty((String)itemField)) continue;
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bunding", (Object)("%" + bean.getUipk() + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("propertyName", (Object)itemField, CompareType.EQUALS));
                try {
                    String message;
                    if (iSHRAttachmentExt.exists(filter)) {
                        message = UIViewAndPermItemUtil.getProposal("item", itemField, (Integer)itemMap.get(itemField) - 1, "1");
                        l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u662f", itemField, message});
                        continue;
                    }
                    message = UIViewAndPermItemUtil.getProposal("item", itemField, (Integer)itemMap.get(itemField) - 1, "2");
                    l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u662f", itemField, message});
                }
                catch (EASBizException e1) {
                    String message = UIViewAndPermItemUtil.getProposal("item", itemField, (Integer)itemMap.get(itemField) - 1, "3");
                    l.add(new String[]{bean.getTree().getNumber(), bean.getTree().getName(), bean.getUipk(), bean.getName(), attachmentField, "\u662f", itemField, message});
                }
            }
        }
        if (l.isEmpty()) {
            UIViewUtil.initAttachmentForUnFill(list, attachmentMap, itemMap);
            return XMLUtil.getXMLOutputter().outputString(doc);
        }
        return null;
    }

    private static void fillAttachCell(String[] data, Row row) {
        int i = 0;
        for (String s : data) {
            row.createCell(i).setCellValue(s);
            ++i;
        }
    }

    private static String getProposal(String mac, String fieldValue, int count, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(mac).append("\u7684\u5c5e\u6027field\u7684\u503c[").append(fieldValue).append("]\u5b58\u5728 ").append(count).append(" \u6b21\u91cd\u590d,");
        if ("1".equals(type)) {
            sb.append("\u4e14\u6709\u5355\u636e\u5df2\u7ecf\u4e0a\u4f20\u9644\u4ef6\uff0c\u53ef\u80fd\u9700\u8981\u8fdb\u884c\u9644\u4ef6\u6570\u636e\u8c03\u6574\uff0c\u9700\u4e13\u5458\u786e\u8ba4\u3002\n");
            sb.append("\u6307\u5bfc\u65b9\u6848\uff1a\n");
            sb.append("1\u3001\u7cfb\u7edf\u7528\u6237administrator\u767b\u5f55:\n");
            sb.append("\u89c6\u56fe-->\u6b64\u884cuipk\u641c\u7d22\u89c6\u56fe-->\u70b9\u51fb\u8fdb\u5165\u89c6\u56fe\u53ef\u89c6\u5316\u754c\u9762\u8c03\u6574attachment\u6216\u8005item\u7684field\u503c\uff0c\u786e\u4fddfield\u503c\u4e0d\u91cd\u590d-->\u4fdd\u5b58\n");
            sb.append("2\u3001\u4e13\u5458\u7528\u6237\u767b\u5f55\u5230\u5bf9\u5e94\u529f\u80fd\u754c\u9762\u8c03\u6574\u9519\u4e71\u9644\u4ef6\uff1a\n");
            sb.append("\u6b64uipk\u5bf9\u5e94\u5355\u636e\u754c\u9762-->\u67e5\u770b\u662f\u5426\u5b58\u5728\u9644\u4ef6\u6302\u8f7d\u4f4d\u7f6e\u51fa\u9519-->\u5982\u5b58\u5728\u8bf7\u4e0b\u8f7d\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        } else if ("2".equals(type)) {
            sb.append("\u4e14\u6709\u5355\u636e\u5df2\u7ecf\u4e0a\u4f20\u9644\u4ef6\uff0c\u53ef\u80fd\u9700\u8981\u8fdb\u884c\u9644\u4ef6\u6570\u636e\u8c03\u6574\uff0c\u9700\u4e13\u5458\u786e\u8ba4\u3002\n");
            sb.append("\u6307\u5bfc\u65b9\u6848\uff1a\n");
            sb.append("1\u3001\u7cfb\u7edf\u7528\u6237administrator\u767b\u5f55:\n");
            sb.append("\u89c6\u56fe-->\u6b64\u884cuipk\u641c\u7d22\u89c6\u56fe-->\u70b9\u51fb\u8fdb\u5165\u89c6\u56fe\u53ef\u89c6\u5316\u754c\u9762\u8c03\u6574attachment\u6216\u8005item\u7684field\u503c\uff0c\u786e\u4fddfield\u503c\u4e0d\u91cd\u590d-->\u4fdd\u5b58\u3002");
        } else if ("3".equals(type)) {
            sb.append("\u9700\u624b\u5de5\u8c03\u6574\u3002\n");
            sb.append("\u6307\u5bfc\u65b9\u6848\uff1a\n");
            sb.append("1\u3001\u7cfb\u7edf\u7528\u6237administrator\u767b\u5f55:\n");
            sb.append("\u89c6\u56fe-->\u6b64\u884cuipk\u641c\u7d22\u89c6\u56fe-->\u70b9\u51fb\u8fdb\u5165\u89c6\u56fe\u53ef\u89c6\u5316\u754c\u9762\u8c03\u6574attachment\u6216\u8005item\u7684field\u503c\uff0c\u786e\u4fddfield\u503c\u4e0d\u91cd\u590d-->\u4fdd\u5b58\n");
            sb.append("2\u3001\u4e13\u5458\u7528\u6237\u767b\u5f55\u5230\u5bf9\u5e94\u529f\u80fd\u754c\u9762\u8c03\u6574\u9519\u4e71\u9644\u4ef6\uff1a\n");
            sb.append("\u6b64uipk\u5bf9\u5e94\u5355\u636e\u754c\u9762-->\u67e5\u770b\u662f\u5426\u5b58\u5728\u9644\u4ef6\u6302\u8f7d\u4f4d\u7f6e\u51fa\u9519-->\u5982\u5b58\u5728\u8bf7\u4e0b\u8f7d\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        return sb.toString();
    }

    private static void fillAttachHeaders(Row row) {
        String[] headers = new String[]{"\u9886\u57df\u7f16\u7801", "\u9886\u57df\u540d\u79f0", "UIPK", "\u89c6\u56fe\u540d\u79f0", "attachment\u5c5e\u6027field\u503c", "\u662f\u5426\u6709item\u5b50\u9879", "item\u5c5e\u6027field\u503c", "\u8c03\u6574\u5efa\u8bae"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }

    private static void fillAttachHeaders1(Row row) {
        String[] headers = new String[]{"\u9886\u57df\u7f16\u7801", "\u9886\u57df\u540d\u79f0", "UIPK", "\u89c6\u56fe\u540d\u79f0"};
        int total = headers.length;
        for (int i = 0; i < total; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
        }
    }
}

