/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.view.converter;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IUIViewConverter;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Map;

public abstract class AbstractUIViewConverter
implements IUIViewConverter {
    protected UIViewInfo dbUIViewInfo;
    protected Context ctx;

    public AbstractUIViewConverter(Context ctx) {
        this.ctx = ctx;
    }

    public AbstractUIViewConverter(UIViewInfo dbUIViewInfo, Context ctx) {
        this.dbUIViewInfo = dbUIViewInfo;
        this.ctx = ctx;
    }

    @Override
    public com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo exec() throws SHRWebException {
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = this.createUIViewInfo();
        this.convertViewInfo(viewInfo);
        return viewInfo;
    }

    protected com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo createUIViewInfo() throws SHRWebException {
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = this.getUIViewInfo();
        viewInfo.setId(this.dbUIViewInfo.getId().toString());
        viewInfo.setName(this.dbUIViewInfo.getName());
        if (!StringUtils.isEmpty((String)this.dbUIViewInfo.getExtend())) {
            viewInfo.setContent(this.dbUIViewInfo.getExtend());
        } else {
            viewInfo.setContent(this.dbUIViewInfo.getContent());
        }
        viewInfo.setModel(this.dbUIViewInfo.getModel());
        viewInfo.setEntityName(viewInfo.getModel());
        viewInfo.setType(this.dbUIViewInfo.getType().getValue());
        viewInfo.setUri(this.dbUIViewInfo.getUri());
        viewInfo.setUipk(this.dbUIViewInfo.getUipk());
        viewInfo.setVarDefine(this.dbUIViewInfo.getVarDefine());
        viewInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        return viewInfo;
    }

    protected void convertViewInfo(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        if (StringUtils.isEmpty((String)viewInfo.getContent())) {
            return;
        }
        String content = this.replaceVariable(viewInfo.getContent(), viewInfo.getVarDefine(this.ctx));
        viewInfo.setContent(content);
    }

    protected String replaceVariable(String content, Map<String, String> varDefine) {
        if (varDefine == null) {
            return content;
        }
        for (String key : varDefine.keySet()) {
            content = content.replace("${" + key + "}", varDefine.get(key));
        }
        return content;
    }
}

