/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.view.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.component.commonquery.CommonQueryHelper;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.sensitive.IShrSensitiveService;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceFactory;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.dynamic.model.AttachMentInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.BreadcrumbInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ButtonInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.CoreUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.ListUIViewConfigDefaultTagHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.AbstractUIViewConverter;
import com.kingdee.shr.base.syssetting.web.handler.CoreHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.LocaleUtils;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class CoreUIViewConverter
extends AbstractUIViewConverter {
    private static final Logger logger = Logger.getLogger(CoreUIViewConverter.class);

    public CoreUIViewConverter(Context ctx) {
        super(ctx);
    }

    public CoreUIViewConverter(UIViewInfo dbUIViewInfo, Context ctx) {
        super(dbUIViewInfo, ctx);
    }

    @Override
    public com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfo() {
        return new CoreUIViewInfo();
    }

    @Override
    protected void convertViewInfo(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        super.convertViewInfo(viewInfo);
        if (StringUtils.isEmpty((String)viewInfo.getContent())) {
            logger.error((Object)MessageFormat.format("uipk: [{0}] content is empty", SHRCheck.vaildLog((String)viewInfo.getUipk())));
            return;
        }
        Document doc = XMLUtil.parseXML(viewInfo.getContent());
        Element root = doc.getRootElement();
        CoreUIViewInfo coreUIViewInfo = (CoreUIViewInfo)viewInfo;
        this.assembleViewInfo(root, coreUIViewInfo);
        this.handleConfigContent(root, coreUIViewInfo);
        this.setButtonInfo(coreUIViewInfo);
        this.setAttachmentInfo(coreUIViewInfo);
    }

    private void setAttachmentInfo(CoreUIViewInfo uiviewInfo) throws SHRWebException {
        List<Element> list = XMLUtil.getAllElements("attachment", uiviewInfo);
        if (null == list || list.isEmpty()) {
            return;
        }
        LinkedHashMap<String, List<AttachMentInfo>> attachmentInfo = new LinkedHashMap<String, List<AttachMentInfo>>();
        uiviewInfo.setAttachMents(attachmentInfo);
        String att = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"attachment", (Context)this.ctx);
        int i = 0;
        for (Element e : list) {
            List items = e.getChildren("item");
            String fieldAttachment = e.getAttributeValue("field");
            if (StringUtils.isEmpty((String)fieldAttachment)) {
                fieldAttachment = "null0";
            }
            boolean isFirstAttachemt = true;
            if (i > 0) {
                isFirstAttachemt = false;
            }
            List<AttachMentInfo> listInfo = this.generateAttachmentListInfo(e, items, att, isFirstAttachemt);
            attachmentInfo.put(fieldAttachment, listInfo);
            ++i;
        }
    }

    private List<AttachMentInfo> generateAttachmentListInfo(Element element, List<Element> items, String att, boolean isFirstAttachemt) {
        ArrayList<AttachMentInfo> list = new ArrayList<AttachMentInfo>();
        if (items != null && !items.isEmpty()) {
            for (Element child : items) {
                list.add(this.generateAttachMentInfo(child, att, isFirstAttachemt));
            }
        } else {
            list.add(this.generateAttachMentInfo(element, att, isFirstAttachemt));
        }
        return list;
    }

    private AttachMentInfo generateAttachMentInfo(Element element, String att, boolean isFirstAttachemt) {
        AttachMentInfo info = new AttachMentInfo();
        info.setFirstAttachment(isFirstAttachemt);
        if (StringUtils.isEmpty((String)element.getAttributeValue("sorterItems"))) {
            info.setSorterItem("createTime ASC,name ASC");
        } else {
            info.setSorterItem(element.getAttributeValue("sorterItems"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("name"))) {
            info.setName(att);
        } else {
            info.setName(element.getAttributeValue("name"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("required"))) {
            info.setRequired("false");
        } else {
            info.setRequired(element.getAttributeValue("required"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("field"))) {
            info.setField("null0");
        } else {
            info.setField(element.getAttributeValue("field"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("readonly"))) {
            info.setReadonly("false");
        } else {
            info.setReadonly(element.getAttributeValue("readonly"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("onlyone"))) {
            info.setOnlyone("false");
        } else {
            info.setOnlyone(element.getAttributeValue("onlyone"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("isDeleteFile"))) {
            info.setIsDeleteFile("false");
        } else {
            info.setIsDeleteFile(element.getAttributeValue("isDeleteFile"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("uipk"))) {
            info.setUipk("");
        } else {
            info.setUipk(element.getAttributeValue("uipk"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("fileType"))) {
            info.setFileType("");
        } else {
            info.setFileType(element.getAttributeValue("fileType"));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("excludeFileType"))) {
            info.setExcludeFileType(this.mergeDefaultExcludeFileType(""));
        } else {
            info.setExcludeFileType(this.mergeDefaultExcludeFileType(element.getAttributeValue("excludeFileType")));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("maxSize"))) {
            info.setMaxSize("5");
        } else {
            info.setMaxSize(this.handlerMaxSize(element.getAttributeValue("maxSize")));
        }
        if (StringUtils.isEmpty((String)element.getAttributeValue("isMountFlowAttachment"))) {
            info.setIsMountFlowAttachment("false");
        } else {
            info.setIsMountFlowAttachment(element.getAttributeValue("isMountFlowAttachment"));
        }
        return info;
    }

    private String handlerMaxSize(String maxSize) {
        if (Integer.parseInt(maxSize) > 50) {
            return "50";
        }
        if (Integer.parseInt(maxSize) <= 0) {
            return "5";
        }
        return maxSize;
    }

    private String mergeDefaultExcludeFileType(String excludeFileType) {
        excludeFileType = StringUtils.isEmpty((String)excludeFileType) ? "exe,js,sh,jsp,ftl,bat,php,py,go,cpp,java,class,aspx" : "exe,js,sh,jsp,ftl,bat,php,py,go,cpp,java,class,aspx," + excludeFileType;
        return excludeFileType;
    }

    protected void setButtonInfo(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiviewInfo) throws SHRWebException {
        List<Element> dropDownButtonList;
        List<Element> list = XMLUtil.getAllElements("button", uiviewInfo);
        HashMap<String, ButtonInfo> buttons = new HashMap<String, ButtonInfo>();
        if (null != list && !list.isEmpty()) {
            uiviewInfo.setButtons(buttons);
            for (Element e : list) {
                ButtonInfo info = new ButtonInfo();
                info.setName(e.getAttributeValue("name"));
                info.setCaption(e.getAttributeValue("caption"));
                info.setDropDownButton(false);
                String visible = e.getAttributeValue("visible");
                String logenable = e.getAttributeValue("logenable");
                info.setVisible(true);
                info.setLogenable(true);
                if (!StringUtils.isEmpty((String)visible) && "false".equals(visible)) {
                    info.setVisible(false);
                }
                if (!StringUtils.isEmpty((String)logenable) && "false".equals(logenable)) {
                    info.setLogenable(false);
                }
                buttons.put(e.getAttributeValue("name"), info);
            }
        }
        if (null != (dropDownButtonList = XMLUtil.getAllElements("dropDownButton", uiviewInfo)) && !dropDownButtonList.isEmpty()) {
            for (Element eL : dropDownButtonList) {
                ButtonInfo info = new ButtonInfo();
                info.setName(eL.getAttributeValue("name"));
                info.setCaption(eL.getAttributeValue("caption"));
                info.setDropDownButton(true);
                info.setVisible(false);
                info.setLogenable(false);
                List cl = eL.getChildren("button");
                if (null != cl && !cl.isEmpty()) {
                    ArrayList<String> lll = new ArrayList<String>();
                    info.setDropDownButtons(lll);
                    for (Element clo : cl) {
                        lll.add(clo.getAttributeValue("name"));
                    }
                }
                buttons.put(eL.getAttributeValue("name"), info);
            }
        }
    }

    protected void assembleViewInfo(Element root, CoreUIViewInfo viewInfo) throws SHRWebException {
        String title = this.getTitle(root, viewInfo);
        viewInfo.setViewTitle(title);
        viewInfo.setPageTitle(this.getPageTitle(title));
        viewInfo.setJsClass(this.getJSClass(root, viewInfo));
        viewInfo.setScripts(this.getScripts(root));
        viewInfo.setStyles(this.getStyles(root));
        viewInfo.setHandler(this.getHandler(root, viewInfo));
        viewInfo.setRelatedField(this.getRelatedField(root));
        this.setBreadcrumb(root, viewInfo);
        Map properties = MetaDataUtil.getProperties((Context)this.ctx, (String)viewInfo.getEntityName());
        List<FieldInfo> fields = this.getFields(root, viewInfo, properties);
        viewInfo.setFields(fields);
        viewInfo.setPageParamConfig(this.getPageParamConfig(root, viewInfo));
        this.isEnableExpFilter(root, viewInfo);
    }

    private void isEnableExpFilter(Element root, CoreUIViewInfo viewInfo) {
        String v;
        Element element = this.getElement(root, "setExpFilter");
        if (element != null && !StringUtils.isEmpty((String)(v = element.getAttributeValue("value")))) {
            viewInfo.setEnableExpFilter(Boolean.parseBoolean(v));
        }
    }

    protected String getPageParamConfig(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "paramConfig");
        if (element != null) {
            String sourceElement = element.getTextNormalize().toString();
            return sourceElement;
        }
        return "";
    }

    protected String getTitle(Element root, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        Element element = this.getElement(root, "title");
        String title = null;
        if (element != null) {
            title = element.getAttributeValue("value");
            if (StringUtils.isEmpty((String)title)) {
                title = element.getText();
            }
            element.detach();
        }
        if (StringUtils.isEmpty(title)) {
            String entity = viewInfo.getModel();
            if (!StringUtils.isEmpty((String)entity)) {
                viewInfo.setEntityName(entity);
                EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entity));
                title = entityInfo.getAlias(this.ctx.getLocale());
            } else {
                title = viewInfo.getName();
            }
        }
        return title;
    }

    protected String getPageTitle(String viewTitle) {
        return viewTitle;
    }

    protected String handleConfigContent(Element root, CoreUIViewInfo uiViewInfo) throws SHRWebException {
        root = this.checkConfigContent(root, uiViewInfo);
        this.handleAssignTag(root);
        this.handleURIElement(root);
        String newContent = XMLUtil.getXMLOutputter().outputString(root);
        newContent = ListUIViewConfigDefaultTagHelper.addDefaultTagElement(uiViewInfo, newContent);
        uiViewInfo.setContent(newContent);
        return newContent;
    }

    private void handleAssignTag(Element root) {
        List<Element> assigns = new ArrayList<Element>();
        if ((assigns = XMLUtil.getElements(root, "assign", assigns)) != null && !assigns.isEmpty()) {
            for (Element element : assigns) {
                element.detach();
            }
            root.getChildren().addAll(0, assigns);
        }
    }

    private void setBreadcrumb(Element root, CoreUIViewInfo viewInfo) {
        Element element = this.getElement(root, "breadcrumb");
        if (element != null) {
            BreadcrumbInfo breadcrumb = new BreadcrumbInfo();
            breadcrumb.setFieldName(element.getAttributeValue("fieldName"));
            viewInfo.setBreadcrumb(breadcrumb);
        }
    }

    private Element checkConfigContent(Element rootElement, CoreUIViewInfo viewInfo) throws SHRWebException {
        Element mainElement = this.assembleMainElement(rootElement);
        this.assembleBodyElement(mainElement, rootElement);
        this.assembleHeaderElement(mainElement, viewInfo);
        return mainElement;
    }

    private Element assembleMainElement(Element rootElement) {
        Element mainElement = null;
        mainElement = "main".equalsIgnoreCase(rootElement.getName()) ? rootElement : new Element("main");
        return mainElement;
    }

    private void assembleBodyElement(Element mainElement, Element rootElement) {
        Element body = this.getElement(rootElement, "body");
        if (body == null) {
            body = new Element("body");
            rootElement.detach();
            body.addContent((Content)rootElement);
        } else {
            body.detach();
        }
        mainElement.addContent((Content)body);
    }

    protected Element assembleHeaderElement(Element mainElement, CoreUIViewInfo viewInfo) throws SHRWebException {
        Element header = this.getElement(mainElement, "header");
        if (header == null) {
            header = new Element("header");
        } else {
            header.detach();
        }
        this.handleToolbar(header, viewInfo);
        Element defaultHeader = this.getDefaultHeader(header, viewInfo);
        header = XMLUtil.mergeElement(defaultHeader, header);
        mainElement.getChildren().add(0, header);
        return header;
    }

    private Element getDefaultHeader(Element header, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        StringBuilder sb = new StringBuilder();
        sb.append("<header col=\"12\">\n");
        sb.append(this.getDefaultHeaderString(header));
        sb.append("</header>\n");
        header = XMLUtil.parseXML(sb.toString()).getRootElement();
        header.detach();
        return header;
    }

    protected String getDefaultHeaderString(Element header) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<breadcrumb colspan=\"12\" />\n");
        sb.append("\t<toolbar colspan=\"12\" />\n");
        return sb.toString();
    }

    private Element getDefaultGridToolBar(Element gridToolBar, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        StringBuilder sb = new StringBuilder();
        sb.append("<gridToolBar col=\"12\">\n");
        sb.append(this.getDefaultGridToolBarString(gridToolBar));
        sb.append("</gridToolBar>\n");
        gridToolBar = XMLUtil.parseXML(sb.toString()).getRootElement();
        gridToolBar.detach();
        return gridToolBar;
    }

    protected String getDefaultGridToolBarString(Element gridToolBar) {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<ctrl.selectAllPanel colspan=\"4\" />\n");
        sb.append("\t<ctrl.searchPanel colspan=\"4\" />\n");
        sb.append("\t<ctrl.pagingPanel colspan=\"4\"/>\n");
        return sb.toString();
    }

    private void handleToolbar(Element header, CoreUIViewInfo viewInfo) throws ShrWebBizException {
        Element toolbar;
        List<Element> innerButtons = this.getDefaultButtons(viewInfo);
        if (innerButtons == null) {
            innerButtons = new ArrayList<Element>();
        }
        if ((toolbar = header.getChild("toolbar")) == null) {
            toolbar = new Element("toolbar");
            header.addContent((Content)toolbar);
            List<Element> buttonElements = this.getButtonElement(header);
            for (Element element : buttonElements) {
                element.detach();
                toolbar.addContent((Content)element);
            }
        }
        List<Element> customButtons = this.getButtonElement(toolbar);
        HashMap<String, Boolean> customButtonSet = new HashMap<String, Boolean>();
        this.mergeButtons(toolbar, innerButtons, customButtons, customButtonSet);
    }

    protected List<Element> getDefaultButtons(CoreUIViewInfo viewInfo) throws ShrWebBizException {
        return null;
    }

    private void mergeButtons(Element buttonContainer, List<Element> innerButtons, List<Element> customButtons, Map<String, Boolean> customButtonSet) throws ShrWebBizException {
        Element customButton = null;
        Element innerButton = null;
        String buttonName = null;
        ArrayList<String> buttonNames = new ArrayList<String>();
        for (int i = customButtons.size() - 1; i >= 0; --i) {
            customButton = customButtons.get(i);
            buttonName = customButton.getAttributeValue("name");
            if ("dropDownButton".equalsIgnoreCase(customButton.getName())) {
                customButtonSet.put(buttonName, true);
            } else {
                customButtonSet.put(buttonName, false);
            }
            if (StringUtils.isEmpty((String)buttonName)) {
                throw new ShrWebBizException("button" + XMLUtil.attributesToString(customButton) + "'s name is empty");
            }
            buttonNames.add(0, buttonName);
            innerButton = this.getElement(innerButtons, buttonName);
            if (innerButton != null) {
                String visible = customButton.getAttributeValue("visible");
                if (StringUtils.isEmpty((String)visible)) {
                    customButton.setAttribute("visible", "true");
                }
                XMLUtil.overwriteAttribute(innerButton, customButton);
                if ("dropDownButton".equalsIgnoreCase(customButton.getName())) {
                    this.mergeButtons(innerButton, this.getButtonElement(innerButton), this.getButtonElement(customButton), customButtonSet);
                }
            } else {
                if ("dropDownButton".equalsIgnoreCase(customButton.getName())) {
                    int jsize = customButton.getChildren().size();
                    for (int j = 0; j < jsize; ++j) {
                        customButtonSet.put(((Element)customButton.getChildren().get(j)).getAttributeValue("name"), false);
                    }
                }
                innerButtons.add(customButton);
            }
            customButton.detach();
        }
        this.sortButtons(innerButtons, buttonNames);
        int moreIndex = this.getElementIndex(innerButtons, "more");
        if (moreIndex != -1 && moreIndex != innerButtons.size() - 1) {
            innerButtons.add(innerButtons.remove(moreIndex));
        }
        int size = innerButtons.size();
        for (int i = 0; i < size; ++i) {
            Element ie = innerButtons.get(i);
            String btnName = ie.getAttributeValue("name");
            if ("dropDownButton".equalsIgnoreCase(ie.getName())) {
                if (customButtonSet.containsKey(btnName)) {
                    buttonContainer.addContent((Content)innerButtons.get(i).detach());
                    continue;
                }
                int total = ie.getChildren().size();
                int j = 0;
                do {
                    Element je;
                    if (customButtonSet.containsKey((je = (Element)ie.getChildren().get(j)).getAttributeValue("name"))) {
                        je.detach();
                        total = ie.getChildren().size();
                        continue;
                    }
                    ++j;
                } while (j != total);
                if (null == ie.getChildren() || ie.getChildren().isEmpty()) continue;
                buttonContainer.addContent((Content)innerButtons.get(i).detach());
                continue;
            }
            buttonContainer.addContent((Content)innerButtons.get(i).detach());
        }
    }

    private List<Element> getButtonElement(Element header) {
        List children = header.getChildren();
        Element element = null;
        String name = null;
        ArrayList<Element> buttonElements = new ArrayList<Element>();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            name = element.getName();
            if (!"button".equalsIgnoreCase(name) && !"dropDownButton".equalsIgnoreCase(name)) continue;
            buttonElements.add(element);
        }
        return buttonElements;
    }

    private void sortButtons(List<Element> buttons, List<String> buttonNames) {
        if (buttons.isEmpty() || buttonNames.isEmpty()) {
            return;
        }
        String currentName = null;
        String nextName = null;
        Element element = null;
        int size = buttonNames.size() - 1;
        for (int i = 0; i < size; ++i) {
            currentName = buttonNames.get(i);
            nextName = buttonNames.get(i + 1);
            int currentIndex = this.getElementIndex(buttons, currentName);
            int nextIndex = this.getElementIndex(buttons, nextName);
            if (nextIndex >= currentIndex) continue;
            element = buttons.remove(nextIndex);
            if (currentIndex + 1 < buttons.size()) {
                buttons.add(currentIndex + 1, element);
                continue;
            }
            buttons.add(element);
        }
    }

    private int getElementIndex(List<Element> elements, String name) {
        Element element = null;
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            element = elements.get(i);
            if (!element.getAttributeValue("name").equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    private void handleURIElement(Element root) {
        Element element = this.getElement(root, "listURI");
        if (element != null) {
            element.detach();
            root.addContent((Content)element);
        }
        if ((element = this.getElement(root, "editURI")) != null) {
            element.detach();
            root.addContent((Content)element);
        }
    }

    private void handleGridToolBarElement(Element root) {
        Element element = this.getElement(root, "gridToolBar");
    }

    private Element getElement(List<Element> list, String elementName) {
        if (list == null) {
            return null;
        }
        Element element = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            element = list.get(i);
            if (!elementName.equalsIgnoreCase(element.getAttributeValue("name"))) continue;
            return element;
        }
        return null;
    }

    protected List<FieldInfo> getFields(Element root, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, Map<String, PropertyInfo> properties) throws SHRWebException {
        if (root == null || root.getChildren() == null) {
            return null;
        }
        List children = root.getChildren();
        String entityName = viewInfo.getEntityName();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if (("list".equalsIgnoreCase(elementName) || "grid".equalsIgnoreCase(elementName)) && "form".equals(viewInfo.getType())) continue;
            if ("field".equalsIgnoreCase(elementName) || "fieldValue".equalsIgnoreCase(elementName)) {
                FieldInfo f = this.assembleFieldInfo(element, entityName, properties, viewInfo);
                if (null == f) continue;
                fields.add(f);
                continue;
            }
            if ("editGrid".equalsIgnoreCase(elementName)) {
                fields.addAll(this.assembleEditGridFields(element, entityName, properties, viewInfo));
                continue;
            }
            if (element.getChildren() == null || element.getChildren().size() <= 0) continue;
            fields.addAll(this.getFields(element, viewInfo, properties));
        }
        return fields;
    }

    protected FieldInfo assembleFieldInfo(Element element, String entityName, Map<String, PropertyInfo> properties, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        String _sortable_;
        String defaultValueExpression;
        String requireAudit;
        String name = element.getAttributeValue("name");
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        PropertyInfo propertyInfo = null;
        if (StringUtils.isEmpty((String)viewInfo.getQuery())) {
            if (!StringUtils.isEmpty((String)entityName)) {
                if (name.contains(".")) {
                    propertyInfo = MetaDataUtil.getPropertyInfo((Context)this.ctx, (String)entityName, (String)name);
                } else if (properties != null && null == (propertyInfo = properties.get(name))) {
                    propertyInfo = this.getPropertyInfo(properties, name);
                }
            }
        } else {
            PropertyRefInfo pr = CommonQueryHelper.getPropertyRefInfo(this.ctx, viewInfo.getQuery(), name);
            if (null != pr) {
                propertyInfo = pr.getRefProperty();
            }
        }
        FieldInfo fieldInfo = this.newFieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setProperty(propertyInfo);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((String)label) && propertyInfo != null) {
            label = propertyInfo.getAlias();
            HashMap<String, String> nameMulitLan = new HashMap<String, String>();
            for (Map lan : BOSConfigUtil.getLanguageMapingList()) {
                Locale locale = LocaleUtils.getLocale((String)lan.get("locale"));
                nameMulitLan.put((String)lan.get("lang"), propertyInfo.getAlias(locale));
            }
            fieldInfo.setAliasMultiLan(nameMulitLan);
        }
        if (StringUtils.isEmpty((String)label)) {
            label = name;
        }
        fieldInfo.setAlias(label);
        String formatter = element.getAttributeValue("formatter");
        if (StringUtils.isEmpty((String)formatter)) {
            formatter = "";
        }
        fieldInfo.setFormatter(formatter);
        String formatoptions = element.getAttributeValue("formatoptions");
        if (StringUtils.isEmpty((String)formatoptions)) {
            formatoptions = "";
        }
        fieldInfo.setFormatoptions(formatoptions);
        String schemeField = element.getAttributeValue("schemeField");
        if (StringUtils.isEmpty((String)schemeField)) {
            formatter = "";
        }
        fieldInfo.setSchemeField(schemeField);
        this.setDataType(element, fieldInfo, viewInfo, propertyInfo);
        String type = element.getAttributeValue("type");
        if (!StringUtils.isEmpty((String)type)) {
            fieldInfo.setType(type);
        }
        if (!StringUtils.isEmpty((String)(requireAudit = element.getAttributeValue("requireAudit")))) {
            fieldInfo.setRequireAudit(Boolean.parseBoolean(requireAudit));
        }
        fieldInfo.setEntryField(this.isEntryField(name, properties));
        String defaultValue = element.getAttributeValue("defaultValue");
        if (!StringUtils.isEmpty((String)defaultValue)) {
            fieldInfo.setDefaultValue(defaultValue);
        }
        if (!StringUtils.isEmpty((String)(defaultValueExpression = element.getAttributeValue("defaultValueExpression")))) {
            fieldInfo.setDefaultValueExpression(defaultValueExpression);
        }
        if ("false".equals(_sortable_ = element.getAttributeValue("sortable"))) {
            fieldInfo.setSortable(false);
        }
        this.initFieldAttribute(element, fieldInfo);
        this.setSensitiveRule(fieldInfo, element, viewInfo);
        return fieldInfo;
    }

    protected final void setSensitiveRule(FieldInfo fieldInfo, Element element, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        if (null == fieldInfo) {
            return;
        }
        String sensitiveRule = element.getAttributeValue("sensitiveRule");
        Map<Object, Object> sensitiveRuleValue = null;
        String fieldName = fieldInfo.getName();
        Element pe = (Element)element.getParent();
        if ("editGrid".equals(pe.getName())) {
            fieldName = pe.getAttributeValue("name") + "." + fieldName;
        }
        if (StringUtils.isEmpty((String)sensitiveRule)) {
            IShrSensitiveService iShrSensitiveService = ShrSensitiveServiceFactory.getInstance().getIShrSensitiveService();
            String queryPk = viewInfo.getQuery();
            String entityFullName = viewInfo.getModel();
            sensitiveRuleValue = iShrSensitiveService.getFieldSensitiveForUipk(this.ctx, viewInfo.getUipk(), fieldName);
            if (null == sensitiveRuleValue) {
                sensitiveRuleValue = !StringUtils.isEmpty((String)queryPk) ? iShrSensitiveService.getFieldSensitiveForQuery(this.ctx, queryPk, fieldName) : iShrSensitiveService.getFieldSensitiveForEntity(this.ctx, entityFullName, fieldName, fieldInfo.getAttributes());
            }
        } else {
            sensitiveRuleValue = JSONUtils.convertJsonToObject(this.ctx, sensitiveRule);
        }
        if (null == sensitiveRuleValue) {
            return;
        }
        fieldInfo.setSensitiveRule(sensitiveRuleValue);
    }

    private void setDataType(Element element, FieldInfo fieldInfo, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, PropertyInfo propertyInfo) {
        String name = element.getAttributeValue("name");
        String dataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)dataType)) {
            fieldInfo.setDataType(dataType);
        } else if (!StringUtils.isEmpty((String)viewInfo.getQuery())) {
            fieldInfo.setQueryField(true);
            DataType dataType0 = MetaDataUtil.getQueryFiledDataType((Context)this.ctx, (String)viewInfo.getQuery(), (String)name);
            if (null != dataType0) {
                fieldInfo.setDataType(dataType0.getName());
            }
        } else if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            fieldInfo.setDataType(ownPropertyInfo.getDataType().getName());
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            RelationshipType relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType();
            if (RelationshipType.COMPOSITION.equals((Object)relationshipType)) {
                fieldInfo.setDataType(DataType.OBJECTCOLLECTION.getName());
            } else {
                fieldInfo.setDataType(DataType.OBJECTVALUE.getName());
            }
        }
    }

    private void initFieldAttribute(Element element, FieldInfo fieldInfo) {
        List attrs = element.getAttributes();
        if (null == attrs || attrs.size() <= 0) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>(attrs.size());
        for (Attribute attr : attrs) {
            attributes.put(attr.getName(), attr.getValue());
        }
        fieldInfo.setAttributes(attributes);
    }

    private PropertyInfo getPropertyInfo(Map<String, PropertyInfo> properties, String name) {
        for (Map.Entry<String, PropertyInfo> e : properties.entrySet()) {
            if (!name.equalsIgnoreCase(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    protected FieldInfo newFieldInfo() {
        return new FieldInfo();
    }

    private boolean isEntryField(String fieldName, Map<String, PropertyInfo> properties) {
        RelationshipType relationshipType;
        String firstName;
        PropertyInfo propertyInfo;
        return fieldName.contains(".") && properties != null && (propertyInfo = properties.get(firstName = fieldName.split("\\.")[0])) instanceof LinkPropertyInfo && RelationshipType.COMPOSITION.equals((Object)(relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType()));
    }

    private List<FieldInfo> assembleEditGridFields(Element element, String entityName, Map<String, PropertyInfo> properties, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        if (element.getAttribute("query") != null) {
            return this.assembleEditGridFieldsByQuery(element, viewInfo);
        }
        String entryName = element.getAttributeValue("name");
        PropertyInfo propertyInfo = null;
        if (!StringUtils.isEmpty((String)entityName)) {
            if (entryName.indexOf(".") != -1) {
                propertyInfo = MetaDataUtil.getPropertyInfo((Context)this.ctx, (String)entityName, (String)entryName);
            } else if (properties != null) {
                propertyInfo = properties.get(entryName);
            }
        }
        String entryEntityName = null;
        LinkPropertyInfo linkPropertyInfo = null;
        if (propertyInfo instanceof LinkPropertyInfo && RelationshipType.COMPOSITION.equals((Object)(linkPropertyInfo = (LinkPropertyInfo)propertyInfo).getRelationship().getType())) {
            entryEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        }
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        FieldInfo editGridfieldInfo = this.assembleFieldInfo(element, entityName, properties, viewInfo);
        editGridfieldInfo.setEntryField(true);
        editGridfieldInfo.setEditGridField(true);
        fields.add(editGridfieldInfo);
        Map entryProperties = MetaDataUtil.getProperties((Context)this.ctx, (String)entryEntityName);
        List columns = element.getChildren("column");
        Element column = null;
        FieldInfo fieldInfo = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (Element)columns.get(i);
            fieldInfo = this.assembleFieldInfo(column, entryEntityName, entryProperties, viewInfo);
            fieldInfo.setName(entryName + "." + fieldInfo.getName());
            fieldInfo.setEntryField(true);
            fieldInfo.setEditGridField(true);
            fields.add(fieldInfo);
        }
        return fields;
    }

    private List<FieldInfo> assembleEditGridFieldsByQuery(Element element, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) throws SHRWebException {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        List columns = element.getChildren("column");
        Element column = null;
        FieldInfo fieldInfo = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = (Element)columns.get(i);
            fieldInfo = this.assembleFieldInfo(column, null, null, viewInfo);
            fields.add(fieldInfo);
        }
        return fields;
    }

    private String getJSClass(Element root, CoreUIViewInfo viewInfo) {
        List children = root.getChildren();
        if (children == null) {
            return null;
        }
        String jsClass = null;
        Element element = this.getElement(root, "jsclass");
        if (element != null) {
            jsClass = element.getAttributeValue("name");
        }
        if (StringUtils.isEmpty(jsClass)) {
            jsClass = this.scriptToJSClass(root, jsClass);
        }
        if (StringUtils.isEmpty((String)jsClass)) {
            jsClass = this.getFrameworkJSClass(root, viewInfo);
        }
        return jsClass;
    }

    private List<Map<String, Object>> getScripts(Element root) {
        List<Element> list = new ArrayList<Element>();
        list = XMLUtil.getElements(root, "script", list);
        ArrayList<Map<String, Object>> scripts = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = null;
        Boolean combine = null;
        for (Element element : list) {
            if (element.getAttributeValue("src") != null) {
                item = new HashMap<String, Object>();
                item.put("src", element.getAttributeValue("src"));
                combine = element.getAttributeValue("combine") != null ? Boolean.valueOf(element.getAttributeValue("combine")) : Boolean.TRUE;
                item.put("combine", combine);
                scripts.add(item);
            }
            element.detach();
        }
        return scripts;
    }

    private List<String> getStyles(Element root) {
        List<Element> list = new ArrayList<Element>();
        list = XMLUtil.getElements(root, "style", list);
        ArrayList<String> styles = new ArrayList<String>();
        for (Element element : list) {
            styles.add(element.getAttributeValue("href"));
            element.detach();
        }
        return styles;
    }

    private String scriptToJSClass(Element root, String jsClass) {
        String prefix;
        String src;
        Element element = this.getElement(root, "script");
        if (element != null && element.getAttributeValue("src") != null && (src = element.getAttributeValue("src")).startsWith(prefix = "/scripts/")) {
            String[] strs = src.substring(prefix.length(), src.indexOf(".js")).split("/");
            StringBuilder result = new StringBuilder();
            String item = null;
            int length = strs.length;
            for (int i = 0; i < length; ++i) {
                item = strs[i];
                if (i != 0) {
                    result.append(".");
                }
                if (i == length - 1) {
                    item = DynamicUtil.firstUpperCase(item);
                }
                result.append(item);
            }
            jsClass = result.toString();
        }
        return jsClass;
    }

    protected String getFrameworkJSClass(Element root, CoreUIViewInfo viewInfo) {
        return "shr.framework.Core";
    }

    private String getHandler(Element root, CoreUIViewInfo viewInfo) {
        String handler = null;
        Element element = this.getElement(root, "handler");
        if (element != null) {
            handler = element.getAttributeValue("class");
        }
        if (StringUtils.isEmpty(handler)) {
            handler = this.getFrameworkHandler(root, viewInfo);
        }
        return handler;
    }

    protected String getFrameworkHandler(Element root, CoreUIViewInfo viewInfo) {
        return CoreHandler.class.getName();
    }

    private String getRelatedField(Element root) {
        Element element = this.getElement(root, "relatedField");
        if (element != null) {
            return element.getAttributeValue("name");
        }
        return null;
    }

    public Element getElement(Element root, String elementName) {
        return XMLUtil.getElement(root, elementName);
    }
}

