/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.view.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.model.CoreUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicFormUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicModelHelper;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.FormUIViewConverter;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class DynamicFormUIViewConverter
extends FormUIViewConverter {
    public DynamicFormUIViewConverter(UIViewInfo uiViewInfo, Context ctx) {
        super(uiViewInfo, ctx);
    }

    @Override
    protected String getPageTitle(String viewTitle) {
        return viewTitle + UIType.dynamicForm.getAlias();
    }

    @Override
    protected void assembleViewInfo(Element root, CoreUIViewInfo viewInfo) throws SHRWebException {
        ((DynamicFormUIViewInfo)viewInfo).setScheme(viewInfo.getModel());
        super.assembleViewInfo(root, viewInfo);
    }

    @Override
    protected String getFrameworkJSClass(Element root, CoreUIViewInfo viewInfo) {
        return "shr.framework.DynamicEdit";
    }

    protected List<FieldInfo> getFields(Element root, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        if (root == null || root.getChildren() == null) {
            return null;
        }
        DynamicFormUIViewInfo dyUiviewInfo = (DynamicFormUIViewInfo)viewInfo;
        List children = root.getChildren();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if ("field".equalsIgnoreCase(elementName) || "fieldValue".equalsIgnoreCase(elementName)) {
                fields.add(this.assembleFieldInfo(element, dyUiviewInfo.getScheme()));
                continue;
            }
            if (element.getChildren() == null) continue;
            fields.addAll(this.getFields(element, viewInfo));
        }
        return fields;
    }

    private FieldInfo assembleFieldInfo(Element element, String scheme) {
        String requireAudit;
        String type;
        String name = element.getAttributeValue("name");
        DynamicModelHelper modelHelper = new DynamicModelHelper();
        modelHelper.setScheme(scheme);
        PropertyInfo propertyInfo = null;
        try {
            propertyInfo = modelHelper.getPropertyInfo(name);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setProperty(propertyInfo);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((String)label) && propertyInfo != null) {
            label = modelHelper.getPropertyName(name);
        }
        if (StringUtils.isEmpty((String)label)) {
            label = name;
        }
        fieldInfo.setAlias(label);
        String dataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)dataType)) {
            fieldInfo.setDataType(dataType);
        }
        if (!StringUtils.isEmpty((String)(type = element.getAttributeValue("type")))) {
            fieldInfo.setType(type);
        }
        if (!StringUtils.isEmpty((String)(requireAudit = element.getAttributeValue("requireAudit")))) {
            fieldInfo.setRequireAudit(Boolean.parseBoolean(requireAudit));
        }
        return fieldInfo;
    }

    @Override
    protected String getFrameworkHandler(Element root, CoreUIViewInfo viewInfo) {
        return "com.kingdee.shr.base.syssetting.web.handler.DynamicEditHandler";
    }

    @Override
    protected List<Element> getDefaultButtons(CoreUIViewInfo viewInfo) throws ShrWebBizException {
        ArrayList<Element> buttons = new ArrayList<Element>();
        Element element = null;
        element = new Element("button");
        element.setAttribute("name", "save");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"save", (Context)this.ctx));
        element.setAttribute("class", "btn-primary");
        element.setAttribute("pageStates", "EDIT,ADDNEW");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        element = new Element("button");
        element.setAttribute("name", "cancel");
        element.setAttribute("caption", SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"cancel", (Context)this.ctx));
        element.setAttribute("pageStates", "EDIT,ADDNEW");
        element.setAttribute("isInnerButton", "true");
        buttons.add(element);
        return buttons;
    }

    @Override
    public com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfo() {
        return new DynamicFormUIViewInfo();
    }
}

