/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.gzh;

import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.BASE64Encoder;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static Logger logger = LoggerFactory.getLogger(AESUtil.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static String encrypt(String content, String password) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, AESUtil.getSecretKey(password));
            byte[] result = cipher.doFinal(byteContent);
            return new BASE64Encoder().encode(result);
        }
        catch (Exception ex) {
            logger.info("AES encode failed ", (Throwable)ex);
            return null;
        }
    }

    public static String decrypt(String content, String password) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AESUtil.getSecretKey(password));
            byte[] result = cipher.doFinal(new BASE64Decoder().decodeBuffer(content));
            return new String(result, "utf-8");
        }
        catch (Exception ex) {
            logger.info("AES decode failed ", (Throwable)ex);
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String password) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.setSeed(password.getBytes());
            kg.init(128, sr);
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.info("AES generate encode secret ", (Throwable)ex);
            return null;
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(AESUtil.encrypt("b05972aa6ba64db996c12734a31caef4", "201733\nwTdVz4lRTcG8OjdzXje81hO33n8=\n0000000000\n1555042281585\n208958"));
        System.out.println(AESUtil.encrypt("b05972aa6ba64db996c12734a31caef4", "201733\nwTdVz4lRTcG8OjdzXje81hO33n8=\n0000000000\n1555042281585\n208958"));
    }
}

