/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.field.form.IShrFieldPermForm;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.handler.IMultiRowHandler;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class MultiRowHandler
extends EditHandler
implements IMultiRowHandler {
    protected static final String COLLECTION_ATTRIBUTE_KEY = "model_collection";

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return this.initalizeDataAction(request, response, modelMap);
    }

    @Override
    public String initalizeDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.initModelCollection(request, response, modelMap);
        this.beforeRender(request, response, modelMap);
        return this.getViewName(request);
    }

    protected void initModelCollection(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        String relatedFieldId = this.getRelatedFieldId(request, uiViewInfo);
        IShrFieldPermForm shrFieldPerm = this.fieldPermInit(request);
        String relatedField = uiViewInfo.getRelatedField();
        CoreBaseCollection collection = this.initCollection(request, response, modelMap, relatedField, relatedFieldId);
        ArrayList<CoreBaseInfo> list = new ArrayList<CoreBaseInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.doFieldPermFilter(shrFieldPerm, "VIEW", collection.get(i));
            collection.get(i).put("attachmentID", (Object)("attachment_" + i));
            list.add(collection.get(i));
        }
        modelMap.addAttribute(COLLECTION_ATTRIBUTE_KEY, list);
        modelMap.addAttribute("operateState", (Object)"VIEW");
        modelMap.addAttribute("relatedField", (Object)relatedField);
        modelMap.addAttribute("relatedFieldId", (Object)relatedFieldId);
        CoreBaseInfo coreBaseInfo = this.initMainModelInfo(request, response, modelMap);
        DynamicUtil.setObjectPropertyValue(coreBaseInfo, relatedField, relatedFieldId);
        this.checkDataPermission(request, coreBaseInfo);
        modelMap.addAttribute("model", (Object)coreBaseInfo);
    }

    @Override
    protected void checkDataPermission(HttpServletRequest request, Object obj) throws SHRWebException {
        if (ShrCheckDataPermissionUtil.hasPermissionRuleConfig(request)) {
            return;
        }
        this.checkBizDataPermission(request, obj);
    }

    protected CoreBaseInfo initMainModelInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CoreBaseInfo coreBaseInfo = this.createNewModel(request, response, modelMap);
        return coreBaseInfo;
    }

    protected String getRelatedFieldId(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        String relatedField = uiViewInfo.getRelatedField();
        if (StringUtils.isEmpty((String)relatedField)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "not_set_relatedfield"));
        }
        String relatedFieldId = (String)request.getAttribute("relatedFieldId");
        if (StringUtils.isEmpty((String)relatedFieldId)) {
            relatedFieldId = request.getParameter("relatedFieldId");
        }
        if (StringUtils.isEmpty((String)relatedFieldId)) {
            relatedFieldId = this.getBillId(request);
        }
        return relatedFieldId;
    }

    protected CoreBaseCollection initCollection(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String relateField, String billId) throws SHRWebException {
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(request, relateField, billId);
        try {
            CoreBaseCollection collection = this.getBizInterface(request).getCollection(entityViewInfo);
            return collection;
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public List<CoreBaseInfo> getModelCollection(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String billId) throws SHRWebException {
        String relateField = this.getUIViewInfo(request).getRelatedField();
        CoreBaseCollection collection = this.initCollection(request, response, modelMap, relateField, billId);
        ArrayList<CoreBaseInfo> list = new ArrayList<CoreBaseInfo>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            list.add(collection.get(i));
        }
        return list;
    }

    protected EntityViewInfo getEntityViewInfo(String relateField, String billId) throws SHRWebException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(relateField, (Object)billId));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(this.getSelectors());
        UIViewInfo uiViewInfo = this.getUIViewInfo();
        if (uiViewInfo.getOrderBy() != null) {
            SorterItemCollection sorter = new SorterItemCollection();
            try {
                sorter.getSorter().decode("order by " + uiViewInfo.getOrderBy());
            }
            catch (ParserException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
            entityViewInfo.setSorter(sorter);
        }
        return entityViewInfo;
    }

    protected EntityViewInfo getEntityViewInfo(HttpServletRequest request, String relateField, String billId) throws SHRWebException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(relateField, (Object)billId));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(this.getSelectors(request));
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        if (uiViewInfo.getOrderBy() != null) {
            SorterItemCollection sorter = new SorterItemCollection();
            try {
                sorter.getSorter().decode("order by " + uiViewInfo.getOrderBy());
            }
            catch (ParserException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
            entityViewInfo.setSorter(sorter);
        }
        return entityViewInfo;
    }
}

