/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TreeEditHandler
extends EditHandler {
    @Override
    protected void afterCreateNewModel(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        super.afterCreateNewModel(request, response, coreBaseInfo);
        this.setTreeFieldValue(request, coreBaseInfo);
    }

    private void setTreeFieldValue(HttpServletRequest request, CoreBaseInfo coreBaseInfo) throws SHRWebException {
        if (!this.isExistTreeField(request)) {
            return;
        }
        CoreBaseInfo value = this.getParentNodeInfo(request);
        if (value != null) {
            coreBaseInfo.put(this.getTreeFieldName(), (Object)value);
        }
    }

    private boolean isExistTreeField(HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiViewInfo = this.getUIViewInfo(request);
        FieldInfo fieldInfo = uiViewInfo.getField(this.getTreeFieldName());
        return fieldInfo != null;
    }

    protected CoreBaseInfo getParentNodeInfo(HttpServletRequest request) throws SHRWebException {
        String nodeId = request.getParameter("nodeId");
        if (StringUtils.isEmpty((String)nodeId) || "rootId".equals(nodeId)) {
            return null;
        }
        CoreBaseInfo value = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            ICoreBase iCoreBase = MetaDataUtil.getBizInterface(BOSUuid.read((String)nodeId).getType());
            value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(nodeId), sic);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (UuidException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        return value;
    }

    protected String getTreeFieldName() {
        return "parent";
    }
}

