/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.support.defaultvalue;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.support.defaultvalue.expression.DateFieldDefaultValueExpressionHandler;
import com.kingdee.shr.base.syssetting.web.support.fieldrule.FieldRuleHelper;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DefaultValueService {
    private static Logger logger = Logger.getLogger(DefaultValueService.class);

    public static void setDefalutValueToCoreBaseInfo(UIViewInfo viewInfo, CoreBaseInfo coreBaseInfo) {
        String uipk;
        Context ctx = SHRContext.getInstance().getContext();
        if (!FieldRuleHelper.isCurrentRuleByDefault(ctx, uipk = viewInfo.getUipk())) {
            FieldRuleHelper.setFieldDefaultValue(ctx, uipk, coreBaseInfo);
            DefaultValueService.setSimpleFieldDefalutValue(viewInfo, coreBaseInfo);
            DefaultValueService.setComposeRelationFieldDefaultValue(viewInfo, coreBaseInfo);
        } else {
            DefaultValueService.setSimpleFieldDefalutValue(viewInfo, coreBaseInfo);
            DefaultValueService.setComposeRelationFieldDefaultValue(viewInfo, coreBaseInfo);
            FieldRuleHelper.setFieldDefaultValue(ctx, uipk, coreBaseInfo);
        }
    }

    private static void setSimpleFieldDefalutValue(UIViewInfo viewInfo, CoreBaseInfo coreBaseInfo) {
        List<FieldInfo> fields = viewInfo.getFields();
        for (FieldInfo fieldInfo : fields) {
            String[] fieldNames;
            String fieldName = fieldInfo.getName();
            String defaultValue = fieldInfo.getDefaultValue();
            String defaultValueExpression = fieldInfo.getDefaultValueExpression();
            if (StringUtils.isEmpty((String)defaultValue) && StringUtils.isEmpty((String)defaultValueExpression) || 2 == (fieldNames = fieldName.split("\\.")).length) continue;
            DataType dataType = fieldInfo.getDataType();
            if (null == dataType) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("uipk:" + viewInfo.getUipk() + ",fieldName:" + fieldInfo.getName() + " DataType is null, please check."));
                continue;
            }
            String dataTypeName = dataType.getName();
            if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataTypeName)) {
                DefaultValueService.setDefaultValue(coreBaseInfo, fieldName, DefaultValueService.getBooleFieldDefaultValue(defaultValue));
                continue;
            }
            if (DataType.DATE.getName().equalsIgnoreCase(dataTypeName) || DataType.TIME.getName().equalsIgnoreCase(dataTypeName)) {
                DefaultValueService.setDefaultValue(coreBaseInfo, fieldName, StringUtils.isEmpty((String)defaultValueExpression) ? defaultValue : DefaultValueService.calDateFieldDefaultValue(defaultValueExpression));
                continue;
            }
            if (DataType.STRING.toString().equalsIgnoreCase(dataTypeName) || DefaultValueService.isSimpleNumberType(dataTypeName).booleanValue()) {
                DefaultValueService.setDefaultValue(coreBaseInfo, fieldName, defaultValue);
                continue;
            }
            if (DataType.ENUM.toString().equalsIgnoreCase(dataTypeName)) {
                DefaultValueService.setDefaultValue(coreBaseInfo, fieldName, DefaultValueService.getEnumFieldDefault(fieldInfo.getProperty(), defaultValue));
                continue;
            }
            if (!"f7".equalsIgnoreCase(dataTypeName)) continue;
        }
    }

    private static Object getEnumFieldDefault(PropertyInfo property, String defaultValue) {
        String enumSource = null;
        if (property instanceof OwnPropertyInfo) {
            OwnPropertyInfo own = (OwnPropertyInfo)property;
            enumSource = own.getMetaDataRef();
        }
        if (!StringUtils.isEmpty(enumSource) && !StringUtils.isEmpty((String)defaultValue)) {
            return MetaDataUtil.findEnumByValue((String)enumSource, (Object)defaultValue);
        }
        return defaultValue;
    }

    private static Map<String, String> getFiledDataTypeMap(UIViewInfo viewInfo) {
        List<FieldInfo> fields = viewInfo.getFields();
        HashMap<String, String> map = new HashMap<String, String>();
        for (FieldInfo fieldInfo : fields) {
            String fieldName = fieldInfo.getName();
            String defaultValue = fieldInfo.getDefaultValue();
            String defaultValueExpression = fieldInfo.getDefaultValueExpression();
            if (StringUtils.isEmpty((String)defaultValue) && StringUtils.isEmpty((String)defaultValueExpression) || null == fieldInfo.getDataType()) continue;
            map.put(fieldName, fieldInfo.getDataType().getName());
        }
        return map;
    }

    private static void setComposeRelationFieldDefaultValue(UIViewInfo viewInfo, CoreBaseInfo coreBaseInfo) {
        Map<String, Map<String, Object>> entryFiledMap = DefaultValueService.getEntryFileValueMap(viewInfo);
        Map<String, String> filedDataTypeMap = DefaultValueService.getFiledDataTypeMap(viewInfo);
        HashMap<String, List<Object>> dynamicComposeFiledRuntimeClassMapping = new HashMap<String, List<Object>>();
        HashMap<String, List<Object>> dynamicAssociationFieldRuntimeClassMapping = new HashMap<String, List<Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : entryFiledMap.entrySet()) {
            String entryKey = entry.getKey();
            Map<String, Object> entryFiledValueMap = entry.getValue();
            for (Map.Entry<String, Object> entryFiledMapEntry : entryFiledValueMap.entrySet()) {
                String composeFiledKey = entryFiledMapEntry.getKey();
                Object composeFiledValue = entryFiledMapEntry.getValue();
                String fullFieldKey = entryKey + "." + composeFiledKey;
                String fieldDataType = filedDataTypeMap.get(fullFieldKey);
                Object entryObject = coreBaseInfo.get(entryKey);
                if (entryObject instanceof AbstractObjectCollection) {
                    DefaultValueService.setComposeFiledDefaultFieldValue(coreBaseInfo, dynamicComposeFiledRuntimeClassMapping, entryKey, composeFiledKey, fieldDataType, composeFiledValue);
                    continue;
                }
                DefaultValueService.setAssociationFiledDefaultValue(coreBaseInfo, dynamicAssociationFieldRuntimeClassMapping, entryKey, composeFiledKey, composeFiledValue);
            }
        }
    }

    private static void setAssociationFiledDefaultValue(CoreBaseInfo coreBaseInfo, Map<String, List<Object>> dynamicAssociationFieldRuntimeClassMapping, String entryKey, String composeFiledKey, Object composeFiledValue) {
        Class<?> clz0 = null;
        Class<?> clz1 = null;
        Method putMethod = null;
        List<Object> list = null;
        Object instance0 = null;
        try {
            if (null != dynamicAssociationFieldRuntimeClassMapping.get(entryKey)) {
                list = dynamicAssociationFieldRuntimeClassMapping.get(entryKey);
                clz0 = (Class<?>)list.get(0);
                clz1 = (Class<?>)list.get(1);
                instance0 = list.get(2);
                putMethod = (Method)list.get(3);
                putMethod.invoke(instance0, composeFiledKey, composeFiledValue);
                coreBaseInfo.put(entryKey, instance0);
            } else {
                list = new ArrayList();
                dynamicAssociationFieldRuntimeClassMapping.put(entryKey, list);
                String fullClassName = coreBaseInfo.getClass().getName();
                clz0 = Class.forName(fullClassName);
                String methodName = "get" + entryKey.substring(0, 1).toUpperCase() + entryKey.substring(1);
                Method getMethod = clz0.getMethod(methodName, new Class[0]);
                clz1 = getMethod.getReturnType();
                putMethod = clz1.getMethod("put", String.class, Object.class);
                Object newInstance = clz1.newInstance();
                putMethod.invoke(newInstance, composeFiledKey, composeFiledValue);
                coreBaseInfo.put(entryKey, newInstance);
                list.add(clz0);
                list.add(clz1);
                list.add(newInstance);
                list.add(putMethod);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setDefaultValue(CoreBaseInfo coreBaseInfo, String fieldName, Object defaultValue) {
        if (!StringUtils.isEmpty((String)defaultValue.toString())) {
            coreBaseInfo.put(fieldName, defaultValue);
        }
    }

    private static CoreBaseInfo setComposeFiledDefaultFieldValue(CoreBaseInfo coreBaseInfo, Map<String, List<Object>> dynamicRuntimeClassMapping, String entrysKey, String entrysField, String fieldDataType, Object defaultValue) {
        Class<?> collectionClass = null;
        Class<?> infoClass = null;
        Method addMethod = null;
        Method putMethod = null;
        List<Object> list = null;
        Object collInstance = null;
        Object infoInstance = null;
        try {
            if (null != dynamicRuntimeClassMapping.get(entrysKey)) {
                list = dynamicRuntimeClassMapping.get(entrysKey);
                addMethod = (Method)list.get(0);
                putMethod = (Method)list.get(1);
                collInstance = list.get(2);
                infoInstance = list.get(3);
                DefaultValueService.dynamicSetEntrysFiledDefaultValue(coreBaseInfo, entrysKey, collInstance, infoInstance, addMethod, putMethod, entrysField, defaultValue);
            } else {
                Object entryObject = coreBaseInfo.get(entrysKey);
                if (null == entryObject) {
                    return coreBaseInfo;
                }
                String collectionClassName = entryObject.getClass().getName();
                list = new ArrayList<Object>();
                dynamicRuntimeClassMapping.put(entrysKey, list);
                collectionClass = Class.forName(collectionClassName);
                String infoClasName = collectionClassName.substring(0, collectionClassName.lastIndexOf("Collection")) + "Info";
                infoClass = Class.forName(infoClasName);
                addMethod = collectionClass.getMethod("add", infoClass);
                putMethod = infoClass.getMethod("put", String.class, Object.class);
                collInstance = collectionClass.newInstance();
                infoInstance = infoClass.newInstance();
                DefaultValueService.dynamicSetEntrysFiledDefaultValue(coreBaseInfo, entrysKey, collInstance, infoInstance, addMethod, putMethod, entrysField, defaultValue);
                list.add(addMethod);
                list.add(putMethod);
                list.add(collInstance);
                list.add(infoInstance);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coreBaseInfo;
    }

    private static void dynamicSetEntrysFiledDefaultValue(CoreBaseInfo coreBaseInfo, String entrysKey, Object collInstance, Object infoInstance, Method addMethod, Method putMethod, String entrysField, Object defaultValue) {
        try {
            IObjectCollection coll = (IObjectCollection)coreBaseInfo.get(entrysKey);
            if (null == coll || coll.isEmpty()) {
                addMethod.invoke(collInstance, infoInstance);
                coreBaseInfo.put(entrysKey, collInstance);
            } else {
                infoInstance = coll.getObject(0);
            }
            putMethod.invoke(infoInstance, entrysField, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Map<String, Object>> getEntryFileValueMap(UIViewInfo viewInfo) {
        List<FieldInfo> fields = viewInfo.getFields();
        Map<String, Object> map = null;
        HashMap<String, Map<String, Object>> entrysMap = new HashMap<String, Map<String, Object>>();
        for (FieldInfo fieldInfo : fields) {
            String[] fieldNames;
            String fieldName = fieldInfo.getName();
            String defaultValue = fieldInfo.getDefaultValue();
            String defaultValueExpression = fieldInfo.getDefaultValueExpression();
            if (StringUtils.isEmpty((String)defaultValue) && StringUtils.isEmpty((String)defaultValueExpression) || 2 != (fieldNames = fieldName.split("\\.")).length) continue;
            String entrysKey = fieldNames[0];
            String entrysField = fieldNames[1];
            if (null != entrysMap.get(entrysKey)) {
                map = (Map)entrysMap.get(entrysKey);
            } else {
                map = new HashMap();
                entrysMap.put(entrysKey, map);
            }
            DataType dataType = fieldInfo.getDataType();
            String dataTypeName = dataType.getName();
            if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataTypeName)) {
                map.put(entrysField, DefaultValueService.getBooleFieldDefaultValue(defaultValue));
                continue;
            }
            if (DataType.DATE.getName().equalsIgnoreCase(dataTypeName) || DataType.TIME.getName().equalsIgnoreCase(dataTypeName)) {
                map.put(entrysField, StringUtils.isEmpty((String)defaultValueExpression) ? defaultValue : DefaultValueService.calDateFieldDefaultValue(defaultValueExpression));
                continue;
            }
            if (DataType.ENUM.toString().equalsIgnoreCase(dataTypeName) || DataType.STRING.toString().equalsIgnoreCase(dataTypeName) || DefaultValueService.isSimpleNumberType(dataTypeName).booleanValue()) {
                map.put(entrysField, defaultValue);
                continue;
            }
            if (DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName)) {
                map.put(entrysField, new BigDecimal(defaultValue));
                continue;
            }
            if (!"f7".equalsIgnoreCase(dataTypeName)) continue;
        }
        return entrysMap;
    }

    private static Boolean isSimpleNumberType(String dataTypeName) {
        return DataType.SHORT.toString().equalsIgnoreCase(dataTypeName) || DataType.INTEGER.toString().equalsIgnoreCase(dataTypeName) || DataType.LONG.toString().equalsIgnoreCase(dataTypeName) || DataType.FLOAT.toString().equalsIgnoreCase(dataTypeName) || DataType.DOUBLE.toString().equalsIgnoreCase(dataTypeName) || DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName);
    }

    private static Boolean getBooleFieldDefaultValue(String defaultValue) {
        Boolean v = Boolean.FALSE;
        if (!StringUtils.isEmpty((String)defaultValue) && ("1".equals(defaultValue) || "true".equals(defaultValue))) {
            v = Boolean.TRUE;
        }
        return v;
    }

    private static Object calDateFieldDefaultValue(String defaultValueExpression) {
        DateFieldDefaultValueExpressionHandler expHandler = new DateFieldDefaultValueExpressionHandler();
        return expHandler.calExpressionValue(defaultValueExpression, "");
    }
}

