/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.shr.base.syssetting.web.dynamic.util.JSUtil;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class TranslatorUtil {
    public static String optionToString(Map<String, Object> options) {
        if (options == null || options.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = options.keySet().iterator();
        String name = null;
        Object value = null;
        while (it.hasNext()) {
            name = it.next();
            value = options.get(name);
            sb.append(name);
            sb.append("=");
            sb.append("\"");
            sb.append(TranslatorUtil.convertValue(value));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            StringBuilder sb = new StringBuilder();
            for (Object item : collection) {
                sb.append(item.toString());
                sb.append(" ");
            }
            return sb.toString();
        }
        if (value instanceof Map) {
            return JSUtil.toJSObject((Map)value);
        }
        return value.toString();
    }

    public static void copyAttribute(Element element, Map<String, Object> options, String key) {
        TranslatorUtil.copyAttribute(element, options, key, null);
    }

    public static void copyAttribute(Element element, Map<String, Object> options, String key, String defaultVal) {
        String value = element.getAttributeValue(key);
        if (!StringUtils.isEmpty((String)value)) {
            options.put(key, value);
        } else if (null != defaultVal) {
            options.put(key, defaultVal);
        }
    }

    public static void copyAttributes(Element element, Map<String, Object> options, Set<String> excludeAttrs) {
        List attributes = element.getAttributes();
        for (Attribute attr : attributes) {
            if (null != excludeAttrs && excludeAttrs.size() > 0 && excludeAttrs.contains(attr.getName())) continue;
            options.put(attr.getName(), attr.getValue());
        }
    }
}

