/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.directive;

import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.util.DateTimeUtils;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class URLDirective
implements TemplateDirectiveModel {
    private static final String VALUE = "value";
    private static final String FORMAT_STR = "yyyyMMddHHmmss";
    private static final String ROOT_PATH = "/";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String valueParam = "";
        for (Map.Entry ent : params.entrySet()) {
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (VALUE.equals(paramName)) {
                if (!(paramValue instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("The \"value\" parameter must be a string.");
                }
                valueParam = ((TemplateScalarModel)paramValue).getAsString();
                continue;
            }
            throw new TemplateModelException("Unsupported parameter: " + paramName);
        }
        env.getOut().write(this.getNewFilePath(valueParam));
    }

    private String getNewFilePath(String filePath) {
        if (filePath != null && !filePath.startsWith(ROOT_PATH)) {
            return filePath;
        }
        HttpServletRequest request = (HttpServletRequest)SHRContext.getInstance().getRequest();
        String serverPath = request.getSession().getServletContext().getRealPath(ROOT_PATH);
        File file = null;
        if (filePath != null) {
            file = new File(serverPath + filePath.substring(1));
        }
        String newFilePath = request.getContextPath() + filePath;
        if (file != null && file.exists()) {
            newFilePath = newFilePath + "?v=" + DateTimeUtils.format((Date)new Date(file.lastModified()), (String)FORMAT_STR);
        }
        return newFilePath;
    }
}

