/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.dynamic.util.MD5;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class UserUtil {
    private static Logger logger = Logger.getLogger(UserUtil.class);

    public static Map<String, Object> getUserInfo(HttpServletRequest request) throws SHRWebException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String currentPersonId = null;
        if (userInfo.getPerson() != null) {
            currentPersonId = userInfo.getPerson().getId().toString();
            PersonInfo personInfo = UserUtil.getPersonInfo(currentPersonId);
            if (personInfo != null) {
                data.put("personName", personInfo.getName());
                data.put("gender", personInfo.getGender());
                String personId = personInfo.getId().toString();
                data.put("personId", personId);
            }
            data.put("hasPerson", "true");
        } else {
            data.put("personName", ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            data.put("hasPerson", "false");
        }
        data.put("userNumber", userInfo.getNumber());
        data.put("userId", userInfo.getId());
        return data;
    }

    private static PersonInfo getPersonInfo(String personId) throws SHRWebException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        try {
            return PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId), sic);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public static String getUserTempDir(HttpSession session) {
        return "/tmp/" + session.getId();
    }

    public static String getUserTempDirAbsolutePath(HttpSession session) {
        return session.getServletContext().getRealPath("/") + UserUtil.getUserTempDir(session).substring(1);
    }

    public static void removeUserTempDir(HttpSession session) {
        String userTmpDir = UserUtil.getUserTempDirAbsolutePath(session);
        try {
            FileUtils.deleteFile((String)userTmpDir);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String getEncryRealFileName(Context ctx, String realFileName) {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return MessageFormat.format("{0}_{1}", realFileName, MD5.md5Hash(currentUserInfo.getId().toString()));
    }
}

