/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IUserSetting;
import com.kingdee.shr.base.syssetting.UserSettingFactory;
import com.kingdee.shr.base.syssetting.WorkPlatformCollection;
import com.kingdee.shr.base.syssetting.WorkPlatformFactory;
import com.kingdee.shr.base.syssetting.WorkPlatformInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.util.WorkPlatformUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class WorkPlatformUtils {
    private static Logger logger = Logger.getLogger(WorkPlatformUtils.class);

    private static WorkPlatformInfo getUserSettingHomePage(Context ctx, UserInfo userInfo) throws SHRWebException {
        WorkPlatformInfo defaultWorkPlatformInfo = null;
        try {
            IUserSetting userSetting = UserSettingFactory.getLocalInstance((Context)ctx);
            defaultWorkPlatformInfo = (WorkPlatformInfo)userSetting.getUserDefaultPlatform(userInfo);
            return defaultWorkPlatformInfo;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    public static WorkPlatformInfo getUserRedirectWorkPlatform(HttpServletRequest request, Context ctx, UserInfo userInfo) throws SHRWebException {
        WorkPlatformInfo defaultWorkPlatformInfo = WorkPlatformUtils.getUserSettingHomePage(ctx, userInfo);
        try {
            if (defaultWorkPlatformInfo != null) {
                WorkPlatformInfo result = WorkPlatformUtils.getTransWorkPlatformInfo(ctx, defaultWorkPlatformInfo);
                if (WorkPlatformUtils.isHasAccessPermission(ctx, result.getUrl())) {
                    return result;
                }
                return WorkPlatformUtils.getTransWorkPlatformInfo(ctx, WorkPlatformUtils.getRedirectDefaultUserWorkPlatform(request, ctx));
            }
            return WorkPlatformUtils.getTransWorkPlatformInfo(ctx, WorkPlatformUtils.getRedirectDefaultUserWorkPlatform(request, ctx));
        }
        catch (SHRWebException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage());
        }
    }

    private static WorkPlatformInfo getTransWorkPlatformInfo(Context ctx, WorkPlatformInfo workPlatformInfo) throws EASBizException, BOSException {
        IObjectPK pk;
        if (null != workPlatformInfo && !WorkPlatformUtil.isShowOldWorkbench((Context)ctx) && (pk = WorkPlatformUtil.getOld2NewTransPk((String)workPlatformInfo.getId().toString())) != null) {
            return WorkPlatformFactory.getLocalInstance((Context)ctx).getWorkPlatformInfo(pk);
        }
        return workPlatformInfo;
    }

    private static WorkPlatformInfo getRedirectDefaultUserWorkPlatform(HttpServletRequest request, Context ctx) throws SHRWebException {
        WorkPlatformInfo userDefaultWorkPlatform = WorkPlatformUtils.getUserDefaultHomePage(ctx);
        if (userDefaultWorkPlatform != null) {
            return userDefaultWorkPlatform;
        }
        request.setAttribute("HasNoWorkPlatform", (Object)true);
        throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "permission_deny"));
    }

    private static WorkPlatformInfo getUserDefaultHomePage(Context ctx) throws SHRWebException {
        try {
            WorkPlatformCollection wpcc = WorkPlatformFactory.getLocalInstance((Context)ctx).getMyWorkPlatform();
            if (null == wpcc || wpcc.isEmpty()) {
                return null;
            }
            return wpcc.get(0);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    public static boolean isHasAccessPermission(Context ctx, String url) throws SHRWebException {
        boolean hasPerm = false;
        try {
            long begin = System.currentTimeMillis();
            boolean isOracleDB = SystemContextUtil.isOracleDB((Context)ctx);
            FilterInfo filter = new FilterInfo();
            if (isOracleDB) {
                String permissionSql = PermissionFactory.getLocalInstance((Context)ctx).getFunctionPermissionsByMenu();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getMyWorkPlatformIdSql((String)permissionSql, (boolean)isOracleDB), CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getNewMyWorkPlatformIdSql((String)permissionSql), CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("url", (Object)url, CompareType.EQUALS));
                filter.setMaskString("(#0 or #1) and #2 and #3");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)WorkPlatformUtil.getMyWorkPlatformIdFilterSql((Context)ctx, (boolean)isOracleDB), CompareType.INNER));
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("url", (Object)url, CompareType.EQUALS));
            }
            if (WorkPlatformFactory.getLocalInstance((Context)ctx).exists(filter)) {
                hasPerm = true;
            }
            long end = System.currentTimeMillis();
            logger.error((Object)("WorkPlatformUtils isHasAccessPermission cost:" + (end - begin)));
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return hasPerm;
    }

    public static String getCurrentWorkPlatformIdByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        WorkPlatformInfo workPlatformInfo = (WorkPlatformInfo)WorkPlatformFactory.getLocalInstance((Context)ctx).getWorkPlatformByUipk(uipk);
        String currentWorkPlatformId = (workPlatformInfo = WorkPlatformUtils.getTransWorkPlatformInfo(ctx, workPlatformInfo)) != null ? workPlatformInfo.getId().toString() : "";
        return currentWorkPlatformId;
    }
}

