/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.json;

import com.kingdee.shr.util.AttributeTrans;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.jsp.JspContext;

public class JSONMaker {
    public static String getJSON(JspContext jc, String[] excludeAttrs, AttributeTrans[] attributeTranses) {
        Enumeration attributeNamesInScope = jc.getAttributeNamesInScope(1);
        boolean isFirst = true;
        StringBuffer sb = new StringBuffer();
        while (attributeNamesInScope.hasMoreElements()) {
            Object value;
            String key = (String)attributeNamesInScope.nextElement();
            if (JSONMaker.isContain(key, excludeAttrs) || (value = jc.getAttribute(key)) == null || "".equals(value.toString())) continue;
            AttributeTrans trans = JSONMaker.isSpecialHandle(key, attributeTranses);
            if (trans != null) {
                key = trans.getOriginalAttr();
                if (trans.isNeedDoubleQuotes()) {
                    value = "\"" + value.toString() + "\"";
                }
                if (!(trans.isNeedDoubleQuotes() || !trans.isAutoDectDoubleQuotes() || value.equals("true") || value.equals("false") || JSONMaker.isNumeric((String)value))) {
                    value = "\"" + value.toString() + "\"";
                }
            } else if (value instanceof String) {
                value = "\"" + value.toString() + "\"";
            }
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(JSONMaker.getJSON(key, value.toString()));
        }
        return "{" + sb.toString() + "}";
    }

    public static String getJSON(JspContext jc, AttributeTrans[] attributeTranses) {
        return JSONMaker.getJSON(jc, null, attributeTranses);
    }

    public static String getJSON(JspContext jc, String[] excludeAttrs, String[] withoutDoubleQuotes) {
        Enumeration attributeNamesInScope = jc.getAttributeNamesInScope(1);
        boolean isFirst = true;
        StringBuffer sb = new StringBuffer();
        while (attributeNamesInScope.hasMoreElements()) {
            String type;
            Object value;
            String key = (String)attributeNamesInScope.nextElement();
            if (JSONMaker.isContain(key, excludeAttrs) || (value = jc.getAttribute(key)) == null || value instanceof String && value.toString().length() <= 0 && (type = (String)jc.getAttribute("_type_")) != null && (type.equals("EditGrid") || type.equals("Grid"))) continue;
            if (value instanceof String && !JSONMaker.isContain(key, withoutDoubleQuotes)) {
                value = "\"" + value.toString() + "\"";
            }
            if (value instanceof Date) {
                value = "\"" + JSONMaker.getDateString((Date)value) + "\"";
            }
            if (value instanceof Locale) {
                value = "\"" + ((Locale)value).getLanguage() + "\"";
            }
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(JSONMaker.getJSON(key, value.toString()));
        }
        return "{" + sb.toString() + "}";
    }

    private static String getDateString(Date value) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return fmt.format(value);
    }

    private static boolean isContain(String key, String[] excludeAttrs) {
        if (key == null) {
            return false;
        }
        if (excludeAttrs == null) {
            excludeAttrs = new String[]{"org.apache.taglibs.standard.ImplicitObjects"};
        } else {
            String[] tmp = new String[excludeAttrs.length + 1];
            int i = 0;
            String[] stringArray = excludeAttrs;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String attr;
                tmp[i] = attr = stringArray[j];
                ++i;
            }
            tmp[tmp.length - 1] = "org.apache.taglibs.standard.ImplicitObjects";
            excludeAttrs = tmp;
        }
        key = key.trim();
        for (String string : excludeAttrs) {
            if (!key.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static AttributeTrans isSpecialHandle(String key, AttributeTrans[] attributeTranses) {
        if (key == null || attributeTranses == null) {
            return null;
        }
        key = key.trim();
        for (AttributeTrans trans : attributeTranses) {
            if (!key.equals(trans.getJspAttr())) continue;
            return trans;
        }
        return null;
    }

    private static String getJSON(String key, String value) {
        return key + ":" + value;
    }

    private static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getJSON(JspContext jc, String[] excludeAttrs, String[] withoutDoubleQuotes, String[] multipleTypeAttrs) {
        Enumeration attributeNamesInScope = jc.getAttributeNamesInScope(1);
        StringBuffer sb = new StringBuffer();
        while (attributeNamesInScope.hasMoreElements()) {
            String value;
            String key = (String)attributeNamesInScope.nextElement();
            if (JSONMaker.isContain(key, excludeAttrs) || (value = JSONMaker.getValue(jc, key, withoutDoubleQuotes, multipleTypeAttrs)) == null || "".equals(value) || value.length() <= 0) continue;
            sb.append(JSONMaker.getJSON(key, value)).append(",");
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(","), sb.length());
        }
        return "{" + sb.toString() + "}";
    }

    private static String getValue(JspContext jc, String key, String[] withoutDoubleQuotes, String[] multipleTypeAttrs) {
        String result = "";
        Object value = jc.getAttribute(key);
        if (value != null) {
            if (value instanceof String) {
                String temp = (String)value;
                value = temp.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
                result = JSONMaker.isContain(key, multipleTypeAttrs) ? (value.equals("true") || value.equals("false") || JSONMaker.isNumeric((String)value) ? value.toString() : "\"" + value.toString() + "\"") : (!JSONMaker.isContain(key, withoutDoubleQuotes) ? "\"" + value.toString() + "\"" : value.toString());
            } else if (value.getClass().isArray()) {
                StringBuffer sb = new StringBuffer();
                sb.append("'");
                for (int i = 0; i < Array.getLength(value); ++i) {
                    sb.append(Array.get(value, i)).append(",");
                }
                if (sb.length() > 1) {
                    sb.delete(sb.lastIndexOf(","), sb.length());
                }
                sb.append("'");
                result = sb.toString();
            } else {
                result = value.toString();
            }
        }
        return result;
    }

    public static String getValue(JspContext jc, String key) {
        Object value = jc.getAttribute(key);
        return value == null ? "" : value.toString();
    }
}

