/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.msf.web.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class MsfWebUtils {
    private static final String X_OSF_SIGNATURE = "X-OSF-Signature";
    private static final String USER_AGENT = "User-Agent";
    private static final String SHR_MSF_SERVICE_DO = "/shr/shr/msf/service.do";
    private static final String BROWSER_REGEX = ".*(Mozilla|Firefox|Chrome|Safari|Opera|Trident|Edge|MSIE|AppleWebKit).*";
    private static final String X_OSF_SIGNATURE_SESSION_VALUE = "X_OSF_Signature_Session_Value";

    private MsfWebUtils() {
    }

    public static boolean isOuterCallOsf(Context ctx, HttpServletRequest request) {
        boolean isBaseDB = SystemContextUtil.isBaseDBUserAuthPattern((Context)ctx);
        if (isBaseDB && LoginType.WEBSERVICE.toString().equals(SystemContextUtil.getLoginType((Context)ctx))) {
            return true;
        }
        return !isBaseDB && !MsfWebUtils.isRequestFromBrowser(request);
    }

    private static boolean isRequestFromBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader(USER_AGENT);
        String xOSFSignatureEk = request.getHeader(X_OSF_SIGNATURE);
        try {
            if (StringUtils.isEmpty((String)xOSFSignatureEk)) {
                return false;
            }
            String xOSFSignatureSessionValue = (String)request.getSession().getAttribute(X_OSF_SIGNATURE_SESSION_VALUE);
            if (StringUtils.isEmpty((String)xOSFSignatureSessionValue)) {
                request.getSession().setAttribute(X_OSF_SIGNATURE_SESSION_VALUE, (Object)xOSFSignatureEk);
            } else if (xOSFSignatureSessionValue.equals(xOSFSignatureEk)) {
                return false;
            }
            request.getSession().setAttribute(X_OSF_SIGNATURE_SESSION_VALUE, (Object)xOSFSignatureEk);
            String dv = UrlParamEncryptHelper.decodeForAes(xOSFSignatureEk);
            if (StringUtils.isEmpty((String)dv) || dv.indexOf(",") == -1) {
                return false;
            }
            String[] dvs = dv.split(",");
            if (!StringUtils.isEmpty((String)userAgent) && SHR_MSF_SERVICE_DO.equals(dvs[0])) {
                Pattern pattern = Pattern.compile(BROWSER_REGEX, 2);
                Matcher matcher = pattern.matcher(userAgent);
                return matcher.matches();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

