/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.ContextFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jasig.cas.client.validation.Assertion;

public class HRContextFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(HRContextFilter.class);
    private FilterConfig config;
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.config = filterConfig;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String username = request.getParameter("username");
        try {
            if (!FilterUtil.isUnFilter((ServletRequest)servletRequest) && username == null) {
                String ctxUsername;
                HttpSession session = request.getSession();
                if (null == session) {
                    ((HttpServletResponse)servletResponse).sendRedirect("/shr/web_frame/easrpc/frame.do?method=logout");
                    return;
                }
                Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
                if (assertion != null && (ctxUsername = assertion.getPrincipal().getName()) != null) {
                    SHRContext shrContext = ContextFactory.getContext((ServletContext)this.servletContext, (ServletRequest)servletRequest, (ServletResponse)servletResponse);
                    Context ctx = null;
                    if (shrContext != null) {
                        ctx = shrContext.getContext();
                        if (null == ctx) {
                            logger.error((Object)MessageFormat.format(" HRContextFilter getContext is null ,then create Context By AutoLoginConfig , ctxUsername is : {0} ", ctxUsername));
                            ctx = this.createContextByAutoLoginConfig(request, ctxUsername);
                        }
                        HRFilterUtils.initOrgUnit((Context)ctx);
                        ConfigMDUtil.setContextToThread((Context)ctx);
                    }
                    if (shrContext == null) {
                        ctx = this.createContextByAutoLoginConfig(request, ctxUsername);
                        HRFilterUtils.initOrgUnit((Context)ctx);
                    }
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (SHRWebException e) {
            throw new ServletException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new ServletException((Throwable)e);
        }
        catch (BOSException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            SHRContext.setInstance(null);
        }
    }

    public Context createContextByAutoLoginConfig(HttpServletRequest request, String ctxUsername) {
        HashMap<String, String> attribute = new HashMap<String, String>();
        attribute.put("userAuthPattern", AutoLoginConfigPropUtil.getAuthPattern());
        attribute.put("dataCenter", AutoLoginConfigPropUtil.getDataCenter());
        attribute.put("dbType", SystemContextUtil.getDbTypeByDataCenter((String)((String)attribute.get("dataCenter"))));
        attribute.put("locale", AutoLoginConfigPropUtil.getLocale());
        attribute.put("solutionName", "eas");
        attribute.put("isPureWeb", "true");
        return LoginUtil.createEasContext((String)ctxUsername, attribute, (HttpServletRequest)request);
    }

    public void destroy() {
        this.config = null;
    }
}

