/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin.web.controller;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.util.PropertiesUtil;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.LicenseHelper;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.guilogin.EASServiceHelper;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web_frame/easrpc/frame"})
public class FrameController
extends WebComponentController {
    private static final Logger logger = LoggerFactory.getLogger(FrameController.class);

    @RequestMapping(params={"method=showPasswordUI"})
    public String showPasswordUI(HttpServletRequest request, HttpServletResponse response) {
        return "passwordPolicyCheckContent";
    }

    @RequestMapping(params={"method=changePassword"})
    public void changePassword(HttpServletRequest request, HttpServletResponse response) {
        String strOldPwd = request.getParameter("oldPassStr");
        String strNewPwd = request.getParameter("newPassStr");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String str = "";
        try {
            strOldPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strOldPwd);
            strNewPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strNewPwd);
            IUser iUser = UserFactory.getRemoteInstance();
            iUser.updatePass(ctx.getCaller(), strOldPwd, strNewPwd);
            ctx.put((Object)"encryptPassword", (Object)strNewPwd);
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                UserException ue = (UserException)e;
                UserException.PASSWORD_NOT_MATCH.getCode().equals(ue.getSubCode());
                str = "kingdee.portal.i18n.oldpassworderror";
            } else {
                str = e.getMessage();
            }
            logger.error("Change password error:", (Throwable)e);
        }
        this.writeAjaxData(request, response, true, str);
    }

    protected void writeAjaxData(HttpServletRequest request, HttpServletResponse response, boolean success, Object result) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("result", tempResult);
        try {
            JSONUtils.writeJson((HttpServletResponse)response, (Object)result);
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"method=logout"})
    public String logout(HttpServletRequest request, HttpServletResponse response) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        return "/shr/gui/logout";
    }

    @RequestMapping(params={"method=refresh4UserMonitor"})
    public String refresh4UserMonitor(HttpServletRequest request, HttpServletResponse response) {
        this.writeAjaxData(request, response, true, null);
        return null;
    }

    @RequestMapping(params={"method=clearCache"})
    public String clearCache(HttpServletRequest request, HttpServletResponse response) {
        this.writeAjaxData(request, response, true, null);
        return null;
    }

    @RequestMapping(params={"method=logoutAndReleaseResource"})
    public String logoutAndReleaseResource(HttpServletRequest request, HttpServletResponse response) {
        int indexOfServer;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String result = null;
        Properties prop = PropertiesUtil.getProperties((String)PropertiesUtil.getDefaultFullName((String)"ssoClient.properties"));
        String casserver = (String)prop.get("cas.server.url");
        if (!casserver.endsWith("/")) {
            casserver = casserver + "/";
        }
        if ((indexOfServer = casserver.indexOf("127.0.0.1")) >= 0) {
            casserver = StringUtils.replace((String)casserver, (String)"127.0.0.1", (String)request.getServerName());
        }
        result = casserver;
        try {
            LicenseHelper.releaseLicenseBySessionID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpSession session = request.getSession();
        try {
            SessionInfo bossession;
            if (ctx != null && (bossession = SessionManager.getInstance().getSession(ctx.getContextID())) != null) {
                SessionManager.getInstance().removeSession(ctx.getContextID());
                ((LoginContext)bossession.get((Object)"LoginContext")).logout();
            }
            if (session != null) {
                EASServiceHelper helper = new EASServiceHelper();
                helper.deleteUserMonitor(request);
                session.invalidate();
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (LoginException e) {
            e.printStackTrace();
        }
        String redirectUrl = result + "logout";
        try {
            JSONUtils.SUCCESS((Object)redirectUrl);
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(params={"method=deleteUserMonitor"})
    public String deleteUserMonitor(HttpServletRequest request, HttpServletResponse response) {
        String kickAllOthers = request.getParameter("kickAllOthers");
        EASServiceHelper helper = new EASServiceHelper();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if ("true".equals(kickAllOthers)) {
            logger.info("kickAllOthers action start.");
            helper.deleteUserMonitorAllOtherPortalUser(ctx.getUserName(), ctx.getAIS(), FrameController.getIpAddr(request), ctx.getContextID());
        } else {
            helper.deleteUserMonitor(request);
        }
        this.addUserMonitorInfo(ctx, request);
        this.writeAjaxData(request, response, true, null);
        return null;
    }

    @RequestMapping(params={"method=addToUserMonitor"})
    private void addUserMonitorInfo(Context ctx, HttpServletRequest httpRequest) {
        Locale userLocale = null;
        if (ctx != null) {
            userLocale = ctx.getLocale();
        } else {
            String defaultLanguage = httpRequest.getSession().getServletContext().getInitParameter("com.kingdee.eas.portal.defaultLanguage");
            if (defaultLanguage == null || "".equals(defaultLanguage)) {
                defaultLanguage = "L2";
            }
            userLocale = new Locale(defaultLanguage);
        }
        HttpSession session = httpRequest.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
        UserMonitorSessionInfo userMonitorSessionInfo = new UserMonitorSessionInfo();
        userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
        userMonitorSessionInfo.setLastUpdateTime(new Date());
        userMonitorSessionInfo.setLastCheckTickedTime(new Date());
        userMonitorSessionInfo.setId(ctx.getContextID());
        session.setAttribute("userMonitorSessionInfo", (Object)userMonitorSessionInfo);
    }

    private static String getIpAddr(HttpServletRequest request) {
        String portalIP = request.getHeader("nap_proxy_client_ip");
        if (portalIP != null && portalIP.trim().length() > 0) {
            return portalIP;
        }
        portalIP = request.getHeader("x-forwarded-for");
        if (portalIP != null && portalIP.trim().length() > 0) {
            try {
                if (portalIP.indexOf(",") != -1) {
                    // empty if block
                }
                return portalIP.substring(0, portalIP.indexOf(","));
            }
            catch (Exception e) {
                logger.error("X_FORWARDED_FOR : Get Real IP Address  err!", (Throwable)e);
            }
        }
        if ((portalIP = request.getHeader("Proxy-Client-IP")) != null && portalIP.trim().length() > 0) {
            return portalIP;
        }
        return request.getRemoteAddr() == null ? "127.0.0.1" : request.getRemoteAddr();
    }
}

