/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.lightapp.util;

import com.kingdee.shr.lightapp.util.AppAuth2;
import com.kingdee.shr.lightapp.util.StringUtil;
import com.kingdee.shr.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class McloudParamsUtil {
    private static final Logger logger = Logger.getLogger(McloudParamsUtil.class);
    protected static McloudParamsUtil instance = null;
    private static Map accessTokenMap = new HashMap();
    private static Object lock = new Object();

    private McloudParamsUtil() {
    }

    public static McloudParamsUtil getInstance() {
        if (instance == null) {
            instance = new McloudParamsUtil();
        }
        return instance;
    }

    public XtParamsDTO getXtParamsDTO(String appId, String ticket) throws Exception {
        XtParamsDTO xtparamsDto = null;
        String accessToken = this.getAccessToken(appId, ticket);
        if (!StringUtil.isNotEmpty(accessToken) || accessToken.equalsIgnoreCase("null")) {
            logger.error((Object)"McloudParamsUtil == getXtParamsDTO== AccessToken is null!!!");
            throw new Exception("EAS_LOGIN_CODE_00004");
        }
        xtparamsDto = this.getKdWeiboInfo(accessToken, appId, ticket);
        logger.info((Object)"McloudParamsUtil == getXtParamsDTO== end!");
        return xtparamsDto;
    }

    public XtParamsDTO getXtParamsDTOByEid(String appId, String eid, String openId) throws Exception {
        XtParamsDTO xtparamsDto = null;
        String accessToken = this.getAccessToken(appId, "");
        if (!StringUtil.isNotEmpty(accessToken) || accessToken.equalsIgnoreCase("null")) {
            logger.error((Object)"McloudParamsUtil == getXtParamsDTO== AccessToken is null!!!");
            throw new Exception("EAS_LOGIN_CODE_00004");
        }
        xtparamsDto = new XtParamsDTO();
        xtparamsDto.setEid(eid);
        xtparamsDto.setOpenid(openId);
        logger.info((Object)"McloudParamsUtil == getXtParamsDTO== end!");
        return xtparamsDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccessToken(String appId, String ticket) throws Exception {
        long curTime;
        long passTime;
        AccessTokenInfo accessTokenInfo = null;
        if (accessTokenMap.get(appId) != null && !StringUtils.isEmpty((String)(accessTokenInfo = (AccessTokenInfo)accessTokenMap.get(appId)).accessToken) && (passTime = (curTime = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) < accessTokenInfo.expireTime - 3600L) {
            return accessTokenInfo.accessToken;
        }
        Object object = lock;
        synchronized (object) {
            long curTime2;
            long passTime2;
            if (accessTokenMap.get(appId) != null && !StringUtils.isEmpty((String)(accessTokenInfo = (AccessTokenInfo)accessTokenMap.get(appId)).accessToken) && (passTime2 = (curTime2 = System.currentTimeMillis()) - accessTokenInfo.accessTokenTime) < accessTokenInfo.expireTime - 3600L) {
                return accessTokenInfo.accessToken;
            }
            String secret = XTServiceConfig.getInstance().getAppSecret(appId);
            String mcloudHost = XTServiceConfig.getInstance().getXTMcloudUrl();
            String url = "http://do.kdweibo.com/openauth2/api/appAuth2?grant_type=client_credential&appid=" + appId + "&secret=" + secret;
            String response = this.getMessage(url, appId, ticket);
            accessTokenInfo = new AccessTokenInfo();
            accessTokenInfo.accessToken = "";
            if (StringUtil.isNotEmpty(response)) {
                try {
                    JSONObject jsonObj = new JSONObject(response);
                    if (jsonObj != null) {
                        JSONObject obj = (JSONObject)jsonObj.get("data");
                        accessTokenInfo.accessToken = obj.getString("access_token");
                        accessTokenInfo.expireTime = Long.parseLong(obj.getString("expires_in"));
                        accessTokenInfo.accessTokenTime = System.currentTimeMillis();
                        accessTokenMap.put(appId, accessTokenInfo);
                    }
                }
                catch (JSONException e) {
                    accessTokenInfo.expireTime = 0L;
                    accessTokenInfo.accessTokenTime = System.currentTimeMillis();
                    logger.error((Object)("McloudParamsUtil === JSONException getAccessToken message==" + e.getMessage()), (Throwable)e);
                    throw new Exception("EAS_LOGIN_CODE_00002", e);
                }
            }
        }
        return accessTokenInfo.accessToken;
    }

    private XtParamsDTO getKdWeiboInfo(String accessToken, String appid, String ticket) throws Exception {
        XtParamsDTO xtparamsDto = null;
        String mcloudHost = XTServiceConfig.getInstance().getXTMcloudUrl();
        String url = mcloudHost + "/openauth2/api/getcontext?ticket=" + ticket + "&access_token=" + accessToken;
        String response = this.getMessage(url, appid, ticket);
        if (StringUtil.isNotEmpty(response)) {
            try {
                JSONObject jsonObj = new JSONObject(response);
                if (jsonObj != null) {
                    xtparamsDto = new XtParamsDTO();
                    xtparamsDto.setEid(jsonObj.getString("eid"));
                    xtparamsDto.setOpenid(jsonObj.getString("openid"));
                }
            }
            catch (JSONException e) {
                logger.error((Object)("McloudParamsUtil === JSONException getKdWeiboInfo message==" + e.getMessage()), (Throwable)e);
                throw new Exception("EAS_LOGIN_CODE_00003", e);
            }
        }
        return xtparamsDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessage(String surl, String appid, String secret) throws Exception {
        secret = XTServiceConfig.getInstance().getAppSecret(appid);
        String response = null;
        HttpClient http = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(surl);
            http.setConnectionTimeout(5000);
            http.setTimeout(5000);
            String headerValue = AppAuth2.appAuth2Treaty(appid, secret);
            get.setRequestHeader("authorization", headerValue);
            http.executeMethod((HttpMethod)get);
            response = new String(get.getResponseBodyAsString().getBytes("UTF-8"));
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return response;
    }

    private class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 0L;

        private AccessTokenInfo() {
        }
    }
}

