/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.lightapp.wx;

import com.kingdee.shr.lightapp.wx.CantGetWXAccessTokenException;
import com.kingdee.shr.lightapp.wx.WXUtil;
import java.net.URLEncoder;
import org.json.JSONObject;

public class AccessTokenCache {
    private static String access_token = null;
    private static long access_token_time = 0L;
    private static Object lock = new Object();
    private static final String accessTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";

    public static String getAccessToken() throws Exception {
        long curTime = System.currentTimeMillis();
        long valideTime = curTime - access_token_time;
        if (valideTime > 6600000L) {
            access_token = null;
        }
        if (access_token != null) {
            return access_token;
        }
        return AccessTokenCache.innerGet();
    }

    public static String refreshAccessToken() throws Exception {
        access_token = null;
        return AccessTokenCache.innerGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String innerGet() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (access_token != null) {
                return access_token;
            }
            access_token = AccessTokenCache.innerGet0();
            access_token_time = System.currentTimeMillis();
            return access_token;
        }
    }

    private static String innerGet0() throws Exception {
        String[] configs = WXUtil.getWXConfig();
        String corpid = configs[0];
        String corpsecret = configs[1];
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + URLEncoder.encode(corpid, "UTF-8") + "&corpsecret=" + URLEncoder.encode(corpsecret, "UTF-8");
        String result = WXUtil.getResponse(url);
        JSONObject jb = new JSONObject(result);
        if (!jb.isNull("access_token")) {
            String access_token = jb.getString("access_token");
            return access_token;
        }
        throw new CantGetWXAccessTokenException("get accessToken failed " + result);
    }
}

