/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.app.util.MsfServiceUtil;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.msf.web.util.MsfWebUtils;
import com.kingdee.shr.osf.OSFCacheHelper;
import com.kingdee.util.StringUtils;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SHROSFUtil {
    private static Logger logger = Logger.getLogger(SHROSFUtil.class);
    private static String RESOURCE = "com.kingdee.shr.base.syssetting.SHRSystemResource";

    public static Object processOSF(HttpServletRequest request, HttpServletResponse response, String serviceName, String param) {
        StringBuffer caller = new StringBuffer();
        caller.append("request ip=" + SHROSFUtil.getIpAddr(request)).append(" serviceName=" + serviceName).append(" param=").append(param);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sucess", "true");
        result.put("msgCode", "200");
        result.put("errorMsg", "");
        Context ctx = (Context)request.getSession().getAttribute("pureWebContext");
        if (ctx == null) {
            result.put("sucess", "false");
            result.put("msgCode", "500");
            result.put("errorMsg", SHRWebResource.getString((String)RESOURCE, (String)"account_relogin"));
            caller.append(" sucess =" + result.get("sucess")).append(" msgCode=" + result.get("msgCode")).append(" errorMsg=" + result.get("errorMsg"));
        } else {
            SessionInfo bossession = SessionManager.getInstance().getSession(ctx.getContextID());
            if (bossession == null) {
                result.put("sucess", "false");
                result.put("msgCode", "500");
                result.put("errorMsg", SHRWebResource.getString((String)RESOURCE, (String)"session_invalid"));
                caller.append(" sucess =" + result.get("sucess")).append(" msgCode=" + result.get("msgCode")).append(" errorMsg=" + result.get("errorMsg"));
            } else {
                String user = ctx.getAIS() + "@" + ctx.getUserName();
                caller.append(" user =").append(user);
                String errorMsg = "";
                String msgCode = "200";
                Object data = null;
                ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo((Context)ctx, (String)serviceName);
                try {
                    IMSFServiceFacade iMSFServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
                    if (serviceInfo == null) {
                        errorMsg = "service=" + serviceName + " cannot find ";
                        msgCode = "206";
                    }
                    boolean isOuterCall = MsfWebUtils.isOuterCallOsf((Context)ctx, (HttpServletRequest)request);
                    MsfServiceUtil.checkOuterAndInnerOsfPermission((Context)ctx, (String)serviceName, (ServiceInfo)serviceInfo, (boolean)isOuterCall);
                    HashMap cleanMap = new HashMap();
                    if (!StringUtils.isEmpty((String)param)) {
                        cleanMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
                    }
                    if (StringUtils.isEmpty((String)errorMsg)) {
                        if (serviceInfo.getServiceType() == 10) {
                            cleanMap.put("HttpServletRequest", request);
                            cleanMap.put("HttpServletResponse", response);
                            data = MsfServiceUtil.processService((Context)ctx, (ServiceInfo)serviceInfo, (Map)cleanMap);
                        } else {
                            data = iMSFServiceFacade.processService(serviceName, (Map)cleanMap);
                            if (data == null) {
                                data = "";
                            }
                        }
                    }
                }
                catch (Exception e) {
                    errorMsg = SHROSFUtil.handleException(e, request);
                    msgCode = "500";
                }
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    result.put("sucess", "false");
                }
                result.put("msgCode", msgCode);
                result.put("errorMsg", errorMsg);
                result.put("data", data);
                caller.append(" sucess =" + result.get("sucess")).append(" msgCode=" + msgCode).append(" errorMsg=" + errorMsg);
                if (logger.isDebugEnabled()) {
                    caller.append(" data=").append(JSONUtils.convertObjectToJson((Context)ctx, (Object)data));
                }
            }
        }
        return result;
    }

    private static String handleException(Exception e, HttpServletRequest request) {
        String errorMsg = "";
        Throwable throwable = e.getCause();
        if (e instanceof ShrWebBizException) {
            errorMsg = e.getMessage();
        } else if (e instanceof EASBizException || e instanceof ShrWebBizException) {
            errorMsg = e.getMessage();
        } else if (e instanceof UndeclaredThrowableException) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            errorMsg = e.getMessage();
        } else {
            errorMsg = e.getMessage();
        }
        return errorMsg;
    }

    private static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

