/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.security.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.UserInfoHelper;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.BASE64Decoder;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.AESUtil;
import com.kingdee.shr.common.util.CommonPropertieUtil;
import com.kingdee.shr.common.util.EASWebCommonUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/security"})
public class SecurityController
extends WebComponentController {
    private static String RESOURCE = "com.kingdee.shr.base.syssetting.SHRSystemResource";
    private static Logger logger = Logger.getLogger(SecurityController.class);

    @RequestMapping(params={"method=changePwd"})
    @Action
    public String changePwdIndexAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        if (!this.requestMethodCheck(request, response)) {
            return "";
        }
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            String oPsw = request.getParameter("oldPsw");
            String psw1 = request.getParameter("newPsw1");
            String psw2 = request.getParameter("newPsw2");
            String token = request.getParameter("token");
            String puk = userInfo.getId().toString();
            Properties p = SHRSyssettingUtil.getKingdeeSupportConfigProperties();
            String key = p.getProperty("AES_ENCRNUMBER_STR_Encrypt");
            oPsw = this.deCodeOldPwd(puk, oPsw, key);
            psw1 = this.deCodeNewPwd1(puk, psw1, key);
            psw2 = this.deCodeNewPwd2(puk, psw2, key);
            String serverToken = (String)request.getSession().getAttribute("randomFlag");
            if (StringUtils.isEmpty((String)token) && StringUtils.isEmpty((String)serverToken)) {
                JSONUtils.ERROR((String)"token is not empty");
                return null;
            }
            if (!token.equals(serverToken)) {
                JSONUtils.ERROR((String)"token not match");
                return null;
            }
            if (StringUtils.isEmpty((String)psw1) && !StringUtils.isEmpty((String)psw2) || !StringUtils.isEmpty((String)psw1) && !psw1.equals(psw2)) {
                JSONUtils.ERROR((String)SHRWebResource.getString((String)RESOURCE, (String)"pwd_not_match"));
                return null;
            }
            oPsw = CryptoTean.encrypt((String)userInfo.getName(), (String)oPsw);
            psw1 = CryptoTean.encrypt((String)userInfo.getName(), (String)psw1);
            IUser iUser = UserFactory.getRemoteInstance();
            iUser.updatePass(ctx.getCaller(), oPsw, psw1);
            userInfo.setChangedPW(true);
            request.getSession().removeAttribute("randomFlag");
            ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo);
        }
        catch (EASBizException e) {
            JSONUtils.ERROR((String)e.getMessage());
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                Throwable throwable = e.getCause();
                JSONUtils.ERROR((String)throwable.getMessage());
            }
            JSONUtils.ERROR((String)e.getMessage(), (Exception)e);
        }
        return null;
    }

    @RequestMapping(params={"method=getToken"})
    @Action
    public String getLoginTokenAction(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        if (!this.requestMethodCheck(request, response)) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String randomFlag = Uuid.create().toString();
            HttpSession session = request.getSession();
            session.setAttribute("randomFlag", (Object)randomFlag);
            map.put("token", randomFlag);
            JSONUtils.SUCCESS(map, (ServletResponse)response);
        }
        catch (SHRWebException e) {
            JSONUtils.ERROR((String)e.getMessage());
        }
        return null;
    }

    @RequestMapping(params={"method=registerIndex"})
    @Action
    public String registerIndexAction(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        if (!this.requestMethodCheck(request, response)) {
            return "";
        }
        String uuid = "Qn5aTdakRZGQZjKpM63FJRO33n8=";
        try {
            IUser iUser = UserFactory.getRemoteInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String registerUser(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String userNumber = request.getParameter("username");
        String userCardNo = request.getParameter("userCardNo");
        String psw1 = request.getParameter("psw1");
        String psw2 = request.getParameter("psw2");
        String dataCenter = request.getParameter("dataCenter");
        SecurityController.initRPC(dataCenter);
        try {
            if (StringUtils.isEmpty((String)psw1) && !StringUtils.isEmpty((String)psw2) || !StringUtils.isEmpty((String)psw1) && !psw1.equals(psw2)) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"pwd_not_match"));
            }
            IUser iUser = UserFactory.getRemoteInstance();
            if (iUser.exists("where number ='" + userNumber + "' and (isDelete=0 or isDelete is null)")) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"account_exist"));
            }
            PersonCollection perColl = SecurityController.getPersonByCardNO(userCardNo);
            PersonInfo personInfo = null;
            if (perColl != null && perColl.size() == 1) {
                personInfo = perColl.get(0);
            } else if (perColl != null && perColl.size() > 1) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"find_mul"));
            }
            if (personInfo == null) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"find_null"));
            }
            if (personInfo.getEmail() == null && personInfo.getBackupEMail() == null) {
                return SecurityController.error(MessageFormat.format(SHRWebResource.getString((String)RESOURCE, (String)"email_not_exist"), personInfo.getName()));
            }
            String oql = "where person.id='" + personInfo.getId() + "' and (isDelete=0 or isDelete is null)";
            if (iUser.exists(oql)) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"bind_already"));
            }
            UserInfo userInfo = SecurityController.getUserInfo(userNumber, personInfo);
            if (userInfo == null) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"no_position"));
            }
            userInfo.setPassword(CryptoTean.encrypt((String)userNumber, (String)psw1));
            SecurityController.sendRegEmail(request, userInfo);
            return SecurityController.success(userInfo.getEmail());
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                Throwable throwable = e.getCause();
                return SecurityController.error(throwable.getMessage());
            }
            return SecurityController.error(e.getMessage());
        }
    }

    public static Map<String, String> activateAccount(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String userId = request.getParameter("uuid");
        String dataCenter = request.getParameter("dc");
        SecurityController.initRPC(dataCenter);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String msg = null;
        try {
            userId = PermissionUtil.decrypt((String)new UserInfo().getBOSType().toString(), (String)userId);
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            if (StringUtils.isEmpty(msg)) {
                resultMap.put("type", "success");
                resultMap.put("url", "http://" + SecurityController.getSeverURL(request) + "" + request.getContextPath() + "/index.do?&method=initalize");
            } else {
                resultMap.put("type", "error");
                resultMap.put("result", msg);
            }
        }
        catch (Exception e) {
            resultMap.put("type", "error");
            resultMap.put("result", e.getMessage());
        }
        return resultMap;
    }

    public static String findPwd(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String dataCenter = request.getParameter("dataCenter");
        String userNumOrEmail = request.getParameter("userNO");
        HashMap resultMap = new HashMap();
        Object msg = null;
        if (StringUtils.isEmpty((String)userNumOrEmail)) {
            return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"name_email_error"));
        }
        SecurityController.initRPC(dataCenter);
        String email = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select FID ");
            sql.append(" from t_pm_user ");
            sql.append(" where UPPER(FNumber) = '").append(userNumOrEmail.toUpperCase()).append("' ");
            sql.append(" or femail = '").append(userNumOrEmail.trim()).append("' ");
            IUser iUser = UserFactory.getRemoteInstance();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("email"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.email"));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            UserCollection usColl = iUser.getUserCollection(viewInfo);
            if (usColl == null || usColl.size() != 1) {
                return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"user_not_exist"));
            }
            email = usColl.get(0).getEmail();
            if (StringUtils.isEmpty((String)email)) {
                if (usColl.get(0).getPerson() != null && !StringUtils.isEmpty((String)usColl.get(0).getPerson().getEmail())) {
                    email = usColl.get(0).getPerson().getEmail();
                    usColl.get(0).setEmail(email);
                } else {
                    return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"not_set_email"));
                }
            }
            SecurityController.sendFindPswEmail(request, usColl.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            return SecurityController.error(e.getMessage());
        }
        return SecurityController.success(email);
    }

    public static String resetPsw(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String userId = request.getParameter("uuid");
        String dataCenter = request.getParameter("dc");
        String psw1 = request.getParameter("psw1");
        String psw2 = request.getParameter("psw2");
        String msg = null;
        if (StringUtils.isEmpty((String)psw1) && !StringUtils.isEmpty((String)psw2) || !StringUtils.isEmpty((String)psw1) && !psw1.equals(psw2)) {
            return SecurityController.error(SHRWebResource.getString((String)RESOURCE, (String)"not_match"));
        }
        SecurityController.initRPC(dataCenter);
        HashMap resultMap = new HashMap();
        UserInfo user = new UserInfo();
        try {
            String time = request.getParameter("time");
            time = PermissionUtil.decrypt((String)user.getBOSType().toString(), (String)time);
            Timestamp createTime = new Timestamp(Long.valueOf(time));
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            if (currentTime.after(DateTimeUtils.addHour((Date)createTime, (long)48L))) {
                msg = SHRWebResource.getString((String)RESOURCE, (String)"invalid_link");
                return SecurityController.error(msg);
            }
            userId = PermissionUtil.decrypt((String)user.getBOSType().toString(), (String)userId);
            IUser iUser = UserFactory.getRemoteInstance();
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            psw1 = CryptoTean.encrypt((String)userInfo.getName(), (String)psw1);
        }
        catch (Exception e) {
            msg = SHRWebResource.getString((String)RESOURCE, (String)"reset_pwd_fail");
            return SecurityController.error(msg);
        }
        String service = "http://" + SecurityController.getSeverURL(request) + "" + EASWebCommonUtil.getEASWebContextPath() + "/index.do?&method=initalize";
        return SecurityController.success(service);
    }

    private static PersonCollection getPersonByCardNO(String userCardNo) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userCardNo)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("email"));
        sic.add(new SelectorItemInfo("backupEMail"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)userCardNo.trim()));
        filterInfo.getFilterItems().add(new FilterItemInfo("passportNO", (Object)userCardNo.trim()));
        filterInfo.setMaskString("#0 or #1");
        viewInfo.setFilter(filterInfo);
        PersonCollection per = PersonFactory.getRemoteInstance().getPersonCollection(viewInfo);
        return per;
    }

    private static UserInfo getUserInfo(String number, PersonInfo pInfo) throws EASBizException, BOSException, ShrWebBizException {
        PersonPositionInfo ppInfo = SecurityController.getPersonPositionInfo(pInfo.getId().toString());
        if (ppInfo == null || ppInfo.getPersonDep() == null) {
            return null;
        }
        HROrgUnitInfo hrUnit = HRUtilExtend.getAdminOrgOfHRO(null, (AdminOrgUnitInfo)ppInfo.getPersonDep());
        CtrlUnitInfo hrCtrlUnit = null;
        FullOrgUnitInfo fullUnitInfo = null;
        if (hrUnit != null) {
            fullUnitInfo = new FullOrgUnitInfo();
            fullUnitInfo.setId(hrUnit.getId());
            hrCtrlUnit = hrUnit.getCU();
        }
        UserInfo userInfo = UserInfoHelper.createNewDefaultUserInfo();
        userInfo.setNumber(number);
        userInfo.setName(pInfo.getName());
        userInfo.setPerson(pInfo);
        String securityId = "00000000-0000-0000-0000-0000000000013EE2C673";
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setId(BOSUuid.read((String)securityId));
        userInfo.setSecurity(securityInfo);
        userInfo.setCU(hrCtrlUnit);
        userInfo.setDefOrgUnit(fullUnitInfo);
        userInfo.setAgentUser(false);
        userInfo.setLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        userInfo.setEmail(pInfo.getEmail());
        userInfo.setBackupEMail(pInfo.getBackupEMail());
        return userInfo;
    }

    private static PersonPositionInfo getPersonPositionInfo(String personId) throws ShrWebBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("personDep.id"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        viewInfo.setFilter(filterInfo);
        try {
            PersonPositionCollection personPositions = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(viewInfo);
            if (personPositions != null && personPositions.size() > 0) {
                return personPositions.get(0);
            }
        }
        catch (BOSException e) {
            throw new ShrWebBizException((Throwable)e);
        }
        return null;
    }

    private static void sendRegEmail(HttpServletRequest request, UserInfo userInfo) throws Exception {
        String URL2 = SecurityController.getURL(request, userInfo, "activate.jsp");
        String toEmail = userInfo.getEmail() != null ? userInfo.getEmail() : userInfo.getBackupEMail();
        String subject = SHRWebResource.getString((String)RESOURCE, (String)"account_active");
        StringBuffer body = new StringBuffer();
        body.append(SHRWebResource.getString((String)RESOURCE, (String)"hello_title")).append("<br/>").append(MessageFormat.format(SHRWebResource.getString((String)RESOURCE, (String)"username"), userInfo.getNumber())).append("<br/>").append(SHRWebResource.getString((String)RESOURCE, (String)"active_link")).append("<br/>").append(URL2).append("<br/><br/>").append(SHRWebResource.getString((String)RESOURCE, (String)"email_foot"));
        MailUtil.getInstance().sendHtmlMail(null, toEmail, subject, body.toString());
    }

    private static void sendFindPswEmail(HttpServletRequest request, UserInfo userInfo) throws Exception {
        String URL2 = SecurityController.getURL(request, userInfo, "resetPswIndex.jsp");
        String toEmail = userInfo.getEmail();
        String subject = SHRWebResource.getString((String)RESOURCE, (String)"reset_pwd");
        StringBuffer body = new StringBuffer();
        body.append(SHRWebResource.getString((String)RESOURCE, (String)"reset_link")).append("<br/>").append(URL2).append("<br/><br/>").append(SHRWebResource.getString((String)RESOURCE, (String)"link_copy"));
        MailUtil.getInstance().sendHtmlMail(null, toEmail, subject, body.toString());
    }

    private static String getURL(HttpServletRequest request, UserInfo userInfo, String action) throws Exception {
        String userId = userInfo.getId().toString();
        userId = CryptoTean.encrypt((String)userInfo.getBOSType().toString(), (String)userId);
        userId = URLEncoder.encode(userId, "UTF-8");
        String time = String.valueOf(System.currentTimeMillis());
        time = CryptoTean.encrypt((String)userInfo.getBOSType().toString(), (String)time);
        time = URLEncoder.encode(time, "UTF-8");
        String dataCenter = request.getParameter("dataCenter");
        dataCenter = URLEncoder.encode(dataCenter, "UTF-8");
        String server_url = SecurityController.getSeverURL(request);
        StringBuffer URL2 = new StringBuffer();
        URL2.append("http://").append(server_url).append("").append(request.getContextPath()).append("/").append(action).append("?dc=").append(dataCenter).append("&uuid=").append(userId).append("&t=").append(time);
        return URL2.toString();
    }

    private static String getSeverURL(HttpServletRequest request) {
        String servletName = request.getServerName();
        int port = 0;
        try {
            String reqUrl = request.getHeader("x-forwarded-host");
            String[] temp = reqUrl.split(":");
            for (int i = 0; i < temp.length; ++i) {
                try {
                    port = Integer.valueOf(temp[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (port <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (Exception reqUrl) {
            // empty catch block
        }
        if (port <= 0) {
            port = request.getServerPort();
        }
        String server_url = servletName + ":" + port;
        if (!StringUtils.isEmpty((String)CommonPropertieUtil.getServerUrl())) {
            server_url = CommonPropertieUtil.getServerUrl();
        }
        return server_url;
    }

    private static String error(String message) throws SHRWebException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("type", "error");
        resultMap.put("result", message);
        return JSONUtils.convertObjectToJson((Context)SHRContext.getInstance().getContext(), resultMap);
    }

    private static String success(String message) throws SHRWebException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("type", "success");
        resultMap.put("result", message);
        return JSONUtils.convertObjectToJson((Context)SHRContext.getInstance().getContext(), resultMap);
    }

    private static void initRPC(String dataCenter) {
        DCInfo dcInfo = null;
        try {
            ArrayList dcList = DCManager.getInstance().getDCList();
            for (int i = 0; i < dcList.size() && !(dcInfo = (DCInfo)dcList.get(i)).getNumber().equals(dataCenter); ++i) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dcInfo != null) {
            Context ctx = new Context(null, dcInfo.getSolutionName(), dcInfo.getNumber(), null);
            String easSessionId = Uuid.create().toString();
            LoginUtil.initRpcConfig((Context)ctx, (String)easSessionId);
        }
    }

    public String base64Decode(String value) {
        try {
            value = new String(new BASE64Decoder().decodeBuffer(value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return value;
    }

    private String deCodeOldPwd(String puk, String srcValue, String key) throws Exception {
        String decodeValue = AESUtil.aesDecrypt((String)srcValue, (String)key);
        String oPswPuk = puk.substring(0, 8);
        String oPswPukPreChar = oPswPuk.substring(0, 4);
        String oPswPukAfterChar = oPswPuk.substring(4);
        decodeValue = decodeValue.replace(oPswPukPreChar, "").replace(oPswPukAfterChar, "");
        return decodeValue;
    }

    private String deCodeNewPwd1(String puk, String srcValue, String key) throws Exception {
        String decodeValue = AESUtil.aesDecrypt((String)srcValue, (String)key);
        String oPswPuk = puk.substring(8, 16);
        String preChar = oPswPuk.substring(0, 4);
        String pukAfterChar = oPswPuk.substring(4);
        int totalLen = decodeValue.length();
        int preCharLen = preChar.length();
        int pukAfterCharLen = pukAfterChar.length();
        decodeValue = decodeValue.substring(preCharLen);
        decodeValue = decodeValue.substring(0, totalLen - pukAfterCharLen - preCharLen);
        return decodeValue;
    }

    private String deCodeNewPwd2(String puk, String srcValue, String key) throws Exception {
        String decodeValue = AESUtil.aesDecrypt((String)srcValue, (String)key);
        String oPswPuk = puk.substring(16);
        String preChar = oPswPuk.substring(0, 4);
        String pukAfterChar = oPswPuk.substring(4);
        int totalLen = decodeValue.length();
        int preCharLen = preChar.length();
        int pukAfterCharLen = pukAfterChar.length();
        decodeValue = decodeValue.substring(preCharLen);
        decodeValue = decodeValue.substring(0, totalLen - pukAfterCharLen - preCharLen);
        return decodeValue;
    }

    private boolean requestMethodCheck(HttpServletRequest request, HttpServletResponse response) {
        boolean flag = true;
        if (!this.isPostMethod(request)) {
            try {
                flag = false;
                response.sendError(403);
                logger.error((Object)SHRCheck.vaildLog((String)MessageFormat.format("com.kingdee.shr.security.web.controller.SecurityController ,/security.do  request method must post , current request method  is [{0}] ", request.getMethod())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    private boolean isPostMethod(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }
}

