/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mobile.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ApproveHisHelper {
    private static final Logger logger = Logger.getLogger(ApproveHisHelper.class);
    private String fields = null;
    private String billid;
    private Context ctx;

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setBillId(String id) {
        this.billid = id;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public ArrayList<HashMap<String, String>> getHistory() throws IOException {
        this.checkFields();
        String query = this.getQuery();
        EntityViewInfo evi = this.getEntityViewInfo();
        ArrayList<HashMap<String, Object>> result = this.queryResult(query, evi);
        for (int i = 0; i < result.size(); ++i) {
            HashMap<String, Object> m = result.get(i);
            Object opion = m.get("MultiApprove.opinion");
            if (opion != null) {
                m.put("MultiApprove.opinion", opion.toString().replaceAll("[\n\r]", "").replaceAll("\"", "\u201c").replaceAll("'", ""));
                continue;
            }
            m.put("MultiApprove.opinion", "");
        }
        result = ApproveHisHelper.mergeRows(result, "MultiApprove.id", new String[]{"Attachment.id", "Attachment.name"});
        ArrayList<HashMap<String, String>> newlist = new ArrayList<HashMap<String, String>>();
        for (int i = 0; i < result.size(); ++i) {
            HashMap<String, Object> m = result.get(i);
            HashMap<String, String> n = new HashMap<String, String>();
            n.put("personName", m.get("personId.name").toString());
            n.put("ispass", m.get("MultiApprove.isPass").toString());
            n.put("opinion", m.get("MultiApprove.opinion").toString());
            n.put("actdefName", m.get("AssignDetail.actdefName").toString());
            Date date = new Date();
            date = (Timestamp)m.get("MultiApprove.createTime");
            SimpleDateFormat s = new SimpleDateFormat("MM-dd hh:mm");
            n.put("createTime", s.format(date));
            newlist.add(n);
        }
        return newlist;
    }

    private ArrayList<HashMap<String, Object>> queryResult(String query, EntityViewInfo evi) {
        ArrayList<HashMap<String, Object>> result;
        try {
            result = this.query(query, evi, this.ctx, false);
        }
        catch (Exception e) {
            throw new RuntimeException("query failed. {" + query + "}", e);
        }
        return result;
    }

    private String getQuery() {
        String query = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
        if (this.fields.indexOf("AdminOrgUnit") >= 0 || this.fields.indexOf("Position") >= 0) {
            query = "com.kingdee.eas.base.multiapprove.app.MultiApproveWithPositionQuery";
        }
        return query;
    }

    private EntityViewInfo getEntityViewInfo() {
        FilterInfo filter = this.getFilter();
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemInfo info = new SorterItemInfo("MultiApprove.createTime");
        info.setSortType(SortType.DESCEND);
        evi.getSorter().add(info);
        evi.setFilter(filter);
        return evi;
    }

    public FilterInfo getApproveFilter(String billId) throws Exception {
        String[] assignIds = this.getApproveAssignIds(billId);
        return this.generateMultiApproveFilter(billId, assignIds);
    }

    public String[] getApproveAssignIds(String billId) throws Exception {
        return this.getApproveAssignIds(billId, "T_WFR_ASSIGNDETAIL", "t_wfr_procinst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getApproveAssignIds(String billId, String assignTable, String procTable) throws Exception {
        ProcessInstInfo[] infos;
        IEnactmentService svc;
        if (billId == null) {
            throw new NullPointerException("\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        if (billId.indexOf(39) >= 0) {
            throw new Exception("\u975e\u6cd5\u8bbf\u95ee!");
        }
        String procInstId = null;
        if (billId.endsWith("WFWKITEM")) {
            svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo assign = svc.getAssignmentById(billId);
            procInstId = assign.getProcInstId();
            billId = assign.getBizObjectIds();
        } else if (billId.endsWith("WFPCINST") && (billId = this.toBillId(procInstId = billId)) == null) {
            return null;
        }
        if (procTable.equals("t_wfr_procinst") && (infos = (svc = EnactmentServiceFactory.createEnactService((Context)this.ctx)).getProcessInstanceByHoldedObjectId(billId)) != null && infos.length > 0) {
            procInstId = infos[0].getProcInstId();
        }
        Statement smt = null;
        ResultSet rs = null;
        Connection cn = DbConnector.getConnection((Context)this.ctx);
        try {
            Iterator it;
            StringBuffer sb;
            String tmp;
            smt = cn.createStatement();
            String sql = null;
            if (procInstId == null) {
                sql = "select top 1 fprocinstid from " + assignTable + " where fbizobjid='" + billId + "' order by fcreatedtime desc";
                rs = this.executeQuery(smt, sql);
                if (!rs.next()) {
                    String[] stringArray = null;
                    return stringArray;
                }
                procInstId = rs.getString(1);
            }
            HashSet<String> accessed = new HashSet<String>();
            accessed.add(procInstId);
            while ((rs = this.executeQuery(smt, sql = "select fparentprocinstid from " + procTable + " where fprocinstid='" + procInstId + "'")).next() && (tmp = rs.getString(1)) != null) {
                if (accessed.contains(tmp)) {
                    throw new Exception(procInstId + "\u6d41\u7a0b\u5b9e\u4f8b\u7684\u7236\u5b9e\u4f8b\u5c42\u6b21\u5173\u7cfb\u9519\u8bef\uff1a\u4e92\u4e3a\u7236\u5b9e\u4f8b\uff01");
                }
                procInstId = tmp;
                accessed.add(procInstId);
            }
            String procInstIds = "'" + procInstId + "'";
            while (true) {
                sql = "select fprocinstid from " + procTable + " where fparentprocinstid in(" + procInstIds + ")";
                rs = this.executeQuery(smt, sql);
                sb = new StringBuffer();
                while (rs.next()) {
                    procInstId = rs.getString(1);
                    accessed.add(procInstId);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append("'").append(procInstId).append("'");
                }
                if (sb.length() == 0) {
                    sb = new StringBuffer();
                    it = accessed.iterator();
                    break;
                }
                procInstIds = sb.toString();
            }
            while (it.hasNext()) {
                Object e = it.next();
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("'").append(e).append("'");
            }
            procInstIds = sb.toString();
            sql = "SELECT fassignid FROM " + assignTable + " WHERE fbizobjid='" + billId + "' AND FPROCINSTID IN(" + procInstIds + ") AND fstate=" + 16;
            rs = this.executeQuery(smt, sql);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (rs.next()) {
                arrayList.add(rs.getString(1));
            }
            if (arrayList.size() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (smt != null) {
                try {
                    smt.close();
                }
                catch (Throwable t) {}
            }
            try {
                cn.close();
            }
            catch (Throwable t) {}
        }
    }

    private String toBillId(String id) throws WfException, BOSException {
        if (id.endsWith("WFWKITEM")) {
            AssignmentInfo assign = EnactmentServiceFactory.createEnactService((Context)this.ctx).getAssignmentById(id);
            id = assign.getBizObjectIds();
        } else if (id.endsWith("WFPCINST")) {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            AssignmentInfo[] assigns = svc.getAssignmentByProcInstId(id);
            if (assigns == null || assigns.length == 0) {
                return null;
            }
            id = assigns[0].getBizObjectIds();
        }
        return id;
    }

    private ResultSet executeQuery(Statement smt, String sql) throws SQLException {
        return smt.executeQuery(sql);
    }

    public FilterInfo generateMultiApproveFilter(String billId, String[] assignIds) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(billId='" + billId + "')");
        buffer.append(" and (status=" + MultiApproveStatusEnum.SUBMIT.getValue() + ")");
        if (assignIds != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < assignIds.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(assignIds[i]).append("'");
            }
            buffer.append("and (assignment IN (" + sb.toString() + "))");
        } else {
            buffer.append("and (assignment=' ')");
        }
        String oqlFilter = buffer.toString();
        return new FilterInfo(oqlFilter);
    }

    private FilterInfo getFilter() {
        FilterInfo filter;
        try {
            filter = this.getApproveFilter(this.billid);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filter;
    }

    private void checkFields() {
        if (this.fields == null) {
            boolean b2;
            boolean b1;
            StringBuilder s = new StringBuilder(300);
            s.append("AssignDetail.actdefName,MultiApprove.isPass,MultiApprove.handlerOpinion,MultiApprove.opinion,personId.name");
            try {
                b1 = this.showMultiapprovePersonOrg();
            }
            catch (BOSException e) {
                b1 = false;
            }
            try {
                b2 = this.showMultiapproveOrgFullName();
            }
            catch (BOSException e) {
                b2 = false;
            }
            if (b1) {
                s.append(",AdminOrgUnit.name");
            }
            if (b1 || b2) {
                s.append(",Position.name");
            }
            if (b2) {
                s.append(",AdminOrgUnit.displayName");
            }
            s.append(",MultiApprove.createTime,Attachment.name");
            this.fields = s.toString();
        }
    }

    public static ArrayList<HashMap<String, Object>> mergeRows(ArrayList<HashMap<String, Object>> rows, String keyField, String[] mergeFields) {
        if (rows == null) {
            return rows;
        }
        ArrayList<HashMap<String, Object>> array = new ArrayList<HashMap<String, Object>>();
        Object prior = null;
        StringBuffer[] mergedValues = new StringBuffer[mergeFields.length];
        for (int i = 0; i < rows.size(); ++i) {
            String s;
            int j;
            int j2;
            HashMap<String, Object> item = rows.get(i);
            Object value = item.get(keyField);
            Object[] tmp = new Object[mergeFields.length];
            for (j2 = 0; j2 < mergeFields.length; ++j2) {
                tmp[j2] = item.get(mergeFields[j2]);
                if (tmp[j2] != null) continue;
                tmp[j2] = "";
            }
            if (!value.equals(prior)) {
                array.add(item);
                for (j2 = 0; j2 < mergeFields.length; ++j2) {
                    mergedValues[j2] = new StringBuffer().append(tmp[j2]);
                    item.put(mergeFields[j2], mergedValues[j2]);
                }
                prior = value;
                continue;
            }
            boolean needMerge = false;
            for (j = 0; j < mergeFields.length; ++j) {
                s = (String)tmp[j];
                if (s == null || mergedValues[j].indexOf(s) >= 0) continue;
                needMerge = true;
                break;
            }
            if (!needMerge) continue;
            for (j = 0; j < mergeFields.length; ++j) {
                s = (String)tmp[j];
                if (s == null) {
                    s = "";
                }
                mergedValues[j].append(", ").append(s);
            }
        }
        rows.clear();
        rows.addAll(array);
        return array;
    }

    public ArrayList query(String pkFieldName, String[] pkIds, String queryMetaData, Context ctx) throws BOSException, SQLException {
        return this.query(pkFieldName, pkIds, queryMetaData, null, ctx);
    }

    public ArrayList query(String pkFieldName, String[] pkIds, String queryMetaData, String orderBy, Context ctx) throws BOSException, SQLException {
        return this.query(pkFieldName, pkIds, queryMetaData, orderBy, null, ctx);
    }

    public ArrayList query(String pkFieldName, String[] pkIds, String queryMetaData, String orderBy, String selectors, Context ctx) throws BOSException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<String> idList = new HashSet<String>();
        for (String s : pkIds) {
            if (s == null || s.length() == 0) continue;
            idList.add(s);
        }
        if (idList.size() == 0) {
            return new ArrayList();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(pkFieldName, idList, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        if (selectors != null) {
            SelectorItemCollection coll = new SelectorItemCollection();
            String[] tmp = selectors.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                coll.add(tmp[i]);
            }
            viewInfo.setSelector(coll);
        }
        if (orderBy != null && orderBy.length() > 0) {
            String[] array;
            SorterItemCollection coll = new SorterItemCollection();
            for (String item : array = orderBy.split(",")) {
                SortType type;
                String field;
                int i = item.indexOf(32);
                if (i < 0) {
                    field = item;
                    type = SortType.ASCEND;
                } else {
                    field = item.substring(0, i);
                    type = item.substring(i + 1).equals("desc") ? SortType.DESCEND : SortType.ASCEND;
                }
                SorterItemInfo info = new SorterItemInfo(field);
                info.setSortType(type);
                coll.add(info);
            }
            viewInfo.setSorter(coll);
        }
        return this.query(queryMetaData, viewInfo, ctx);
    }

    public ArrayList<HashMap<String, Object>> query(String queryMetaData, EntityViewInfo evi) throws SQLException, BOSException {
        return this.query(queryMetaData, evi, this.ctx);
    }

    public ArrayList<HashMap<String, Object>> query(String queryMetaData, EntityViewInfo evi, Context ctx) throws SQLException, BOSException {
        return this.query(queryMetaData, evi, ctx, false);
    }

    public ArrayList<HashMap<String, Object>> query(String queryMetaData, EntityViewInfo evi, Context ctx, boolean isIgnoreUpperLowerCase) throws SQLException, BOSException {
        MetaDataPK query = new MetaDataPK(queryMetaData);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = true;
        IRowSet set = exec.executeQuery();
        return ApproveHisHelper.recordSet2ArrayList(set, isIgnoreUpperLowerCase);
    }

    public ArrayList<HashMap<String, Object>> queryUnion(String[] queryMetaData, EntityViewInfo evi, Context ctx, String[] changeKeys, boolean isIgnoreUpperLowerCase) throws SQLException, BOSException {
        IRowSet set = null;
        StringBuffer sb = new StringBuffer("SELECT * FROM (");
        String orderByStr = null;
        for (int i = 0; i < queryMetaData.length; ++i) {
            MetaDataPK query = MetaDataPK.create((String)queryMetaData[i]);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
            exec.setObjectView(evi);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isIgnorePermissionCheck = true;
            String sql = exec.getSQL();
            int orderByIndex = sql.indexOf("ORDER BY");
            if (orderByStr == null && orderByIndex > 0) {
                orderByStr = sql.substring(orderByIndex);
            }
            if (i != 0) {
                sb.append(" UNION ");
            }
            if (orderByIndex > 0) {
                sb.append(sql.substring(0, orderByIndex));
                continue;
            }
            sb.append(sql);
        }
        sb.append(") WFTEMPTAB ");
        if (!StringUtils.isEmpty(orderByStr)) {
            sb.append(orderByStr);
        }
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString());
        set = sqlExecutor.executeSQL();
        return ApproveHisHelper.recordSet2ArrayList(set, changeKeys, isIgnoreUpperLowerCase);
    }

    public static ArrayList<HashMap<String, Object>> recordSet2ArrayList(IRowSet set) throws SQLException {
        return ApproveHisHelper.recordSet2ArrayList(set, false);
    }

    public static ArrayList<HashMap<String, Object>> recordSet2ArrayList(IRowSet set, boolean isIgnoreUpperLowerCase) throws SQLException {
        return ApproveHisHelper.recordSet2ArrayList(set, null, isIgnoreUpperLowerCase);
    }

    public static ArrayList<HashMap<String, Object>> recordSet2ArrayList(IRowSet set, String[] changeKeys, boolean isIgnoreUpperLowerCase) throws SQLException {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int i;
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                if (isIgnoreUpperLowerCase) {
                    for (i = 1; i <= count; ++i) {
                        item.put(meta.getColumnName(i).toLowerCase(), set.getObject(i));
                    }
                } else {
                    for (i = 1; i <= count; ++i) {
                        String key = meta.getColumnName(i);
                        if (changeKeys != null) {
                            for (int j = 0; j < changeKeys.length; ++j) {
                                if (!key.equalsIgnoreCase(changeKeys[j])) continue;
                                key = changeKeys[j];
                                break;
                            }
                        }
                        item.put(key, set.getObject(i));
                    }
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    public boolean showMultiapprovePersonOrg() throws BOSException {
        return this.paramValueIsTrue("showMultiapprovePersonOrg");
    }

    public boolean showMultiapproveOrgFullName() throws BOSException {
        return this.paramValueIsTrue("showMultiapproveOrgFullName");
    }

    public boolean showMultiapprovePersonOrOrg() {
        try {
            return this.showMultiapprovePersonOrg() || this.showMultiapproveOrgFullName();
        }
        catch (BOSException bOSException) {
            return false;
        }
    }

    public boolean paramValueIsTrue(String param) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue(null, null, (String)param);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }
}

