/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.mobile.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectLimit;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.mobile.server.PageList;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ListDataHelper {
    private static final Logger logger = Logger.getLogger(ListDataHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PageList getRowSet(Context ctx, String sql, int start, int length, String type) throws Exception {
        PageList pageList;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int txIsolation = -1;
        try {
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            int top = start + length;
            cn = QueryConnectionProvider.getConnection((Context)ctx);
            int dbType = KSqlUtil.getDbType((Connection)cn);
            LimitInfo limit = ListDataHelper.getLimitForRealPage(dbType, sql, start, top);
            sql = limit.sql;
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int count = meta.getColumnCount();
            HashMap<String, Object> map = null;
            String columnName = null;
            Object columnObj = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SimpleDateFormat s = new SimpleDateFormat("MM-dd HH:mm");
            PageList resultList = new PageList();
            int startPos = 0;
            while (rs.next()) {
                if (startPos < limit.start) {
                    ++startPos;
                    continue;
                }
                map = new HashMap<String, Object>();
                for (int m = 1; m <= count; ++m) {
                    columnName = meta.getColumnName(m).toLowerCase();
                    columnObj = rs.getObject(m);
                    if ("fstate".equalsIgnoreCase(columnName)) {
                        if ("havedo".equals(type)) {
                            map.put(columnName, WfAssignmentState.getEnum((int)Integer.parseInt(columnObj.toString())).toString());
                            continue;
                        }
                        map.put(columnName, WfState.getEnum((String)columnObj.toString()).toString());
                        continue;
                    }
                    if ("fbizobjid".equalsIgnoreCase(columnName)) {
                        String fbizobjid = columnObj.toString();
                        if (!StringUtils.isEmpty((String)fbizobjid)) {
                            String billName = "";
                            try {
                                billName = loader.getEntity(BOSUuid.read((String)fbizobjid).getType()).getAlias();
                            }
                            catch (Exception e) {
                                logger.error((Object)("fbizobjid\u3000\u3000getType\u3000not  found----------------\u3000: " + fbizobjid));
                            }
                            map.put("billName", billName);
                        }
                        map.put("fbizobjid", fbizobjid);
                        continue;
                    }
                    if ("flaststatetime".equalsIgnoreCase(columnName) || "fcreatedtime".equalsIgnoreCase(columnName) || "fendtime".equalsIgnoreCase(columnName)) {
                        map.put(columnName, s.format(columnObj));
                        continue;
                    }
                    map.put(columnName, columnObj);
                }
                if (!map.containsKey("billtext")) {
                    map.put("billtext", map.get("fprocdefname_l2"));
                }
                resultList.add(map);
            }
            pageList = resultList;
        }
        catch (Exception sqle) {
            try {
                logger.error((Object)("innerGetRowSet() sql: " + sql));
                logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowSet() occur error,The RealPageQuery sql is:" + sql, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return pageList;
    }

    private static LimitInfo getLimitForRealPage(int dbType, String sql, int start, int top) throws BOSException, SqlTranslateException {
        sql = TransUtil.translate((String)sql, (int)dbType, (FormatOptions)new FormatOptions());
        if (dbType == 7 || dbType == 8 || dbType == 2) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            return new LimitInfo(sqlLimit.toString(), 0, top - start);
        }
        if (dbType == 3) {
            return ListDataHelper.getLimitStringForMSSqlSrv(sql, start, top);
        }
        if (dbType == 1 || dbType == 9) {
            return ListDataHelper.getLimitStringForDB2(sql, start, top);
        }
        return new LimitInfo(sql, 0, top - start);
    }

    private static LimitInfo getLimitStringForDB2(String sql, int start, int top) {
        int formIndex = sql.indexOf(" FROM ");
        String selectStr = sql.substring(0, formIndex);
        int orderIndex = sql.indexOf(" ORDER BY ");
        String orderStr = sql.substring(orderIndex);
        String fromSql = sql.substring(formIndex, orderIndex);
        StringBuffer sqlStr = new StringBuffer(" SELECT * FROM (");
        sqlStr.append(selectStr);
        sqlStr.append(",ROWNUMBER() OVER(");
        sqlStr.append(orderStr);
        sqlStr.append(") AS RN ");
        sqlStr.append(fromSql);
        sqlStr.append(" ) AS TA WHERE TA.RN BETWEEN ");
        sqlStr.append(start + 1);
        sqlStr.append(" AND ");
        sqlStr.append(top);
        return new LimitInfo("/*dialect*/" + sqlStr.toString(), 0, top);
    }

    private static LimitInfo getLimitStringForMSSqlSrv(String sql, int start, int top) throws BOSException {
        try {
            SelectParser bizSelectParser = new SelectParser(sql);
            SqlSelect bizSqlSelect = (SqlSelect)bizSelectParser.select();
            bizSqlSelect.limit = top > 0 ? new SqlSelectLimit(top) : new SqlSelectLimit(Integer.MAX_VALUE);
            StringBuffer selectBuffer = new StringBuffer();
            QuerySQLFormater formater = new QuerySQLFormater(selectBuffer);
            formater.formatSelectBase((SqlSelectBase)bizSqlSelect);
            sql = selectBuffer.toString();
            return new LimitInfo("/*dialect*/" + sql, start, top - start);
        }
        catch (Exception e) {
            logger.error((Object)"getLimitStringForMSSqlSrv() occur error: ", (Throwable)e);
            throw new BOSException("getLimitStringForMSSqlSrv", (Throwable)e);
        }
    }

    static class LimitInfo {
        String sql;
        int start;
        int lenth;

        LimitInfo(String sql, int start, int lenth) {
            this.sql = sql;
            this.start = start;
            this.lenth = lenth;
        }
    }
}

