/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.privacy.PrivacyPropertyInfo;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PrivacyPropertyAccess {
    private final Map<String, PrivacyPropertyInfo> properties = new HashMap<String, PrivacyPropertyInfo>();

    public Map<String, PrivacyPropertyInfo> getProperties() {
        return this.properties;
    }

    public void addField(Context ctx, String solutionId, EntityObjectInfo entity, String field, boolean isSimple, String dataType) throws BOSException {
        if (entity == null) {
            this.properties.put(field.toLowerCase(Locale.ENGLISH), new PrivacyPropertyInfo(solutionId, null, isSimple, dataType));
        } else {
            PropertyInfo prop = entity.getPropertyByNameRuntime(field);
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                String column = ownProp.getMappingField().getName();
                if (ownProp.isMultilingual()) {
                    String[] postfix = PrivacyPropertyManager.getLanguagePostfix(ctx);
                    for (int j = 0; j < postfix.length; ++j) {
                        String temp = (column + postfix[j]).toLowerCase(Locale.ENGLISH);
                        this.properties.put(temp, new PrivacyPropertyInfo(solutionId, ownProp, isSimple, dataType));
                    }
                } else {
                    this.properties.put(column.toLowerCase(Locale.ENGLISH), new PrivacyPropertyInfo(solutionId, ownProp, isSimple, dataType));
                }
            }
        }
    }

    public PrivacyPropertyInfo getPrivacyPropBySqlField(String sqlField) {
        return this.properties.get(sqlField.toLowerCase(Locale.ENGLISH));
    }
}

