/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.util;

import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.util.SqlBinaryOpExprProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FormatUtil {
    public static int getBracketNumber(SqlBinaryOpExpr expr, Map ownTreeMap, Map otherTreeMap, boolean isLeft) {
        if (expr == null) {
            return 0;
        }
        if (isLeft && expr.left instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr left = (SqlBinaryOpExpr)expr.left;
            if (left.operator == 7 || left.operator == 8) {
                return 0;
            }
        } else if (!isLeft && expr.right instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr right = (SqlBinaryOpExpr)expr.right;
            if (right.operator == 7 || right.operator == 8) {
                return 0;
            }
        }
        int num = 0;
        SqlBinaryOpExpr top = expr;
        boolean isOr = expr.operator == 8;
        SqlBinaryOpExpr cur = (SqlBinaryOpExpr)ownTreeMap.get(expr);
        while (cur != null) {
            if (cur.operator == 7) {
                if (isOr) {
                    ++num;
                }
                isOr = false;
            } else {
                isOr = true;
            }
            top = cur;
            cur = (SqlBinaryOpExpr)ownTreeMap.get(cur);
        }
        if (top != null && top.operator == 8 && (cur = (SqlBinaryOpExpr)otherTreeMap.get(top)) != null && cur.operator == 7) {
            ++num;
        }
        return num;
    }

    public static boolean processBinaryOpExpr(SqlBinaryOpExpr expr, SqlBinaryOpExprProcessor processor, Map options) throws Exception {
        if (expr == null || expr.operator != 7 && expr.operator != 8) {
            return false;
        }
        HashMap<SqlBinaryOpExpr, SqlBinaryOpExpr> lMap = new HashMap<SqlBinaryOpExpr, SqlBinaryOpExpr>();
        HashMap<SqlBinaryOpExpr, SqlBinaryOpExpr> rMap = new HashMap<SqlBinaryOpExpr, SqlBinaryOpExpr>();
        ArrayList<SqlBinaryOpExpr> stack = new ArrayList<SqlBinaryOpExpr>();
        boolean flag = true;
        while (flag || !stack.isEmpty()) {
            while (flag) {
                stack.add(expr);
                SqlBinaryOpExpr lExpr = null;
                if (expr.left instanceof SqlBinaryOpExpr) {
                    lExpr = (SqlBinaryOpExpr)expr.left;
                }
                if (!(flag = lExpr != null && (lExpr.operator == 7 || lExpr.operator == 8))) continue;
                lMap.put(lExpr, expr);
                expr = lExpr;
            }
            if (stack.isEmpty()) continue;
            expr = (SqlBinaryOpExpr)stack.remove(stack.size() - 1);
            int lBracket = FormatUtil.getBracketNumber(expr, lMap, rMap, true);
            int rBracket = FormatUtil.getBracketNumber(expr, rMap, lMap, false);
            processor.process(expr, lBracket, rBracket, options);
            SqlBinaryOpExpr rExpr = null;
            if (expr.right instanceof SqlBinaryOpExpr) {
                rExpr = (SqlBinaryOpExpr)expr.right;
            }
            if (!(flag = rExpr != null && (rExpr.operator == 7 || rExpr.operator == 8))) continue;
            rMap.put(rExpr, expr);
            expr = rExpr;
        }
        return true;
    }

    public static boolean formatAndOrExpr(SqlBinaryOpExpr expr) throws Exception {
        return false;
    }
}

