/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import java.applet.Applet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeInterfaceAppletHandler {
    private static final Object INITIALIZATION_LOCK = new Object();
    private static boolean isInterfaceToOpen;
    private static Set<Applet> activeAppletSet;

    static {
        activeAppletSet = new HashSet<Applet>();
    }

    private NativeInterfaceAppletHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateAppletMode() {
        NSSystemProperty.DEPLOYMENT_TYPE.set("applet");
        if (NativeInterface.isInProcess()) {
            AtomicBoolean isInitialized;
            AtomicBoolean atomicBoolean = isInitialized = new AtomicBoolean(false);
            synchronized (atomicBoolean) {
                Thread eventPumpThread = new Thread("NativeSwing event pump thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            NativeInterface.initialize();
                        }
                        catch (Throwable throwable) {
                            isInitialized.set(true);
                            AtomicBoolean atomicBoolean = isInitialized;
                            synchronized (atomicBoolean) {
                                isInitialized.notify();
                            }
                            throw throwable;
                        }
                        isInitialized.set(true);
                        AtomicBoolean atomicBoolean = isInitialized;
                        synchronized (atomicBoolean) {
                            isInitialized.notify();
                        }
                        if (!NativeInterface.isEventPumpRunning()) {
                            NativeInterface.runEventPump();
                        }
                    }
                };
                eventPumpThread.setDaemon(true);
                eventPumpThread.start();
                while (!isInitialized.get()) {
                    try {
                        isInitialized.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        } else {
            NativeInterface.initialize();
        }
    }

    public static void init(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.add(applet);
            if (isInterfaceToOpen) {
                NativeInterface.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.remove(applet);
            if (activeAppletSet.isEmpty()) {
                isInterfaceToOpen = NativeInterface.isOpen();
                NativeInterfaceAppletHandler.stopActivity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Applet applet) {
        NativeInterfaceAppletHandler.checkAppletMode();
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            activeAppletSet.remove(applet);
            if (activeAppletSet.isEmpty()) {
                isInterfaceToOpen = false;
                NativeInterfaceAppletHandler.stopActivity();
            }
        }
    }

    private static void stopActivity() {
        NativeInterface.close();
        WebServer.stopDefaultWebServer();
    }

    private static void checkAppletMode() {
        if (!"applet".equals(NSSystemProperty.DEPLOYMENT_TYPE.get())) {
            throw new IllegalStateException(String.valueOf(NativeInterfaceAppletHandler.class.getName()) + ".activateAppletMode() was not called! This code has to be placed first in the applet subclass in a static initializer.");
        }
    }
}

