/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.JFlashPlayer;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class DefaultFlashPlayerDecorator
extends FlashPlayerDecorator {
    private final ResourceBundle RESOURCES;
    private JFlashPlayer flashPlayer;
    private FlashPlayerControlBar controlBar;
    private JPanel nativeComponentBorderContainerPane;

    public DefaultFlashPlayerDecorator(JFlashPlayer flashPlayer, Component renderingComponent) {
        String className = JFlashPlayer.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/FlashPlayer");
        this.flashPlayer = flashPlayer;
        this.nativeComponentBorderContainerPane = new JPanel(new BorderLayout());
        this.nativeComponentBorderContainerPane.add(renderingComponent, "Center");
        this.add((Component)this.nativeComponentBorderContainerPane, "Center");
        this.setControlBarVisible(false);
    }

    protected JFlashPlayer getFlashPlayer() {
        return this.flashPlayer;
    }

    private void adjustBorder() {
        this.nativeComponentBorderContainerPane.setBorder(this.getInnerAreaBorder());
    }

    protected Border getInnerAreaBorder() {
        Border border = this.isControlBarVisible() ? BorderFactory.createBevelBorder(1) : null;
        return border;
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        if (isControlBarVisible == this.isControlBarVisible()) {
            return;
        }
        if (isControlBarVisible) {
            this.controlBar = new FlashPlayerControlBar();
            this.add((Component)this.controlBar, "South");
        } else {
            this.remove(this.controlBar);
            this.controlBar.disconnect();
            this.controlBar = null;
        }
        this.revalidate();
        this.repaint();
        this.adjustBorder();
    }

    public boolean isControlBarVisible() {
        return this.controlBar != null;
    }

    protected void addControlBarComponents(FlashPlayerControlBar controlBar, JComponent buttonContainer) {
        buttonContainer.add(controlBar.getPlayButton());
        buttonContainer.add(controlBar.getPauseButton());
        buttonContainer.add(controlBar.getStopButton());
    }

    protected void configureComponent(JComponent c, FlashDecoratorComponentType componentType) {
        switch (componentType) {
            case PLAY_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("PlayIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("PlayText"));
                return;
            }
            case PAUSE_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("PauseIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("PauseText"));
                return;
            }
            case STOP_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("StopIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("StopText"));
                return;
            }
        }
        throw new IllegalStateException("Type not handled: " + (Object)((Object)componentType));
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JFlashPlayer.class.getResource(value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlashDecoratorComponentType {
        PLAY_BUTTON,
        PAUSE_BUTTON,
        STOP_BUTTON;

    }

    public class FlashPlayerControlBar
    extends JPanel {
        private JButton playButton;
        private JButton pauseButton;
        private JButton stopButton;
        private WebBrowserAdapter webBrowserListener;

        FlashPlayerControlBar() {
            super(new FlowLayout(1, 4, 2));
            this.playButton = new JButton();
            DefaultFlashPlayerDecorator.this.configureComponent(this.playButton, FlashDecoratorComponentType.PLAY_BUTTON);
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultFlashPlayerDecorator.this.flashPlayer.play();
                }
            });
            this.pauseButton = new JButton();
            DefaultFlashPlayerDecorator.this.configureComponent(this.pauseButton, FlashDecoratorComponentType.PAUSE_BUTTON);
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultFlashPlayerDecorator.this.flashPlayer.pause();
                }
            });
            this.stopButton = new JButton();
            DefaultFlashPlayerDecorator.this.configureComponent(this.stopButton, FlashDecoratorComponentType.STOP_BUTTON);
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultFlashPlayerDecorator.this.flashPlayer.stop();
                }
            });
            this.adjustButtonState();
            this.webBrowserListener = new WebBrowserAdapter(){

                public void locationChanged(WebBrowserNavigationEvent e) {
                    FlashPlayerControlBar.this.adjustButtonState();
                }
            };
            DefaultFlashPlayerDecorator.this.flashPlayer.getWebBrowser().addWebBrowserListener(this.webBrowserListener);
            DefaultFlashPlayerDecorator.this.addControlBarComponents(this, this);
        }

        void disconnect() {
            DefaultFlashPlayerDecorator.this.flashPlayer.getWebBrowser().removeWebBrowserListener(this.webBrowserListener);
        }

        void adjustButtonState() {
            String resourceLocation = DefaultFlashPlayerDecorator.this.flashPlayer.getWebBrowser().getResourceLocation();
            boolean isEnabled = resourceLocation != null && resourceLocation.startsWith(WebServer.getDefaultWebServer().getURLPrefix());
            this.playButton.setEnabled(isEnabled);
            this.pauseButton.setEnabled(isEnabled);
            this.stopButton.setEnabled(isEnabled);
        }

        public JButton getPlayButton() {
            return this.playButton;
        }

        public JButton getPauseButton() {
            return this.pauseButton;
        }

        public JButton getStopButton() {
            return this.stopButton;
        }
    }
}

