/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.ArrayDescriptor;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArrayDataResultSet;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.StringUtil;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class DmdbArray
extends TypeData
implements Array {
    public ArrayDescriptor m_arrDesc;
    public TypeData[] m_arrData;
    public Object m_objArray;
    public int m_itemCount;
    public int m_itemSize;
    public int m_objCount = 0;
    public int m_strCount = 0;
    public int[] m_objStrOffs = null;

    private void initData() {
        this.m_itemCount = 0;
        this.m_itemSize = 0;
        this.m_objCount = 0;
        this.m_strCount = 0;
        this.m_objStrOffs = null;
        this.m_dumyData = null;
        this.m_offset = 0;
        this.m_objArray = null;
    }

    public DmdbArray(TypeData[] atData, TypeDescriptor desc) {
        super(null, null);
        this.m_arrDesc = new ArrayDescriptor(desc);
        this.m_arrData = atData;
    }

    public DmdbArray(ArrayDescriptor arrDesc, DmdbConnection conn, Object[] objArr) throws SQLException {
        super(null, null);
        if (arrDesc == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
            return;
        }
        conn.checkClosed();
        this.initData();
        this.m_arrDesc = arrDesc;
        if (objArr == null) {
            this.m_arrData = new TypeData[0];
        } else {
            if (arrDesc.getMDesc() == null || arrDesc.getMDesc().getDType() == 122 && objArr.length > arrDesc.getMDesc().getStaticArrayLength()) {
                DBError.ECJDBC_INVALID_ARRAY_LEN.throwz(new Object[0]);
            }
            this.m_arrData = TypeData.toArray(objArr, this.m_arrDesc.getMDesc());
        }
        this.m_itemCount = this.m_arrData.length;
    }

    private void checkIndex(long index) throws SQLException {
        if (index < 1L || index > (long)this.m_arrData.length) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
    }

    private void checkIndexAndCount(long index, int count) throws SQLException {
        this.checkIndex(index);
        if (count <= 0 || index - 1L + (long)count > (long)this.m_arrData.length) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.m_arrDesc.m_typeDesc.getFulName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return DmdbType.d2jType(this.m_arrDesc.getItemDesc().column, this.m_arrDesc.getItemDesc().m_conn);
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.m_arrData == null || this.m_arrData.length <= 0) {
            return null;
        }
        return this.toJavaArray(this, this.m_arrData.length, this.m_arrDesc.getItemDesc().getDType());
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return this.toJavaArray(this, index, count, this.m_arrDesc.getItemDesc().getDType());
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public int[] getIntArray() throws SQLException {
        return (int[])this.toNumericArray(this, 1L, this.m_itemCount, 2);
    }

    public int[] getIntArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (int[])this.toNumericArray(this, index, count, 2);
    }

    public short[] getShortArray() throws SQLException {
        return (short[])this.toNumericArray(this, 1L, this.m_itemCount, 1);
    }

    public short[] getShortArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (short[])this.toNumericArray(this, index, count, 1);
    }

    public long[] getLongArray() throws SQLException {
        return (long[])this.toNumericArray(this, 1L, this.m_itemCount, 3);
    }

    public long[] getLongArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (long[])this.toNumericArray(this, index, count, 3);
    }

    public float[] getFloatArray() throws SQLException {
        return (float[])this.toNumericArray(this, 1L, this.m_itemCount, 4);
    }

    public float[] getFloatArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (float[])this.toNumericArray(this, index, count, 4);
    }

    public double[] getDoubleArray() throws SQLException {
        return (double[])this.toNumericArray(this, 1L, this.m_itemCount, 5);
    }

    public double[] getDoubleArray(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return (double[])this.toNumericArray(this, index, count, 5);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new DmdbArrayDataResultSet(this);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.checkIndexAndCount(index, count);
        return new DmdbArrayDataResultSet(this, index, count);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void free() throws SQLException {
        this.m_arrData = null;
        this.m_arrDesc = null;
        this.initData();
    }

    public TypeData getData(long index, int col, Map<String, Class<?>> map) throws SQLException {
        this.checkIndex(index);
        TypeData oneRow = this.m_arrData[(int)(index - 1L)];
        if (oneRow.m_dumyData instanceof DmdbStruct) {
            return ((DmdbStruct)oneRow.m_dumyData).getAttrValue(col);
        }
        return oneRow;
    }

    public Column getDataDesc(long index, int col) throws SQLException {
        this.checkIndex(index);
        Column commDesc = new Column();
        TypeDescriptor dataDesc = this.m_arrDesc.getItemDesc();
        if (dataDesc.getDType() == 121 || dataDesc.getDType() == 119) {
            TypeDescriptor[] attis = dataDesc.m_fieldsObj;
            if (col < 1 || col > attis.length) {
                DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
            }
            commDesc.typeDescriptor = dataDesc = attis[col - 1];
        }
        commDesc.type = dataDesc.getDType();
        commDesc.prec = dataDesc.getPrec();
        commDesc.scale = dataDesc.getScale();
        return commDesc;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        try {
            str.append(this.getBaseTypeName()).append("(");
            int i2 = 0;
            while (i2 < this.m_arrData.length) {
                Object obj = this.m_arrData[i2].m_dumyData;
                if (obj instanceof byte[]) {
                    obj = "0x" + StringUtil.bytesToHexString((byte[])obj);
                }
                if (i2 != 0) {
                    str.append(", ");
                }
                str.append(obj);
                ++i2;
            }
            str.append(")");
        }
        catch (Exception exception) {}
        return str.toString();
    }
}

