/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.StructDescriptor;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.desc.convert.DB2J;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class DmdbStruct
extends TypeData
implements Struct {
    public StructDescriptor m_strctDesc;
    public TypeData[] m_attribs;
    public int m_objCount;
    public int m_strCount;

    public DmdbStruct(TypeData[] atData, TypeDescriptor desc) {
        super(null, null);
        this.m_strctDesc = new StructDescriptor(desc);
        this.m_attribs = atData;
    }

    public TypeData[] getAttribsTypeData() {
        return this.m_attribs;
    }

    public DmdbStruct(StructDescriptor desc, DmdbConnection conn, Object[] objArr) throws SQLException {
        super(null, null);
        if (desc == null) {
            DBError.ECJDBC_INVALID_PARAMETER_VALUE.throwz(new Object[0]);
        }
        conn.checkClosed();
        this.m_strctDesc = desc;
        if (objArr == null) {
            this.m_attribs = new TypeData[desc.getSize()];
        } else {
            if (desc.getSize() != objArr.length && desc.getObjId() != 4) {
                DBError.ECJDBC_STRUCT_MEM_NOT_MATCH.throwz(new Object[0]);
            }
            this.m_attribs = TypeData.toStruct(objArr, this.m_strctDesc.m_typeDesc);
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.m_strctDesc.m_typeDesc.getFulName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.toJavaArray(this);
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        Object[] objs = this.getAttributes();
        if (map == null || map.size() == 0) {
            return objs;
        }
        int i2 = 0;
        while (i2 < objs.length) {
            if (objs[i2] instanceof Struct) {
                Struct struct = (Struct)objs[i2];
                objs[i2] = DB2J.toSQLData(struct, map);
            }
            ++i2;
        }
        return objs;
    }

    private void checkCol(int col) throws SQLException {
        if (col < 1 || col > this.m_attribs.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
    }

    TypeData getAttrValue(int col) throws SQLException {
        this.checkCol(col);
        return this.m_attribs[col - 1];
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        try {
            str.append(this.getSQLTypeName()).append("(");
            int i2 = 0;
            while (i2 < this.m_attribs.length) {
                Object obj = this.m_attribs[i2].m_dumyData;
                if (obj instanceof byte[]) {
                    obj = "0x" + StringUtil.bytesToHexString((byte[])obj);
                }
                if (i2 != 0) {
                    str.append(", ");
                }
                str.append(obj);
                ++i2;
            }
            str.append(")");
        }
        catch (Exception exception) {}
        return str.toString();
    }
}

