/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class DmdbType {
    public static final int CHAR = 0;
    public static final int VARCHAR2 = 1;
    public static final int VARCHAR = 2;
    public static final int BIT = 3;
    public static final int TINYINT = 5;
    public static final int SMALLINT = 6;
    public static final int INT = 7;
    public static final int BIGINT = 8;
    public static final int DECIMAL = 9;
    public static final int REAL = 10;
    public static final int DOUBLE = 11;
    public static final int BLOB = 12;
    public static final int BOOLEAN = 13;
    public static final int DATE = 14;
    public static final int TIME = 15;
    public static final int DATETIME = 16;
    public static final int BINARY = 17;
    public static final int VARBINARY = 18;
    public static final int CLOB = 19;
    public static final int INTERVAL_YM = 20;
    public static final int INTERVAL_DT = 21;
    public static final int TIME_TZ = 22;
    public static final int DATETIME_TZ = 23;
    public static final int DATETIME2 = 26;
    public static final int DATETIME2_TZ = 27;
    public static final int ROWID = 28;
    public static final int NULL = 29;
    public static final int ANY = 31;
    public static final int STAR_ALL = 32;
    public static final int STAR = 33;
    public static final int RECORD = 40;
    public static final int TYPE = 41;
    public static final int TYPE_REF = 42;
    public static final int UNKNOWN = 54;
    public static final int ARRAY = 117;
    public static final int CLASS = 119;
    public static final int CURSOR = 120;
    public static final int PLTYPE_RECORD = 121;
    public static final int SARRAY = 122;
    public static final int CURSOR_ORACLE = -10;
    public static final int BIT_PREC = 1;
    public static final int TINYINT_PREC = 1;
    public static final int SMALLINT_PREC = 2;
    public static final int INT_PREC = 4;
    public static final int BIGINT_PREC = 8;
    public static final int REAL_PREC = 4;
    public static final int DOUBLE_PREC = 8;
    public static final int DATE_PREC = 3;
    public static final int TIME_PREC = 5;
    public static final int DATETIME_PREC = 8;
    public static final int DATETIME2_PREC = 9;
    public static final int TIME_TZ_PREC = 7;
    public static final int DATETIME_TZ_PREC = 10;
    public static final int DATETIME2_TZ_PREC = 11;
    public static final int INTERVAL_YM_PREC = 12;
    public static final int INTERVAL_DT_PREC = 24;
    public static final int VARCHAR_PREC = Short.MAX_VALUE;
    public static final int VARBINARY_PREC = Short.MAX_VALUE;
    public static final int BLOB_PREC = Integer.MAX_VALUE;
    public static final int CLOB_PREC = Integer.MAX_VALUE;
    public static final int CLASS_PREC = 32768;
    public static final int CURSOR_PREC = 32768;
    public static final int NULL_PREC = 0;
    public static final int BFILE_PREC = 512;
    public static final int CURRENCY_PREC = 19;
    public static final int ROWID_PREC = 12;
    public static final int BFILE_SCALE = 6;
    public static final int COMPLEX_SCALE = 5;
    public static final int CURRENCY_SCALE = 4;
    public static final int LOCAL_DATETIME_SCALE_MASK = 4096;
    public static final int ORACLE_FLOAT_SCALE_MASK = 129;
    public static final int ORACLE_DATE_SCALE_MASK = 8192;

    public static boolean isInteger(int type) {
        return type == 5 || type == 6 || type == 7 || type == 8;
    }

    public static boolean isNumeric(int type) {
        return type == 5 || type == 6 || type == 7 || type == 8 || type == 10 || type == 11 || type == 9;
    }

    public static boolean isCharacter(int type) {
        return type == 0 || type == 2 || type == 1 || type == 19;
    }

    public static boolean isBinary(int type) {
        return type == 17 || type == 18 || type == 12;
    }

    public static boolean isComplexType(int type, int scale) {
        return type == 12 && scale == 5 || type == 117 || type == 122 || type == 119 || type == 121;
    }

    public static int d2jType(Column column, IDmdbConnection connection) {
        int jtype = 1111;
        if (connection != null && connection.compatibleOracle() && DmdbType.isNumeric(column.type)) {
            return 2;
        }
        block0 : switch (column.type) {
            case 13: {
                jtype = 16;
                break;
            }
            case 3: {
                jtype = StringUtil.equalsIgnoreCase(column.typeName, "BOOLEAN") ? 16 : -7;
                break;
            }
            case 5: {
                jtype = -6;
                break;
            }
            case 6: {
                jtype = 5;
                break;
            }
            case 7: {
                jtype = 4;
                break;
            }
            case 8: {
                jtype = -5;
                break;
            }
            case 9: {
                if (StringUtil.equalsIgnoreCase(column.typeName, "NUMERIC") || StringUtil.equalsIgnoreCase(column.typeName, "NUMBER")) {
                    jtype = 2;
                    break;
                }
                jtype = 3;
                break;
            }
            case 10: {
                jtype = 7;
                break;
            }
            case 11: {
                jtype = StringUtil.equalsIgnoreCase(column.typeName, "FLOAT") ? 6 : 8;
                break;
            }
            case 14: {
                jtype = 91;
                break;
            }
            case 15: {
                jtype = 92;
                break;
            }
            case 16: 
            case 26: {
                jtype = 93;
                break;
            }
            case 17: {
                jtype = -2;
                break;
            }
            case 18: {
                jtype = -3;
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale) && column.typeDescriptor != null) {
                    switch (column.typeDescriptor.column.type) {
                        case 117: 
                        case 122: {
                            jtype = 2003;
                            break block0;
                        }
                        case 119: 
                        case 121: {
                            jtype = 2002;
                            break block0;
                        }
                    }
                    jtype = 2004;
                    break;
                }
                jtype = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY") ? -4 : 2004;
                break;
            }
            case 0: 
            case 1: {
                jtype = 1;
                break;
            }
            case 2: {
                jtype = 12;
                break;
            }
            case 19: {
                if (connection != null && connection.getClobAsString()) {
                    jtype = 12;
                    break;
                }
                jtype = StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR") ? -1 : 2005;
                break;
            }
            case 117: 
            case 122: {
                jtype = 2003;
                break;
            }
            case 119: 
            case 121: {
                jtype = 2002;
                break;
            }
            case 54: {
                jtype = 12;
                break;
            }
            case 28: {
                jtype = -8;
                break;
            }
            default: {
                jtype = 1111;
            }
        }
        return jtype;
    }

    public static int j2dType(int jtype) {
        int dtype = 54;
        switch (jtype) {
            case -10: 
            case 120: {
                dtype = 120;
                break;
            }
            case 16: {
                dtype = 3;
                break;
            }
            case -7: {
                dtype = 3;
                break;
            }
            case -6: {
                dtype = 5;
                break;
            }
            case 5: {
                dtype = 6;
                break;
            }
            case 4: {
                dtype = 7;
                break;
            }
            case -5: {
                dtype = 8;
                break;
            }
            case 6: 
            case 7: {
                dtype = 10;
                break;
            }
            case 8: {
                dtype = 11;
                break;
            }
            case 2: 
            case 3: {
                dtype = 9;
                break;
            }
            case -2: {
                dtype = 17;
                break;
            }
            case -3: {
                dtype = 18;
                break;
            }
            case -4: 
            case 2004: {
                dtype = 12;
                break;
            }
            case -15: 
            case 1: {
                dtype = 0;
                break;
            }
            case -9: 
            case 12: {
                dtype = 2;
                break;
            }
            case -1: 
            case 2005: 
            case 2011: {
                dtype = 19;
                break;
            }
            case 91: {
                dtype = 14;
                break;
            }
            case 92: {
                dtype = 15;
                break;
            }
            case 93: {
                dtype = 16;
                break;
            }
            case 2003: {
                dtype = 117;
                break;
            }
            case 2000: 
            case 2002: {
                dtype = 119;
                break;
            }
            case 0: {
                dtype = 29;
                break;
            }
            case 2009: {
                dtype = 19;
                break;
            }
            case 2012: {
                dtype = 120;
                break;
            }
            case -8: {
                dtype = 28;
                break;
            }
            default: {
                dtype = 2;
            }
        }
        return dtype;
    }

    public static int d2jPrec(Column column) {
        int jprec = column.prec;
        switch (column.type) {
            case 3: 
            case 13: {
                jprec = 1;
                break;
            }
            case 5: {
                jprec = 3;
                break;
            }
            case 6: {
                jprec = 5;
                break;
            }
            case 7: {
                jprec = 10;
                break;
            }
            case 8: {
                jprec = 19;
                break;
            }
            case 10: {
                jprec = 24;
                break;
            }
            case 11: {
                jprec = 53;
                break;
            }
            case 14: {
                jprec = 10;
                break;
            }
            case 15: {
                jprec = column.scale != 0 ? 9 + column.scale : 8;
                break;
            }
            case 16: 
            case 26: {
                jprec = column.scale != 0 ? 20 + column.scale : 19;
                break;
            }
            case 20: 
            case 21: {
                jprec = column.scale >> 4 & 0xF;
                break;
            }
            case 9: {
                jprec = column.prec;
                break;
            }
            default: {
                jprec = column.prec;
            }
        }
        return jprec;
    }

    public static String getClassName(int jtype, int dtype) {
        String className = null;
        block0 : switch (jtype) {
            case -7: 
            case 16: {
                className = Boolean.class.getName();
                break;
            }
            case -6: {
                className = Byte.class.getName();
                break;
            }
            case 5: {
                className = Short.class.getName();
                break;
            }
            case 4: {
                className = Integer.class.getName();
                break;
            }
            case -5: {
                className = Long.class.getName();
                break;
            }
            case 2: 
            case 3: {
                className = BigDecimal.class.getName();
                break;
            }
            case 7: {
                className = Float.class.getName();
                break;
            }
            case 6: 
            case 8: {
                className = Double.class.getName();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                className = String.class.getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                className = byte[].class.getName();
                break;
            }
            case 91: {
                className = Date.class.getName();
                break;
            }
            case 92: {
                className = Time.class.getName();
                break;
            }
            case 93: {
                className = Timestamp.class.getName();
                break;
            }
            case 2004: {
                className = Blob.class.getName();
                break;
            }
            case 2005: {
                className = Clob.class.getName();
                break;
            }
            case 2003: {
                className = Array.class.getName();
                break;
            }
            case 2002: {
                className = Struct.class.getName();
                break;
            }
            case -8: {
                className = RowId.class.getName();
                break;
            }
            default: {
                switch (dtype) {
                    case 22: {
                        className = DmdbTimestamp.class.getName();
                        break block0;
                    }
                    case 21: {
                        className = DmdbIntervalDT.class.getName();
                        break block0;
                    }
                    case 20: {
                        className = DmdbIntervalYM.class.getName();
                        break block0;
                    }
                    case 23: {
                        className = DmdbTimestamp.class.getName();
                        break block0;
                    }
                }
                className = Object.class.getName();
            }
        }
        return className;
    }

    public static boolean canCastToDecimal(Object x2) {
        return x2 != null && (x2 instanceof Boolean || x2 instanceof Byte || x2 instanceof Short || x2 instanceof Integer || x2 instanceof Long || x2 instanceof Float || x2 instanceof Double || x2 instanceof BigDecimal || x2 instanceof String);
    }

    public static boolean emptyStringToNull(int type) {
        switch (type) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static final int j2dPrec(int dtype, int jprec) {
        int dprec = jprec;
        switch (dtype) {
            case 3: 
            case 13: {
                dprec = 1;
                break;
            }
            case 5: {
                dprec = 1;
                break;
            }
            case 6: {
                dprec = 2;
                break;
            }
            case 7: {
                dprec = 4;
                break;
            }
            case 8: {
                dprec = 8;
                break;
            }
            case 1: 
            case 2: {
                dprec = Short.MAX_VALUE;
                break;
            }
            case 19: {
                dprec = Integer.MAX_VALUE;
                break;
            }
            case 18: {
                dprec = Short.MAX_VALUE;
                break;
            }
            case 12: {
                dprec = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                dprec = 3;
                break;
            }
            case 15: {
                dprec = 5;
                break;
            }
            case 16: {
                dprec = 8;
                break;
            }
            case 26: {
                dprec = 9;
                break;
            }
            case 23: {
                dprec = 10;
                break;
            }
            case 27: {
                dprec = 11;
                break;
            }
            case 22: {
                dprec = 7;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 28: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                dprec = 0;
                break;
            }
        }
        return dprec;
    }

    public static void jclass2dtype(Column column, Object obj) {
        if (obj == null && !DmdbType.isCharacter(column.type)) {
            column.type = 2;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (obj instanceof Integer) {
            column.type = 7;
            column.prec = 4;
            column.scale = 0;
            return;
        }
        if (obj instanceof Long) {
            column.type = 8;
            column.prec = 8;
            column.scale = 0;
            return;
        }
        if (obj instanceof Short) {
            column.type = 6;
            column.prec = 2;
            column.scale = 0;
            return;
        }
        if (obj instanceof Float) {
            column.type = 10;
            column.prec = 4;
            column.scale = 0;
            return;
        }
        if (obj instanceof Double) {
            column.type = 11;
            column.prec = 8;
            column.scale = 0;
            return;
        }
        if ((obj instanceof BigInteger || obj instanceof BigDecimal || obj instanceof Number) && !DmdbType.isNumeric(column.type)) {
            column.type = 9;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (obj instanceof Byte) {
            column.type = 5;
            column.prec = 1;
            column.scale = 0;
            return;
        }
        if (obj instanceof byte[] && !DmdbType.isBinary(column.type)) {
            column.type = 18;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if ((obj instanceof InputStream || obj instanceof OutputStream || obj instanceof Blob) && !DmdbType.isBinary(column.type)) {
            column.type = 12;
            column.prec = Integer.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (obj instanceof Character && !DmdbType.isCharacter(column.type)) {
            column.type = 0;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if ((obj instanceof char[] || obj instanceof String || obj instanceof URL || obj instanceof DmdbBFile) && !DmdbType.isCharacter(column.type)) {
            column.type = 2;
            column.prec = Short.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if ((obj instanceof Reader || obj instanceof Writer || obj instanceof Clob || obj instanceof SQLXML) && !DmdbType.isCharacter(column.type)) {
            column.type = 19;
            column.prec = Integer.MAX_VALUE;
            column.scale = 0;
            return;
        }
        if (obj instanceof Date) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (obj instanceof Time) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (obj instanceof Timestamp) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (obj instanceof java.util.Date) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (obj instanceof LocalDate) {
            column.type = 14;
            column.prec = 3;
            column.scale = 0;
            return;
        }
        if (obj instanceof LocalDateTime) {
            column.type = 16;
            column.prec = 8;
            return;
        }
        if (obj instanceof LocalTime) {
            column.type = 15;
            column.prec = 5;
            return;
        }
        if (obj instanceof OffsetDateTime) {
            column.type = 23;
            column.prec = 10;
            return;
        }
        if (obj instanceof OffsetTime) {
            column.type = 22;
            column.prec = 7;
            return;
        }
        if (obj instanceof ZonedDateTime) {
            column.type = 23;
            column.prec = 10;
            return;
        }
        if (obj instanceof ZoneOffset) {
            column.type = 22;
            column.prec = 7;
            return;
        }
        if (obj instanceof DmdbIntervalDT) {
            column.type = 21;
            column.prec = 24;
            column.scale = 0;
            return;
        }
        if (obj instanceof DmdbIntervalYM) {
            column.type = 20;
            column.prec = 12;
            column.scale = 0;
            return;
        }
        if (obj instanceof Boolean) {
            column.type = 3;
            column.prec = 1;
            column.scale = 0;
            return;
        }
        if (obj instanceof Array) {
            column.type = 117;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (obj instanceof Struct || obj instanceof SQLData || obj instanceof SQLInput || obj instanceof SQLOutput || obj instanceof Ref) {
            column.type = 119;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (obj instanceof ResultSet) {
            column.type = 120;
            column.prec = 0;
            column.scale = 0;
            return;
        }
        if (obj instanceof RowId) {
            column.type = 28;
            column.prec = 0;
            column.scale = 0;
            return;
        }
    }

    public static void j2dType(Column column, int jtype, int jprec, int jscale) {
        int dtype = 54;
        int dprec = jprec;
        int dscale = jscale;
        switch (jtype) {
            case -7: 
            case 16: {
                dtype = 3;
                dprec = 1;
                break;
            }
            case -6: {
                dtype = 5;
                dprec = 1;
                break;
            }
            case 5: {
                dtype = 6;
                dprec = 2;
                break;
            }
            case 4: {
                dtype = 7;
                dprec = 4;
                break;
            }
            case -5: {
                dtype = 8;
                dprec = 8;
                break;
            }
            case 6: 
            case 7: {
                dtype = 10;
                dprec = jprec > 0 ? jprec : 0;
                dscale = 0;
                break;
            }
            case 8: {
                dtype = 11;
                dprec = 0;
                dscale = 0;
                break;
            }
            case 2: 
            case 3: {
                dtype = 9;
                dscale = jscale > 0 ? jscale : 0;
                dprec = jprec > 0 && dscale > 0 ? jprec : 0;
                break;
            }
            case -2: {
                dtype = 17;
                dprec = jprec > 0 ? jprec : 0;
                dscale = 0;
                break;
            }
            case -3: {
                dtype = 18;
                dprec = jprec > 0 ? jprec : 0;
                break;
            }
            case -4: 
            case 2004: {
                dtype = 12;
                break;
            }
            case -15: 
            case 1: {
                dtype = 0;
                dprec = jprec > 0 ? jprec : 0;
                break;
            }
            case -9: 
            case 12: {
                dtype = 2;
                dprec = jprec > 0 ? jprec : 0;
                break;
            }
            case -1: 
            case 2005: 
            case 2009: 
            case 2011: {
                dtype = 19;
                break;
            }
            case 91: {
                dtype = 14;
                dprec = 3;
                break;
            }
            case 92: {
                dtype = 15;
                dprec = 5;
                dscale = jscale > 0 ? jscale : 0;
                break;
            }
            case 93: {
                dtype = 16;
                dprec = 8;
                dscale = jscale > 0 ? jscale : 0;
                break;
            }
            case 2003: {
                dtype = 117;
                break;
            }
            case 2000: 
            case 2002: {
                dtype = 119;
                dprec = 32768;
                break;
            }
            case -8: {
                dtype = 28;
                dprec = 0;
                dscale = 0;
                break;
            }
            default: {
                dtype = 2;
                dprec = Short.MAX_VALUE;
            }
        }
        column.type = dtype;
        column.prec = dprec;
        column.scale = dscale;
    }

    public static String getDTypeName(Column column) {
        String name = column.typeName;
        if (StringUtil.isEmpty(name)) {
            block0 : switch (column.type) {
                case 3: 
                case 13: {
                    name = "bit";
                    break;
                }
                case 5: {
                    name = "tinyint";
                    break;
                }
                case 6: {
                    name = "smallint";
                    break;
                }
                case 7: {
                    name = "integer";
                    break;
                }
                case 8: {
                    name = "bigint";
                    break;
                }
                case 10: {
                    name = "real";
                    break;
                }
                case 11: {
                    name = "double";
                    break;
                }
                case 9: {
                    name = "decimal";
                    break;
                }
                case 0: {
                    name = "char";
                    break;
                }
                case 1: 
                case 2: {
                    if (column.mask == 3) {
                        name = "bfile";
                        break;
                    }
                    name = "varchar";
                    break;
                }
                case 19: {
                    name = "clob";
                    break;
                }
                case 17: {
                    name = "binary";
                    break;
                }
                case 18: {
                    name = "varbinary";
                    break;
                }
                case 12: {
                    name = "blob";
                    break;
                }
                case 14: {
                    name = "date";
                    break;
                }
                case 15: {
                    name = "time";
                    break;
                }
                case 16: 
                case 26: {
                    if (column.mask == 1) {
                        name = "date";
                        break;
                    }
                    if (column.mask == 4) {
                        name = "timestamp with local time zone";
                        break;
                    }
                    name = "timestamp";
                    break;
                }
                case 22: {
                    name = "time with time zone";
                    break;
                }
                case 23: 
                case 27: {
                    name = "timestamp with time zone";
                    break;
                }
                case 21: {
                    int destType = (column.scale & 0xFF00) >> 8;
                    switch (destType) {
                        case 3: {
                            name = "interval day";
                            break block0;
                        }
                        case 4: {
                            name = "interval day to hour";
                            break block0;
                        }
                        case 5: {
                            name = "interval day to minute";
                            break block0;
                        }
                        case 6: {
                            name = "interval day to second";
                            break block0;
                        }
                        case 7: {
                            name = "interval hour";
                            break block0;
                        }
                        case 8: {
                            name = "interval hour to minute";
                            break block0;
                        }
                        case 9: {
                            name = "interval hour to second";
                            break block0;
                        }
                        case 10: {
                            name = "interval minute";
                            break block0;
                        }
                        case 11: {
                            name = "interval minute to second";
                            break block0;
                        }
                        case 12: {
                            name = "interval second";
                            break block0;
                        }
                    }
                    break;
                }
                case 20: {
                    int destType = (column.scale & 0xFF00) >> 8;
                    switch (destType) {
                        case 0: {
                            name = "interval year";
                            break block0;
                        }
                        case 1: {
                            name = "interval year to month";
                            break block0;
                        }
                        case 2: {
                            name = "interval month";
                            break block0;
                        }
                    }
                    break;
                }
                case 117: {
                    name = "array";
                    break;
                }
                case 119: {
                    name = "class";
                    break;
                }
                case 120: {
                    name = "cursor";
                    break;
                }
                case 40: {
                    name = "record";
                    break;
                }
                case 122: {
                    name = "sarray";
                    break;
                }
                case 41: 
                case 42: {
                    name = "type";
                    break;
                }
                case 121: {
                    name = "record";
                    break;
                }
                case 28: {
                    name = "rowid";
                    break;
                }
                default: {
                    name = "varchar";
                }
            }
        }
        return name.toUpperCase();
    }
}

