/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.Parameter;
import dm.jdbc.desc.convert.J2DB;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteUtil;
import java.sql.SQLException;

public class HashCode {
    private static final long HC_MASK = 0xFFFFFFFFL;
    private static final int TZ_INVALID_VALUE = 1000;
    private static final int TZ_DEFAULT_VALUE = 480;
    private static int[] global_days_befor_month;

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        global_days_befor_month = nArray;
    }

    public static long hc_calc_fold_value(long[] folds) throws SQLException {
        int fold = 0;
        int i2 = 0;
        while (i2 < folds.length) {
            fold += (int)folds[i2];
            ++i2;
        }
        return (long)fold & 0xFFFFFFFFL;
    }

    public static long hc_get_fold_fun(Parameter paramDesc, Object data, DmdbConnection conn) throws SQLException {
        int destType = paramDesc.type;
        boolean caseSensitive = conn.caseSensitive;
        byte[] value = J2DB.fromObject(data, paramDesc, conn);
        switch (destType) {
            case 3: 
            case 5: 
            case 6: 
            case 29: {
                return HashCode.hc_get_l4_fold(value);
            }
            case 7: 
            case 10: {
                return HashCode.hc_get_int_fold(value);
            }
            case 8: {
                return HashCode.hc_get_int64_fold(value);
            }
            case 14: 
            case 16: 
            case 26: {
                return HashCode.hc_get_datetime_fold(value);
            }
            case 23: 
            case 27: {
                int[] dt = DmdbTimestamp.valueOf((byte[])value, (Column)paramDesc, (IDmdbConnection)conn).dt;
                return HashCode.hc_get_datetime_with_tz_fold(dt);
            }
            case 20: {
                return HashCode.hc_get_ivym_fold(new DmdbIntervalYM(value));
            }
            case 21: {
                return HashCode.hc_get_ivdt_fold(new DmdbIntervalDT(value));
            }
            case 11: {
                return HashCode.hc_get_double_fold(value);
            }
            case 9: {
                return HashCode.hc_get_dec_fold(value);
            }
            case 15: {
                return HashCode.hc_get_time_fold(value);
            }
            case 22: {
                int[] dt = DmdbTimestamp.valueOf((byte[])value, (Column)paramDesc, (IDmdbConnection)conn).dt;
                return HashCode.hc_get_time_with_tz_fold(dt);
            }
            case 0: 
            case 1: 
            case 2: 
            case 12: 
            case 19: {
                if (caseSensitive) {
                    return HashCode.hc_get_varlen_cs_fold_fnv1a(value);
                }
                return HashCode.hc_get_varlen_ncs_fold_fnv1a(value);
            }
            case 17: 
            case 18: {
                if (!conn.compatibleMysql()) {
                    return HashCode.hc_get_varlen_cs_fold_fnv1a(value);
                }
                return HashCode.hc_get_binary_fold_in_sqlserver_mode(value);
            }
        }
        return 0L;
    }

    private static long hc_get_l4_fold(byte[] value) throws SQLException {
        if (value == null) {
            return 0L;
        }
        return ByteUtil.toLong(value);
    }

    private static long hc_get_int_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return ByteUtil.getUB4(value, 0);
    }

    private static long hc_get_int64_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return ByteUtil.getUB4(value, 0);
    }

    private static long hc_get_double_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return ByteUtil.getUB4(value, 0) + ByteUtil.getUB4(value, 4);
    }

    private static long hc_get_time_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        return ByteUtil.getUB4(value, 4);
    }

    private static long hc_get_datetime_fold(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int retValue = value[6] + value[3] | value[5] << 6 | value[4] << 12 | value[3] << 17 | value[2] << 22 | (value[0] & 7) << 26 | (value[7] & 7) << 29;
        return (long)retValue & 0xFFFFFFFFL;
    }

    private static long hc_get_ivym_fold(DmdbIntervalYM value) {
        if (value == null) {
            return 0L;
        }
        return value.getYear() << 4 | value.getMonth();
    }

    private static long hc_get_ivdt_fold(DmdbIntervalDT value) {
        if (value == null) {
            return 0L;
        }
        return value.getDay() << 18 | value.getHour() << 12 | value.getMinute() << 6 | value.getSecond();
    }

    private static long hc_get_varlen_cs_fold_fnv1a(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen == 1) {
            return ByteUtil.getByte(value, pdata);
        }
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while (value[pdata] == 32 && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return HashCode.hc_get_varlen_fold_cs_low_fnv1a(value, alen);
    }

    private static long hc_get_varlen_fold_cs_low_fnv1a(byte[] value, int length) {
        if (length == 2) {
            return ByteUtil.getUB2(value, 0);
        }
        int ret_value = 0;
        int i2 = 0;
        while (i2 < length) {
            ret_value ^= value[i2];
            ret_value += (ret_value << 1) + (ret_value << 4) + (ret_value << 7) + (ret_value << 8) + (ret_value << 24);
            ++i2;
        }
        return (long)ret_value & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_ncs_fold_fnv1a(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while (value[pdata] == 32 && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return HashCode.hc_get_varlen_fold_ncs_low_fnv1a(value, alen);
    }

    private static long hc_get_varlen_fold_ncs_low_fnv1a(byte[] value, int length) {
        int ret_value = 0;
        if (length == 1) {
            byte key_tmp = ByteUtil.getByte(value, 0);
            if (key_tmp > 96) {
                return key_tmp - 32;
            }
            return key_tmp;
        }
        if (length == 2) {
            byte key_tmp2;
            byte key_tmp = value[0];
            if (key_tmp > 96) {
                key_tmp = (byte)(key_tmp - 32);
            }
            if ((key_tmp2 = value[1]) > 96) {
                key_tmp2 = (byte)(key_tmp2 - 32);
            }
            return (key_tmp2 << 8) + key_tmp;
        }
        int i2 = 0;
        while (i2 < length) {
            ret_value = value[i2] > 96 ? (ret_value ^= value[i2] - 32) : (ret_value ^= value[i2]);
            ret_value += (ret_value << 1) + (ret_value << 4) + (ret_value << 7) + (ret_value << 8) + (ret_value << 24);
            ++i2;
        }
        return (long)ret_value & 0xFFFFFFFFL;
    }

    private static long hc_get_datetime_with_tz_fold(int[] dt) {
        long year1 = dt[0];
        int month1 = dt[1];
        long day1 = dt[2];
        long hour1 = dt[3];
        long min1 = dt[4];
        long sec1 = dt[5];
        long msec1 = dt[6];
        long tz1 = dt[7];
        if (tz1 == 1000L) {
            tz1 = 480L;
        }
        day1 = HashCode.dmtime_calc_n_days_from_zero(year1, month1, day1);
        long hour_to_min1 = hour1 * 60L + min1 - tz1;
        long tmp = hour_to_min1 / 1440L;
        day1 += tmp;
        if ((hour_to_min1 -= tmp * 24L * 60L) < 0L) {
            --day1;
            hour_to_min1 += 1440L;
        }
        return day1 + hour_to_min1 + msec1 + sec1;
    }

    private static long hc_get_time_with_tz_fold(int[] dt) {
        int hour_to_min1;
        int hour1 = dt[3];
        int min1 = dt[4];
        int sec1 = dt[5];
        int msec1 = dt[6];
        int tz1 = dt[7];
        if (tz1 == 1000) {
            tz1 = 480;
        }
        if ((hour_to_min1 = hour1 * 60 + min1 - tz1) < 0) {
            hour_to_min1 += 1440;
        }
        return hour_to_min1 + msec1 + sec1;
    }

    private static long dmtime_calc_n_days_from_zero(long year, int month, long day) {
        if (month < 1 || month > 12 || day < 1L || day > 31L) {
            return 0L;
        }
        if (year < 0L) {
            long ndays = year * 365L + (long)global_days_befor_month[month - 1] + day;
            if (month > 2) {
                ++year;
            }
            long leap_days = year / 4L;
            if (year == -4712L) {
                ++leap_days;
            }
            return ndays += leap_days;
        }
        long ndays = year * 365L + (long)global_days_befor_month[month - 1] + day;
        if (month <= 2) {
            --year;
        }
        long leap_days = year < 1600L ? year / 4L : 400L + (year - 1600L) / 4L - (year - 1600L) / 100L + (year - 1600L) / 400L;
        if (year >= 0L) {
            ++leap_days;
        }
        return ndays += leap_days;
    }

    private static long hc_get_dec_fold(byte[] value) throws SQLException {
        int pdata = 1;
        int ret = 0;
        int fold = 0;
        int alen = value.length - 1;
        while (alen > 4) {
            fold = (int)((long)fold + ByteUtil.getUB4(value, pdata));
            pdata += 4;
            alen -= 4;
        }
        if (alen > 0) {
            byte[] temp = new byte[4];
            System.arraycopy(value, pdata, temp, 0, alen);
            ret = ByteUtil.getInt(temp, 0);
        }
        return (long)(ret + fold) & 0xFFFFFFFFL;
    }

    private static long hc_get_varlen_fold_cs_low(byte[] value, int length) {
        int nr = 1;
        int nr2 = 4;
        byte key_tmp = 0;
        if (length == 0) {
            return nr;
        }
        if (length == 2) {
            return ByteUtil.getUB2(value, 0);
        }
        if (length > 64) {
            return HashCode.bfd_varlen_low_cs_max(value, length);
        }
        int i2 = 0;
        while (i2 < length) {
            key_tmp = value[i2];
            nr ^= ((nr & 0x3F) + nr2) * key_tmp + (nr << 8);
            nr2 += 3;
            ++i2;
        }
        return (long)nr & 0xFFFFFFFFL;
    }

    private static long bfd_varlen_low_cs_max(byte[] value, int length) {
        int nr = 1;
        int nr2 = 4;
        int left = 0;
        int right = 0;
        int key_tmp = 0;
        int step = length >> 6;
        left = 0 + (length >> 1) - 1;
        right = left + 1;
        int sample_cnt = 32 + length % 64 / step / 2;
        int i2 = 0;
        while (i2 < sample_cnt) {
            key_tmp = left;
            nr ^= ((nr & 0x3F) + nr2) * value[key_tmp] + (nr << 8);
            left -= step;
            key_tmp = right;
            nr ^= ((nr & 0x3F) + (nr2 += 3)) * value[key_tmp] + (nr << 8);
            nr2 += 3;
            right += step;
            ++i2;
        }
        return (long)nr & 0xFFFFFFFFL;
    }

    private static long hc_get_binary_fold_in_sqlserver_mode(byte[] value) {
        if (value == null) {
            return 0L;
        }
        int alen = value.length;
        if (alen == 0) {
            return 0L;
        }
        int pdata = 0;
        if (alen == 1) {
            return ByteUtil.getByte(value, pdata);
        }
        if (alen > 0) {
            pdata = pdata + alen - 1;
            while ((value[pdata] == 32 || value[pdata] == 0) && alen != 0) {
                --pdata;
                --alen;
            }
        }
        return HashCode.hc_get_varlen_fold_cs_low(value, alen);
    }
}

