/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

public class BEByteUtil {
    public static byte[] fromLong(long l2) {
        return new byte[]{(byte)(l2 >> 56), (byte)(l2 >> 48), (byte)(l2 >> 40), (byte)(l2 >> 32), (byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2};
    }

    public static int setUB1(byte[] bytes, int offset, int i2) {
        bytes[offset] = (byte)i2;
        return 1;
    }

    public static int setUB2(byte[] bytes, int offset, int i2) {
        bytes[offset++] = (byte)(i2 >> 8);
        bytes[offset++] = (byte)i2;
        return 2;
    }

    public static int setUB3(byte[] bytes, int offset, int i2) {
        bytes[offset++] = (byte)(i2 >> 16);
        bytes[offset++] = (byte)(i2 >> 8);
        bytes[offset++] = (byte)i2;
        return 3;
    }

    public static int setUB4(byte[] bytes, int offset, long l2) {
        bytes[offset++] = (byte)(l2 >> 24);
        bytes[offset++] = (byte)(l2 >> 16);
        bytes[offset++] = (byte)(l2 >> 8);
        bytes[offset++] = (byte)l2;
        return 4;
    }

    public static int setBytes(byte[] bytes, int offset, byte[] srcBytes) {
        System.arraycopy(srcBytes, 0, bytes, offset, srcBytes.length);
        return srcBytes.length;
    }

    public static int setBytes(byte[] bytes, int offset, byte[] srcBytes, int srcOffset, int len) {
        System.arraycopy(srcBytes, srcOffset, bytes, offset, len);
        return len;
    }

    public static long getLong(byte[] bytes, int offset) {
        long val = (long)(bytes[offset++] & 0xFF) << 56;
        val |= (long)(bytes[offset++] & 0xFF) << 48;
        val |= (long)(bytes[offset++] & 0xFF) << 40;
        val |= (long)(bytes[offset++] & 0xFF) << 32;
        val |= (long)(bytes[offset++] & 0xFF) << 24;
        val |= (long)(bytes[offset++] & 0xFF) << 16;
        val |= (long)(bytes[offset++] & 0xFF) << 8;
        return val |= (long)(bytes[offset++] & 0xFF);
    }

    public static int getUB1(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF;
    }

    public static int getUB2(byte[] bytes, int offset) {
        int i2 = (bytes[offset++] & 0xFF) << 8;
        return i2 |= bytes[offset++] & 0xFF;
    }

    public static int getUB3(byte[] bytes, int offset) {
        int i2 = (bytes[offset++] & 0xFF) << 16;
        i2 |= (bytes[offset++] & 0xFF) << 8;
        return i2 |= bytes[offset++] & 0xFF;
    }

    public static long getUB4(byte[] bytes, int offset) {
        long l2 = (long)(bytes[offset++] & 0xFF) << 24;
        l2 |= (long)(bytes[offset++] & 0xFF) << 16;
        l2 |= (long)(bytes[offset++] & 0xFF) << 8;
        return l2 |= (long)(bytes[offset++] & 0xFF);
    }

    public static byte[] getBytes(byte[] bytes, int offset, int len) {
        byte[] retBytes = new byte[len];
        System.arraycopy(bytes, offset, retBytes, 0, len);
        return retBytes;
    }

    public static int getBytes(byte[] bytes, int offset, byte[] objBytes) {
        return BEByteUtil.getBytes(bytes, offset, objBytes, 0, objBytes.length);
    }

    public static int getBytes(byte[] bytes, int offset, byte[] objBytes, int objOffset, int len) {
        System.arraycopy(bytes, offset, objBytes, objOffset, len);
        return len;
    }

    public static long toLong(byte[] bytes) {
        return BEByteUtil.getLong(bytes, 0);
    }
}

