/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.conf.EP;
import dm.jdbc.desc.convert.J2DB;
import dm.jdbc.desc.convert.ResultSetUpdataData;
import dm.jdbc.desc.enums.ENCODING;
import dm.jdbc.desc.enums.OS;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.parser.SQLParameter;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DriverUtil {
    public static ILogger log = LogFactory.getLog(DriverUtil.class);
    public static final String SQL_GET_DSC_EP_SITE = "SELECT dsc.ep_seqno, (CASE mal.MAL_INST_HOST WHEN '' THEN mal.MAL_HOST ELSE mal.MAL_INST_HOST END) as ep_host, dcr.EP_PORT, dsc.EP_STATUS FROM V$DSC_EP_INFO dsc LEFT join V$DM_MAL_INI mal on dsc.EP_NAME = mal.MAL_INST_NAME LEFT join (SELECT grp.GROUP_TYPE GROUP_TYPE, ep.* FROM SYS.\"V$DCR_GROUP\" grp, SYS.\"V$DCR_EP\" ep where grp.GROUP_NAME = ep.GROUP_NAME) dcr on dsc.EP_NAME = dcr.EP_NAME and GROUP_TYPE = 'DB' order by  dsc.ep_seqno asc;";

    public static List<EP> loadDscEpSites(DmdbConnection connection) {
        try {
            LinkedList<EP> dbList = new LinkedList<EP>();
            DmdbResultSet rs = DriverUtil.executeQuery(connection, SQL_GET_DSC_EP_SITE);
            while (rs.do_next()) {
                EP db = new EP(rs.do_getString(2), rs.do_getInt(3));
                db.epSeqno = rs.do_getInt(1);
                db.epStatus = StringUtil.equalsIgnoreCase(rs.do_getString(4), "OK") ? 1 : 2;
                dbList.add(db);
            }
            rs.do_close();
            return dbList;
        }
        catch (SQLException e2) {
            log.error("Get ep sites failed!", e2);
            return null;
        }
    }

    public static int compareDmdbVersion(String version1, String version2) {
        String[] serStrs = version1.split("\\.");
        String[] globalStrs = version2.split("\\.");
        int i2 = 0;
        while (i2 < serStrs.length) {
            Integer ser = Integer.valueOf(serStrs[i2]);
            Integer global = Integer.valueOf(globalStrs[i2]);
            if (ser < global) {
                return -1;
            }
            if (ser.intValue() != global.intValue()) {
                return 1;
            }
            ++i2;
        }
        return 0;
    }

    public static boolean isLocalHost(String host) {
        String localhostIP;
        String host2;
        if (StringUtil.isEmpty(host)) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(host) || "127.0.0.1".equals(host) || "::1".equals(host)) {
            return true;
        }
        try {
            host2 = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            host2 = host;
        }
        try {
            localhostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            localhostIP = null;
        }
        return host2.equalsIgnoreCase(localhostIP);
    }

    public static String getHostMchName() {
        String hostName;
        block15: {
            hostName = "";
            Process process = null;
            BufferedReader reader = null;
            try {
                try {
                    process = Runtime.getRuntime().exec("hostname");
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    hostName = reader.readLine();
                }
                catch (Exception exception) {
                    try {
                        process.destroy();
                    }
                    catch (Exception exception2) {}
                    MiscUtil.close(reader);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {}
                MiscUtil.close(reader);
                throw throwable;
            }
            try {
                process.destroy();
            }
            catch (Exception exception) {}
            MiscUtil.close(reader);
        }
        if (StringUtil.isNotEmpty(hostName)) {
            return hostName;
        }
        try {
            InetAddress ia = null;
            ia = InetAddress.getLocalHost();
            if (ia != null) {
                hostName = ia.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static OS getOS() {
        String osname = DriverUtil.getOSName();
        if (osname.startsWith("Win")) {
            return OS.WINDOWS;
        }
        if (osname.startsWith("Linux")) {
            return OS.LINUX;
        }
        if (osname.startsWith("AIX")) {
            return OS.AIX;
        }
        if (osname.startsWith("Solaris") || osname.startsWith("Sun")) {
            return OS.SOLARIS;
        }
        if (osname.startsWith("HP-UX")) {
            return OS.HP_UX;
        }
        if (osname.startsWith("FreeBSD")) {
            return OS.FREE_BSD;
        }
        if (osname.startsWith("Mac OS")) {
            return OS.MAC;
        }
        return OS.UNKNOW;
    }

    public static boolean isUnix() {
        OS osType = DriverUtil.getOS();
        return osType == OS.LINUX || osType == OS.AIX || osType == OS.HP_UX || osType == OS.SOLARIS || osType == OS.FREE_BSD;
    }

    public static void executeWithNewConnection(DmdbConnection conn, String sql) throws SQLException {
        DmdbConnection newConn = null;
        try {
            DmProperties props = (DmProperties)conn.props.clone();
            props.setProperty(Configuration.epGroup.getName(), null);
            newConn = DmDriver.driver.do_connect(props);
            DriverUtil.execute(newConn, sql);
        }
        catch (Throwable throwable) {
            MiscUtil.close(newConn);
            throw throwable;
        }
        MiscUtil.close(newConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DmdbConnection conn, String sql, int timeout) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbStatement stmt = null;
            boolean orgInnerExec = false;
            try {
                stmt = conn.do_createStatement();
                orgInnerExec = stmt.innerExec;
                stmt.innerExec = true;
                stmt.do_setQueryTimeout(timeout);
                stmt.do_execute(sql);
            }
            finally {
                if (stmt != null) {
                    stmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DmdbConnection conn, String sql) throws SQLException {
        DmdbStatement stmt = null;
        boolean orgInnerExec = false;
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            try {
                stmt = conn.do_createStatement();
                orgInnerExec = stmt.innerExec;
                stmt.innerExec = true;
                stmt.do_execute(sql);
            }
            finally {
                if (stmt != null) {
                    stmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepare(DmdbConnection conn, String sql, ResultSetUpdataData[] params, boolean[] bindIndicator) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbPreparedStatement pstmt = null;
            boolean orgInnerExec = false;
            try {
                pstmt = conn.do_prepareStatement(sql);
                orgInnerExec = pstmt.innerExec;
                pstmt.innerExec = true;
                int icol = 1;
                int i2 = 0;
                while (i2 < params.length) {
                    if (bindIndicator[i2]) {
                        pstmt.do_setObject(icol, params[i2].data);
                        ++icol;
                    }
                    ++i2;
                }
                pstmt.do_executeUpdate();
            }
            finally {
                if (pstmt != null) {
                    pstmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepareCursorUpdate(DmdbConnection conn, String sql, ResultSetUpdataData[] params, boolean[] bindIndicator, long cursorUpdateRow) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbPreparedStatement pstmt = null;
            boolean orgInnerExec = false;
            try {
                pstmt = conn.do_prepareStatement(sql);
                orgInnerExec = pstmt.innerExec;
                pstmt.innerExec = true;
                pstmt.poolable = false;
                pstmt.cursorUpdateRow = cursorUpdateRow;
                int icol = 1;
                int i2 = 0;
                while (i2 < params.length) {
                    if (bindIndicator[i2]) {
                        if (params[i2].jType == null && params[i2].scaleOrLength == null) {
                            pstmt.do_setObject(icol, params[i2].data);
                        } else if (params[i2].jType != null && params[i2].scaleOrLength != null) {
                            pstmt.do_setObject(icol, params[i2].data, (int)params[i2].jType, params[i2].scaleOrLength);
                        } else if (params[i2].jType != null) {
                            pstmt.do_setObject(icol, params[i2].data, params[i2].jType);
                        } else {
                            DBError.throwRuntimeException("ResultSetUpdataData must have jtype when use scaleOrLength !");
                        }
                        ++icol;
                    }
                    ++i2;
                }
                pstmt.do_execute();
            }
            finally {
                if (pstmt != null) {
                    pstmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCursorUpdate(DmdbConnection conn, String sql, long cursorUpdateRow) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbPreparedStatement pstmt = null;
            boolean orgInnerExec = false;
            try {
                pstmt = conn.do_prepareStatement(sql);
                orgInnerExec = pstmt.innerExec;
                pstmt.innerExec = true;
                pstmt.cursorUpdateRow = cursorUpdateRow;
                pstmt.poolable = false;
                pstmt.do_execute();
            }
            finally {
                if (pstmt != null) {
                    pstmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(pstmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] executePrepareCall(DmdbConnection conn, String sql, Object[] inParams, Integer[] outParamTypes) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbCallableStatement cstmt = conn.do_prepareCall(sql);
            boolean orgInnerExec = cstmt.innerExec;
            cstmt.innerExec = true;
            Object[] outParams = new Object[inParams.length];
            try {
                int i2 = 0;
                while (i2 < inParams.length) {
                    if (inParams[i2] != null) {
                        cstmt.do_setObject(i2 + 1, inParams[i2]);
                    }
                    if (outParamTypes[i2] != null) {
                        cstmt.do_registerOutParameter(i2 + 1, (int)outParamTypes[i2]);
                    }
                    ++i2;
                }
                cstmt.do_execute();
                i2 = 0;
                while (i2 < outParamTypes.length) {
                    if (outParamTypes[i2] != null) {
                        outParams[i2] = cstmt.do_getObject(i2 + 1);
                    }
                    ++i2;
                }
            }
            finally {
                if (cstmt != null) {
                    cstmt.innerExec = orgInnerExec;
                }
                MiscUtil.close(cstmt);
            }
            return outParams;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DmdbResultSet executeQuery(DmdbConnection conn, String sql) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbStatement stmt = null;
            boolean orgInnerExec = false;
            try {
                stmt = conn.do_createStatement(1004, 1007, 1);
                orgInnerExec = stmt.innerExec;
                stmt.innerExec = true;
                stmt.do_closeOnCompletion();
                DmdbResultSet dmdbResultSet = stmt.do_executeQuery(sql);
                return dmdbResultSet;
            }
            catch (SQLException e2) {
                MiscUtil.close(stmt);
                throw e2;
            }
            finally {
                if (stmt != null) {
                    stmt.innerExec = orgInnerExec;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DmdbResultSet executeQuery(DmdbConnection conn, String sql, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return DriverUtil.executeQuery(conn, sql);
        }
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbPreparedStatement pstmt = null;
            boolean orgInnerExec = false;
            try {
                pstmt = conn.do_prepareStatement(sql, 1004, 1007, 1);
                orgInnerExec = pstmt.innerExec;
                pstmt.innerExec = true;
                pstmt.do_closeOnCompletion();
                int i2 = 0;
                while (true) {
                    if (i2 >= params.length) {
                        DmdbResultSet dmdbResultSet = pstmt.do_executeQuery();
                        return dmdbResultSet;
                    }
                    pstmt.do_setObject(i2 + 1, params[i2]);
                    ++i2;
                }
            }
            catch (SQLException e2) {
                MiscUtil.close(pstmt);
                throw e2;
            }
            finally {
                if (pstmt != null) {
                    pstmt.innerExec = orgInnerExec;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DmdbResultSet executeQueryWithConst(DmdbConnection conn, String sql, Object[] params) throws SQLException {
        if (params == null || params.length == 0) {
            return DriverUtil.executeQuery(conn, sql);
        }
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            DmdbStatement stmt = null;
            boolean orgInnerExec = false;
            try {
                stmt = conn.do_createStatement(1004, 1007, 1);
                orgInnerExec = stmt.innerExec;
                stmt.innerExec = true;
                stmt.do_closeOnCompletion();
                ArrayList<SQLParameter> constParamList = new ArrayList<SQLParameter>(params.length);
                int i2 = 0;
                while (true) {
                    if (i2 >= params.length) {
                        DmdbResultSet dmdbResultSet = stmt.do_executeQueryWithConst(sql, constParamList);
                        return dmdbResultSet;
                    }
                    SQLParameter constParam = null;
                    Object value = params[i2];
                    if (value == null) {
                        constParam = new SQLParameter(null, 2, Short.MAX_VALUE);
                    } else if (value instanceof Long) {
                        constParam = new SQLParameter(J2DB.toBigint((Long)value), 8, 8);
                    } else if (params[i2] instanceof Integer) {
                        constParam = new SQLParameter(J2DB.toInt(((Integer)value).intValue()), 7, 4);
                    } else if (params[i2] instanceof String) {
                        constParam = new SQLParameter(J2DB.toVarchar((String)value, conn.getServerEncoding()), 2, Short.MAX_VALUE);
                    } else if (params[i2] instanceof Boolean) {
                        constParam = new SQLParameter(J2DB.toBit((Boolean)value != false ? 1 : 0), 3, 1);
                    } else {
                        DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                    }
                    constParamList.add(constParam);
                    ++i2;
                }
            }
            catch (SQLException e2) {
                MiscUtil.close(stmt);
                throw e2;
            }
            finally {
                if (stmt != null) {
                    stmt.innerExec = orgInnerExec;
                }
            }
        }
    }

    public static String executeAndGetExplain(DmdbConnection conn, String sql) throws SQLException {
        DmdbConnection dmdbConnection = conn;
        synchronized (dmdbConnection) {
            String string;
            DmdbStatement stmt = null;
            try {
                stmt = conn.do_createStatement();
                stmt.do_execute(sql);
                string = stmt.execInfo.explain;
            }
            catch (Throwable throwable) {
                MiscUtil.close(stmt);
                throw throwable;
            }
            MiscUtil.close(stmt);
            return string;
        }
    }

    public static boolean checkDbAlive(String host, int port) {
        boolean alive;
        block5: {
            alive = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                    socket.connect(socketAddress, 5000);
                    alive = true;
                }
                catch (Exception exception) {
                    MiscUtil.close(socket);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                MiscUtil.close(socket);
                throw throwable;
            }
            MiscUtil.close(socket);
        }
        return alive;
    }

    public static String formatDir(String dir) {
        if (StringUtil.isNotEmpty(dir = StringUtil.trimToEmpty(dir)) && !dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        return dir;
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static int checkCompleteCharLen(ByteArrayQueue bytes, int offset, int len, Charset encoding) {
        int charLen = 0;
        int iLen = 0;
        int i2 = offset;
        while (i2 < offset + len) {
            iLen = DriverUtil.calcCharLen(bytes, i2, encoding);
            if (iLen <= 0 || charLen + iLen > len) break;
            charLen += iLen;
            i2 += iLen;
        }
        return charLen;
    }

    public static int checkCompleteCharLen(byte[] bytes, int offset, int len, Charset encoding) {
        int charLen = 0;
        int iLen = 0;
        int i2 = offset;
        while (i2 < offset + len) {
            iLen = DriverUtil.calcCharLen(bytes, i2, encoding);
            if (iLen <= 0 || charLen + iLen > len) break;
            charLen += iLen;
            i2 += iLen;
        }
        return charLen;
    }

    private static int calcCharLen(byte[] bytes, int offset, Charset encoding) {
        byte current;
        block20: {
            block18: {
                int tmp;
                block19: {
                    try {
                        current = bytes[offset];
                        if (encoding != ENCODING.GB18030.charset()) break block18;
                        tmp = current & 0xFF;
                        if (tmp > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte next = bytes[offset + 1];
                tmp = next & 0xFF;
                if (tmp >= 64 && tmp <= 254 && tmp != 127) {
                    return 2;
                }
                return 4;
            }
            if (encoding != ENCODING.EUCKR.charset()) break block20;
            int tmp = current & 0xFF;
            if (tmp <= 128) {
                return 1;
            }
            return 2;
        }
        int len = 1;
        if ((current & 0x80) == 0) {
            len = 1;
        } else if ((current & 0xE0) == 192) {
            len = 2;
        } else if ((current & 0xF0) == 224) {
            len = 3;
        } else if ((current & 0xF8) == 240) {
            len = 4;
        } else if ((current & 0xFC) == 248) {
            len = 5;
        } else if ((current & 0xFE) == 252) {
            len = 6;
        }
        return len;
    }

    private static int calcCharLen(ByteArrayQueue bytes, int offset, Charset encoding) {
        byte current;
        block20: {
            block18: {
                int tmp;
                block19: {
                    try {
                        current = bytes.getByte(offset);
                        if (encoding != ENCODING.GB18030.charset()) break block18;
                        tmp = current & 0xFF;
                        if (tmp > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte next = bytes.getByte(offset + 1);
                tmp = next & 0xFF;
                if (tmp >= 64 && tmp <= 254 && tmp != 127) {
                    return 2;
                }
                return 4;
            }
            if (encoding != ENCODING.EUCKR.charset()) break block20;
            int tmp = current & 0xFF;
            if (tmp <= 128) {
                return 1;
            }
            return 2;
        }
        int len = 1;
        if ((current & 0x80) == 0) {
            len = 1;
        } else if ((current & 0xE0) == 192) {
            len = 2;
        } else if ((current & 0xF0) == 224) {
            len = 3;
        } else if ((current & 0xF8) == 240) {
            len = 4;
        } else if ((current & 0xFC) == 248) {
            len = 5;
        } else if ((current & 0xFE) == 252) {
            len = 6;
        }
        return len;
    }

    public static long murmurhash2_64(String text) {
        byte[] data = text.getBytes();
        int length = data.length;
        int seed = -512093083;
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        int i2 = 0;
        while (i2 < length8) {
            int i8 = i2 * 8;
            long k2 = ((long)data[i8 + 0] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k2 *= -4132994306676758123L;
            k2 ^= k2 >>> 47;
            h2 ^= (k2 *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
            ++i2;
        }
        switch (length % 8) {
            case 7: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h2 ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h2 ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    public static final String[] split(String s2, String seperators) {
        if (s2 == null || seperators == null) {
            return null;
        }
        int[] foot = new int[s2.length()];
        int count = 0;
        int sLen = s2.length();
        int seperatorsLen = seperators.length();
        int i2 = 0;
        while (i2 < sLen) {
            if (i2 == 0 && sLen >= seperatorsLen && s2.substring(0, seperatorsLen).equals(seperators)) {
                i2 += seperatorsLen - 1;
            } else {
                int j2 = 0;
                while (j2 < seperatorsLen) {
                    if (s2.charAt(i2) == seperators.charAt(j2)) {
                        foot[count] = i2;
                        ++count;
                        break;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        String[] ret = new String[count + 1];
        if (count == 0) {
            ret[0] = s2;
            return ret;
        }
        ret[0] = s2.substring(0, foot[0]);
        int i3 = 1;
        while (i3 < count) {
            ret[i3] = s2.substring(foot[i3 - 1] + 1, foot[i3]);
            ++i3;
        }
        ret[count] = s2.substring(foot[count - 1] + 1, s2.length());
        return ret;
    }

    public static void main(String[] args) throws SQLException {
        System.out.println(DriverUtil.getHostMchName());
    }

    public static int findEpSeqno(List<EP> epList, String rsp_host, int rsp_port) {
        int i2 = 0;
        while (i2 < epList.size()) {
            EP ep = epList.get(i2);
            if (StringUtil.equals(ep.host, rsp_host) && ep.port == rsp_port) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public static long[] toOracleUpdateCounts(DmdbConnection connection, long[] dmUpdateCounts) {
        if (!connection.compatibleOracle() || connection.compatibleOracle19() || dmUpdateCounts == null || dmUpdateCounts.length == 0) {
            return dmUpdateCounts;
        }
        long[] oracleUpdateCounts = new long[dmUpdateCounts.length];
        Arrays.fill(oracleUpdateCounts, -2L);
        return oracleUpdateCounts;
    }
}

