/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StringEncoder {
    private byte[][] unicodeMapping = new byte[65536][];

    public StringEncoder(String charset) {
        try {
            int i2 = 0;
            while (i2 < 65536) {
                char c2 = (char)i2;
                this.unicodeMapping[i2] = String.valueOf(c2).getBytes(charset);
                ++i2;
            }
        }
        catch (UnsupportedEncodingException e2) {
            DBError.throwRuntimeException("create string encoder fail", e2);
        }
    }

    public final int getBytes(String str, byte[] buffer) {
        int count = 0;
        int i2 = 0;
        int len = str.length();
        while (i2 < len) {
            byte[] bs = this.unicodeMapping[str.charAt(i2)];
            buffer[count++] = bs[0];
            if (bs.length > 1) {
                buffer[count++] = bs[1];
                if (bs.length > 2) {
                    buffer[count++] = bs[2];
                    if (bs.length > 3) {
                        buffer[count++] = bs[3];
                    }
                }
            }
            ++i2;
        }
        return count;
    }

    public final byte[] getBytes(String str) {
        byte[] buffer = new byte[str.length() * 3];
        int len = this.getBytes(str, buffer);
        byte[] copy = new byte[len];
        System.arraycopy(buffer, 0, copy, 0, len);
        return copy;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String testStr = "`M<>?\":{}][|\\]12345*()_+~!@#$%^&\u8fbe\u68a6\u6570\u636e\u5e93\u5f88\u597d\u5f88\u5f3a\u5927";
        String testStr2 = "\u8fbe\u68a6";
        String testStr3 = "\u5f88\u597d";
        String testStr4 = "\u6570\u636e";
        String testStr5 = "\u636e\u5e93";
        String testStr6 = "\u5f3a\u5927";
        String testStr7 = "\u6570\u636e\u5e93";
        String testStr8 = "\u5f88\u5f3a\u5927";
        byte[] buffer1 = null;
        byte[] buffer2 = null;
        byte[] buffer3 = null;
        byte[] buffer4 = null;
        byte[] buffer5 = null;
        byte[] buffer6 = null;
        byte[] buffer7 = null;
        byte[] buffer8 = null;
        byte[] buffer21 = null;
        byte[] buffer22 = null;
        byte[] buffer23 = null;
        byte[] buffer24 = null;
        byte[] buffer25 = null;
        byte[] buffer26 = null;
        byte[] buffer27 = null;
        byte[] buffer28 = null;
        StringEncoder encoder = new StringEncoder(Charset.defaultCharset().name());
        long startTime = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 5000000) {
            buffer1 = encoder.getBytes(testStr);
            buffer2 = encoder.getBytes(testStr2);
            buffer3 = encoder.getBytes(testStr3);
            buffer4 = encoder.getBytes(testStr4);
            buffer5 = encoder.getBytes(testStr5);
            buffer6 = encoder.getBytes(testStr6);
            buffer7 = encoder.getBytes(testStr7);
            buffer8 = encoder.getBytes(testStr8);
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        i2 = 0;
        while (i2 < 5000000) {
            buffer21 = testStr.getBytes();
            buffer22 = testStr2.getBytes();
            buffer23 = testStr3.getBytes();
            buffer24 = testStr4.getBytes();
            buffer25 = testStr5.getBytes();
            buffer26 = testStr6.getBytes();
            buffer27 = testStr7.getBytes();
            buffer28 = testStr8.getBytes();
            ++i2;
        }
        System.out.println(System.currentTimeMillis() - startTime);
        System.out.println(Arrays.equals(buffer1, buffer21));
        System.out.println(Arrays.equals(buffer2, buffer22));
        System.out.println(Arrays.equals(buffer3, buffer23));
        System.out.println(Arrays.equals(buffer4, buffer24));
        System.out.println(Arrays.equals(buffer5, buffer25));
        System.out.println(Arrays.equals(buffer6, buffer26));
        System.out.println(Arrays.equals(buffer7, buffer27));
        System.out.println(Arrays.equals(buffer8, buffer28));
    }
}

