/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.api.IHiveServerBuffer;
import com.cloudera.impala.hivecommon.api.TETHttpClient;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc4.internal.apache.thrift.transport.TSaslClientTransport;
import com.cloudera.impala.jdbc4.internal.apache.thrift.transport.TSocket;
import com.cloudera.impala.support.exceptions.ErrorException;

public abstract class HiveClientBase<HiveApiBuffer extends IHiveServerBuffer>
implements IHiveClient<HiveApiBuffer> {
    @Override
    public boolean isArrowEnabled() {
        return false;
    }

    @Override
    public void setSocketTimeout(int n) throws ErrorException {
        TProtocol tProtocol = this.getProtocol();
        if (tProtocol.getTransport() instanceof TETHttpClient) {
            ((TETHttpClient)tProtocol.getTransport()).setReadTimeout(n);
        } else {
            Object object;
            TSocket tSocket = null;
            if (tProtocol.getTransport() instanceof TSocket) {
                tSocket = (TSocket)tProtocol.getTransport();
            } else if (tProtocol.getTransport() instanceof TSaslClientTransport) {
                object = (TSaslClientTransport)tProtocol.getTransport();
                if (((TSaslClientTransport)object).getUnderlyingTransport() instanceof TSocket) {
                    tSocket = (TSocket)((TSaslClientTransport)object).getUnderlyingTransport();
                }
            } else {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.UNSUPPOTED_TTRANSPORT.name(), new String[]{tProtocol.getTransport().getClass().getName()});
                throw errorException;
            }
            if (null != tSocket) {
                tSocket.setTimeout(n);
            } else {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.NULL_SOCKET_ERROR.name());
                throw object;
            }
        }
    }

    protected abstract TProtocol getProtocol();
}

