/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.jdbc4.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.cloudera.impala.jdbc4.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.impala.jdbc4.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.impala.jdbc4.internal.apache.hive.service.rpc.thrift.TSparkDirectResults;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class HiveExecutionContext {
    public TFetchResultsReq m_fetchResultsReq = null;
    public TExecuteStatementResp m_executeResponse = null;
    public short[] m_columnTypes = null;
    public boolean m_hasOpenOperation = false;
    public AtomicBoolean m_isManualCanceled = new AtomicBoolean(false);
    public boolean m_isLimitZeroQueryParseFailed = false;
    public Throwable m_backgroundFetcherError = null;
    public Semaphore m_fetchEndSemaphore = new Semaphore(0);
    public long m_foregroundThreadID = -1L;
    public long m_backgroundThreadID = -1L;
    public long m_startTime = 0L;
    public long m_timeoutVal = 0L;
    public String m_query = null;
    public ArrayList<ColumnMetadata> m_sencolumns = null;
    public boolean m_isExecutionComplete = false;
    public boolean m_serverHasMoreRows = true;
    public boolean m_hasDROperationStatusResp = false;
    public boolean m_hasDRGetRsmdResp = false;
    public boolean m_hasDRFetchResp = false;
    public boolean m_hasDRCloseOpResp = false;
    public TSparkDirectResults m_directResults = null;
    public boolean m_hasArrowResults = false;
    public List<TColumnDesc> m_rsMdColumns = null;
    public HiveJDBCStatement m_statement;
    public int m_fetchSize = 0;

    public ILogger getLogger() {
        if (null != this.m_statement) {
            return this.m_statement.getLog();
        }
        return null;
    }

    public HiveJDBCStatement getStatement() {
        return this.m_statement;
    }

    public boolean isCanceled() {
        if (null != this.m_statement) {
            return this.m_statement.isCanceled();
        }
        return false;
    }

    public void setStatement(HiveJDBCStatement hiveJDBCStatement) {
        this.m_statement = hiveJDBCStatement;
    }

    protected void handleDirectResultsResp(ILogger iLogger, TSparkDirectResults tSparkDirectResults) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_directResults = tSparkDirectResults;
        this.m_hasDROperationStatusResp = tSparkDirectResults.isSetOperationStatus();
        this.m_hasDRGetRsmdResp = tSparkDirectResults.isSetResultSetMetadata();
        this.m_hasDRFetchResp = tSparkDirectResults.isSetResultSet();
        this.m_hasDRCloseOpResp = tSparkDirectResults.isSetCloseOperation();
        String string = "Received: operationStatus=" + (this.m_hasDROperationStatusResp ? "true" : "false") + ", resultSetMetadata=" + (this.m_hasDRGetRsmdResp ? "true" : "false") + ", resultSet=" + (this.m_hasDRFetchResp ? "true" : "false") + ", closeOperation=" + (this.m_hasDRCloseOpResp ? "true" : "false");
        LogUtilities.logDebug(string, iLogger);
    }
}

