/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.TEHTTPSettings;
import com.cloudera.impala.hivecommon.exceptions.TEHttpRetryException;
import com.cloudera.impala.hivecommon.exceptions.TETokenExpirationException;
import com.cloudera.impala.jdbc4.internal.apache.http.Header;
import com.cloudera.impala.jdbc4.internal.apache.http.HeaderIterator;
import com.cloudera.impala.jdbc4.internal.apache.http.HttpEntity;
import com.cloudera.impala.jdbc4.internal.apache.http.HttpHost;
import com.cloudera.impala.jdbc4.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc4.internal.apache.http.client.HttpClient;
import com.cloudera.impala.jdbc4.internal.apache.http.client.methods.HttpPost;
import com.cloudera.impala.jdbc4.internal.apache.http.entity.ByteArrayEntity;
import com.cloudera.impala.jdbc4.internal.apache.thrift.transport.THttpClient;
import com.cloudera.impala.jdbc4.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class TETHttpClient
extends THttpClient {
    private static final int HTTP_THRIFT_ERR_CODE_UPPER_BOUND = 600;
    private static final String THRIFT_SERVER_ERROR_HEADER = "X-ThriftServer-Error-Message";
    private static final String TOKEN_ERR_STR = "token";
    private static final String TOKEN_EXP_HEADER_MISSING_MSG = "Authorization related error response returned, but no token expired message received";
    private static final String TOKEN_EXPIRE_ERR_STR = "expire";
    private static final String UNKNOWN_HEADER_ERR_MSG = "Unknown";
    private URL m_url = null;
    private final ByteArrayOutputStream m_requestBuffer = new ByteArrayOutputStream();
    private InputStream m_inputStream = null;
    private int m_connectTimeout = 0;
    private int m_readTimeout = 0;
    private final HttpHost m_host;
    private final HttpClient m_client;
    private TEHTTPSettings m_settings;
    private ILogger m_logger;

    public TETHttpClient(String string) throws TTransportException {
        super(string);
        try {
            this.m_url = new URL(string);
            this.m_client = null;
            this.m_host = null;
            this.m_settings = new TEHTTPSettings();
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public TETHttpClient(String string, HttpClient httpClient, TEHTTPSettings tEHTTPSettings, ILogger iLogger) throws TTransportException {
        super(string, httpClient);
        try {
            this.m_logger = iLogger;
            this.m_url = new URL(string);
            this.m_client = httpClient;
            this.m_host = new HttpHost(this.m_url.getHost(), -1 == this.m_url.getPort() ? this.m_url.getDefaultPort() : this.m_url.getPort(), this.m_url.getProtocol());
            this.m_settings = tEHTTPSettings;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    @Override
    public void close() {
        if (null != this.m_inputStream) {
            try {
                this.m_inputStream.close();
            }
            catch (IOException iOException) {
                LogUtilities.logWarning(iOException, this.m_logger);
            }
            this.m_inputStream = null;
        }
    }

    public static String extractThriftHeaderError(HttpResponse httpResponse) {
        return TETHttpClient.extractThriftHeaderError(httpResponse, false);
    }

    public static String extractThriftHeaderError(HttpResponse httpResponse, boolean bl) {
        Header header = httpResponse.getFirstHeader(THRIFT_SERVER_ERROR_HEADER);
        String string = null != header ? header.getValue() : (bl ? TOKEN_EXP_HEADER_MISSING_MSG : UNKNOWN_HEADER_ERR_MSG);
        return TETHttpClient.createResponseErrorMessage(httpResponse, string);
    }

    @Override
    public void flush() throws TTransportException {
        if (null != this.m_client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] byArray = this.m_requestBuffer.toByteArray();
        this.m_requestBuffer.reset();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.m_url.openConnection();
            if (this.m_connectTimeout > 0) {
                httpURLConnection.setConnectTimeout(this.m_connectTimeout);
            }
            if (this.m_readTimeout > 0) {
                httpURLConnection.setReadTimeout(this.m_readTimeout);
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-thrift");
            httpURLConnection.setRequestProperty("Accept", "application/x-thrift");
            httpURLConnection.setRequestProperty("User-Agent", this.m_settings.m_userAgentEntry);
            if (null != this.m_settings.getCustomHeaders()) {
                for (Map.Entry<String, String> entry : this.m_settings.getCustomHeaders().entrySet()) {
                    httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            httpURLConnection.getOutputStream().write(byArray);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new TTransportException("HTTP Response code: " + n);
            }
            this.m_inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws TTransportException {
        if (this.m_inputStream == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int n3 = this.m_inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new TTransportException("No more data available.");
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    @Override
    public void setConnectTimeout(int n) {
        this.m_connectTimeout = n;
        super.setConnectTimeout(n);
    }

    @Override
    public void setCustomHeaders(Map<String, String> map) {
        this.m_settings.setCustomHeaders(map);
    }

    @Override
    public void setCustomHeader(String string, String string2) {
        this.m_settings.addCustomHeader(string, string2);
    }

    @Override
    public void setReadTimeout(int n) {
        this.m_readTimeout = n;
        super.setReadTimeout(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.m_requestBuffer.write(byArray, n, n2);
    }

    private HttpPost buildPostRequest(byte[] byArray) {
        HttpPost httpPost = new HttpPost(this.m_url.getFile());
        httpPost.setHeader("Content-Type", "application/x-thrift");
        httpPost.setHeader("Accept", "application/x-thrift");
        httpPost.setHeader("User-Agent", this.m_settings.m_userAgentEntry);
        if (null != this.m_settings.getCustomHeaders()) {
            for (Map.Entry<String, String> entry : this.m_settings.getCustomHeaders().entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity(new ByteArrayEntity(byArray));
        return httpPost;
    }

    private static void consume(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    private static String createResponseErrorMessage(HttpResponse httpResponse, String string) {
        String string2 = "HTTP Response code: " + httpResponse.getStatusLine().getStatusCode() + ", Error message: ";
        return string2.concat(string);
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.m_client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] byArray = this.m_requestBuffer.toByteArray();
        this.m_requestBuffer.reset();
        HttpPost httpPost = null;
        InputStream inputStream = null;
        try {
            httpPost = this.buildPostRequest(byArray);
            HttpResponse httpResponse = this.m_client.execute(this.m_host, httpPost);
            int n = httpResponse.getStatusLine().getStatusCode();
            inputStream = httpResponse.getEntity().getContent();
            if (n != 200) {
                this.handleErrorResponse(httpResponse);
            }
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            do {
                if ((n2 = inputStream.read(byArray2)) <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n2);
            } while (-1 != n2);
            try {
                TETHttpClient.consume(httpResponse.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            if (null != httpPost) {
                httpPost.abort();
            }
            throw new TTransportException(iOException);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new TTransportException(iOException);
                }
            }
            if (null != httpPost) {
                httpPost.releaseConnection();
            }
        }
    }

    private void handleErrorResponse(HttpResponse httpResponse) throws TTransportException {
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n == 503 || n == 429) {
            throw new TEHttpRetryException(httpResponse);
        }
        if (n < 400 || n >= 600) {
            throw new TTransportException("HTTP Response code: " + n);
        }
        this.handleHeaderErrorMessage(httpResponse);
    }

    private void handleHeaderErrorMessage(HttpResponse httpResponse) throws TTransportException {
        boolean bl;
        boolean bl2 = bl = this.m_settings.m_isOAuth && this.isAuthenticationError(httpResponse.getStatusLine().getStatusCode());
        if (bl) {
            TETHttpClient.handleTokenExpirationError(httpResponse);
        }
        throw new TTransportException(TETHttpClient.extractThriftHeaderError(httpResponse, bl));
    }

    private static void handleTokenExpirationError(HttpResponse httpResponse) throws TETokenExpirationException {
        HeaderIterator headerIterator = httpResponse.headerIterator();
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            if (!header.getValue().contains(TOKEN_ERR_STR) || !header.getValue().contains(TOKEN_EXPIRE_ERR_STR)) continue;
            throw new TETokenExpirationException(TETHttpClient.createResponseErrorMessage(httpResponse, header.getValue()));
        }
    }

    private boolean isAuthenticationError(int n) {
        switch (n) {
            case 400: 
            case 401: 
            case 403: {
                return true;
            }
        }
        return false;
    }
}

