/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.querytranslation.hql;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.impala.dsi.dataengine.utilities.ExecutionContexts;
import com.cloudera.impala.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.IServerVersion;
import com.cloudera.impala.hivecommon.IServerVersionUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.ScalarFunctionTranslator;
import com.cloudera.impala.hivecommon.querytranslation.hql.ChildJoinPredicateAnalyzer;
import com.cloudera.impala.hivecommon.querytranslation.hql.JoinColumnNode;
import com.cloudera.impala.hivecommon.querytranslation.hql.JoinNode;
import com.cloudera.impala.hivecommon.querytranslation.hql.OrderBySubqueryAnalyzer;
import com.cloudera.impala.hivecommon.querytranslation.hql.SelectListAnalyzer;
import com.cloudera.impala.hivecommon.querytranslation.hql.SelectNode;
import com.cloudera.impala.hivecommon.querytranslation.hql.SelectType;
import com.cloudera.impala.hivecommon.querytranslation.hql.TableAliasGenerator;
import com.cloudera.impala.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AENodeList;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AbstractAENodeList;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEDistinct;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AESort;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETableConstructor;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AETop;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AEUnion;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AESetClauseList;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AENull;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.UUID;

public class HiveQLAENodeVisitor
extends AEDefaultVisitor<String> {
    private static final String EXPR_COL_NAME = "EXPR_";
    private ExecutionContexts m_batchparams;
    private boolean m_batchMode = false;
    private boolean m_canReplaceListWithStar = false;
    private HashMap<Integer, SelectNode> m_columnFullNameRef;
    private List<SelectNode> m_columnFullNameRefPersisting;
    private boolean m_containORoperatorInJoin = false;
    private int m_currentColumnNumber = 0;
    private ExecutionContext m_currentContext;
    private AEJoin.AEJoinType m_currentJoinType = null;
    private String m_currentSelectList = "";
    private ArrayList<ArrayList<String>> m_insertValues;
    private SqlQueryExecutor m_executor;
    private HashMap<AENamedRelationalExpr, String> m_generatedTableAlias;
    private boolean m_hasDistinct = false;
    private boolean m_hasSubquery = false;
    private boolean m_isBuildSubQueryForOrderBy = false;
    private boolean m_isBuildSubQueryForOrderByFromAESort = false;
    private boolean m_isBuildSubQueryForOrderByFromAETop = false;
    private JoinState m_innerJoinState = JoinState.NULL;
    private List<JoinNode> m_joinsForSyntheticProjection;
    private boolean m_launchExtraWhereClause = false;
    private HashMap<Integer, Integer> m_orderMap;
    private ExecutionContext m_params;
    private AETable m_dmlTargetTableMetadata;
    private boolean m_processingBinaryValue = false;
    private boolean m_processingGeneralAggrFn = false;
    private boolean m_processingNegateFn = false;
    private boolean m_processingOrderBySelectList = false;
    private boolean m_processingOrderByFromClause = false;
    private boolean m_processingOrderBySortList = false;
    private boolean m_processingOrderByList = false;
    private boolean m_processingOrderNode = false;
    private boolean m_processingRename = false;
    private boolean m_processingSelectList = false;
    private boolean m_processingScalarFn = false;
    private boolean m_processingOrderBySubquery = false;
    private boolean m_processingInsertTable;
    private boolean m_processingInsertValue;
    private boolean m_processingInsertExpression;
    private boolean m_processingDeleteTable;
    private boolean m_processingUpdateTable;
    private boolean m_processingUpdateColumnSelection;
    private String m_subqueryState = "NULL";
    private List<IColumn> m_selectConcatColumnRef;
    private IServerVersion m_serverVersion;
    private IServerVersionUtils m_serverVersionUtils;
    private HiveJDBCSettings m_settings;

    public HiveQLAENodeVisitor(ExecutionContext executionContext, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion, HiveJDBCSettings hiveJDBCSettings) {
        this.m_params = executionContext;
        this.m_executor = sqlQueryExecutor;
        this.m_serverVersion = iServerVersion;
        this.m_serverVersionUtils = iServerVersionUtils;
        this.m_columnFullNameRef = new HashMap();
        this.m_columnFullNameRefPersisting = new ArrayList<SelectNode>();
        this.m_generatedTableAlias = null;
        this.m_settings = hiveJDBCSettings;
    }

    public HiveQLAENodeVisitor(ExecutionContexts executionContexts, SqlQueryExecutor sqlQueryExecutor, IServerVersionUtils iServerVersionUtils, IServerVersion iServerVersion) {
        this.m_batchparams = executionContexts;
        this.m_executor = sqlQueryExecutor;
        this.m_serverVersion = iServerVersion;
        this.m_serverVersionUtils = iServerVersionUtils;
        this.m_columnFullNameRef = new HashMap();
        this.m_columnFullNameRefPersisting = new ArrayList<SelectNode>();
        this.m_generatedTableAlias = null;
        this.m_batchMode = true;
    }

    @Override
    public String visit(AEAdd aEAdd) throws ErrorException {
        boolean bl = this.m_processingBinaryValue;
        this.m_processingBinaryValue = true;
        if (aEAdd.getTypeMetadata().isCharacterType()) {
            return this.visit(new AEConcat(this.m_executor.getContext().getDataEngineContext().getCoercionHandler(), aEAdd.getLeftOperand(), aEAdd.getRightOperand()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEAdd.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" + ");
        stringBuilder.append(aEAdd.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString(), stringBuilder.toString(), null, aEAdd.getColumn()));
        this.m_processingBinaryValue = bl;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEAggregate aEAggregate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(aEAggregate.getOperand().acceptVisitor(this));
        if (aEAggregate.getNumChildren() == 3) {
            Iterator<IAENode> iterator = aEAggregate.getChildItr();
            iterator.next();
            iterator.next();
            stringBuilder.append(" GROUP BY " + iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEAnd aEAnd) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        Iterator<IAENode> iterator = aEAnd.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        stringBuilder.append(string).append(" AND ");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.append(" )").toString();
    }

    @Override
    public String visit(AEColumnReference aEColumnReference) throws ErrorException {
        String string = null;
        AENamedRelationalExpr aENamedRelationalExpr = aEColumnReference.getNamedRelationalExpr();
        if (this.m_processingDeleteTable || this.m_processingUpdateTable) {
            if (this.m_processingUpdateColumnSelection) {
                return '`' + aEColumnReference.getName() + '`';
            }
            string = aENamedRelationalExpr.getCorrelationName();
        } else {
            string = this.m_generatedTableAlias.containsKey(aENamedRelationalExpr) ? this.m_generatedTableAlias.get(aENamedRelationalExpr) : aENamedRelationalExpr.getCorrelationName();
        }
        IColumn iColumn = aEColumnReference.getNamedRelationalExpr().getBaseColumn(aEColumnReference.getColumnNum());
        if (!(null == this.m_joinsForSyntheticProjection || this.m_processingOrderByList || this.m_processingSelectList || this.m_isBuildSubQueryForOrderBy)) {
            for (JoinNode object2 : this.m_joinsForSyntheticProjection) {
                String string2 = this.findJoinNodeReference(aEColumnReference, iColumn, object2);
                if (null == string2) continue;
                return string2;
            }
        } else if (null != this.m_joinsForSyntheticProjection && this.m_processingSelectList) {
            block1: for (int i = this.m_joinsForSyntheticProjection.size(); 0 < i; --i) {
                JoinNode joinNode = this.m_joinsForSyntheticProjection.get(i - 1);
                for (JoinColumnNode joinColumnNode : joinNode.getPredicateColumns()) {
                    if (joinColumnNode.getColumn() != iColumn) continue;
                    if (this.m_processingOrderBySelectList || this.m_processingSelectList) {
                        Object object;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(joinColumnNode.getColumnReferenceName());
                        if (aEColumnReference.getParent().getParent() instanceof AEUnaryRelationalExpr && ((AEUnaryRelationalExpr)(object = (AEUnaryRelationalExpr)aEColumnReference.getParent().getParent())).getOperand() != joinNode.getParent() && (!(((AEUnaryRelationalExpr)object).getOperand() instanceof AESelect) || ((AESelect)((AEUnaryRelationalExpr)object).getOperand()).getOperand() != joinNode.getParent())) continue block1;
                        if (this.m_processingRename) {
                            return stringBuilder.toString();
                        }
                        object = joinColumnNode.getColumnReferenceName().replace('`', '_').replace('.', '_');
                        this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, "`" + (String)object + "`", stringBuilder.toString(), aEColumnReference, aEColumnReference.getColumn()));
                        if (this.m_serverVersionUtils.supportsAliasingInScalarFun(this.m_serverVersion) && !this.m_processingGeneralAggrFn) {
                            stringBuilder.append(" ").append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, (String)object)).append("");
                        }
                        return stringBuilder.toString();
                    }
                    this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, joinColumnNode.getColumnReferenceName(), joinColumnNode.getColumnReferenceName(), aEColumnReference, aEColumnReference.getColumn()));
                    return joinColumnNode.getColumnReferenceName();
                }
            }
        } else if (null != this.m_joinsForSyntheticProjection) {
            for (JoinNode joinNode : this.m_joinsForSyntheticProjection) {
                String string3 = this.findJoinNodeReference(aEColumnReference, iColumn, joinNode);
                if (null == string3) continue;
                return string3;
            }
            boolean bl = false;
            if (aEColumnReference.getParent().getParent() instanceof AEBooleanExpr && aEColumnReference.getParent().getParent().getParent() instanceof AEJoin) {
                bl = true;
            }
            block4: for (JoinNode joinNode : this.m_joinsForSyntheticProjection) {
                if (bl) break;
                IAENode iAENode = aEColumnReference.getParent();
                do {
                    if (!(iAENode instanceof AERelationalExpr)) continue;
                    if (iAENode != joinNode.getChild()) {
                        for (JoinColumnNode joinColumnNode : joinNode.getPredicateColumns()) {
                            if (iAENode instanceof AEUnaryRelationalExpr && ((AEUnaryRelationalExpr)iAENode).getOperand() instanceof AEJoin && joinNode.getParent() != ((AEUnaryRelationalExpr)iAENode).getOperand()) continue block4;
                            if (joinColumnNode.getColumn() != iColumn) continue;
                            if (this.m_processingOrderBySelectList) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(joinColumnNode.getColumnReferenceName());
                                if (this.m_processingRename) {
                                    return stringBuilder.toString();
                                }
                                String string4 = joinColumnNode.getColumnReferenceName().replace('`', '_').replace('.', '_');
                                this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, "`" + string4 + "`", stringBuilder.toString(), aEColumnReference, aEColumnReference.getColumn()));
                                stringBuilder.append(" ").append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, string4)).append(" ");
                                return stringBuilder.toString();
                            }
                            if (this.m_processingOrderBySortList) {
                                StringBuilder stringBuilder = new StringBuilder();
                                String string5 = joinColumnNode.getColumnReferenceName().replace('`', '_').replace('.', '_');
                                stringBuilder.append(" ").append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, string5)).append(" ");
                                return stringBuilder.toString();
                            }
                            this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, joinColumnNode.getColumnReferenceName(), joinColumnNode.getColumnReferenceName(), aEColumnReference, aEColumnReference.getColumn()));
                            return joinColumnNode.getColumnReferenceName();
                        }
                        continue block4;
                    }
                    if (!(iAENode instanceof AEJoin)) continue block4;
                    bl = true;
                    continue block4;
                } while (null != (iAENode = iAENode.getParent()).getParent());
            }
        }
        if (string.length() > 0) {
            return this.buildQualifiedColumnName(aEColumnReference, string);
        }
        String string5 = aEColumnReference.getNamedRelationalExpr().getQTableName().getTableName();
        if (string5.length() > 0) {
            return this.buildQualifiedColumnName(aEColumnReference, string5);
        }
        String string6 = "`" + aEColumnReference.getName() + "`";
        return string6;
    }

    @Override
    public String visit(AEComparison aEComparison) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IAENode> iterator = aEComparison.getChildItr();
        if (null != aEComparison.getComparisonOp() && (!aEComparison.getComparisonOp().toString().equalsIgnoreCase("=") || this.m_containORoperatorInJoin) && this.m_currentJoinType == AEJoin.AEJoinType.INNER_JOIN) {
            this.m_launchExtraWhereClause = JoinState.TRIGGER == this.m_innerJoinState && !this.m_subqueryState.equals("TRIGGER") ? true : (this.m_subqueryState.equals("TRIGGER") && JoinState.TRIGGER != this.m_innerJoinState ? false : false);
        }
        String string = iterator.next().acceptVisitor(this);
        String string2 = iterator.next().acceptVisitor(this);
        return stringBuilder.append(string).append((Object)aEComparison.getComparisonOp()).append(string2).toString();
    }

    @Override
    public String visit(AEConcat aEConcat) throws ErrorException {
        Stack<AEValueExpr> stack;
        AEConcat aEConcat2;
        boolean bl = this.m_processingBinaryValue;
        this.m_processingBinaryValue = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONCAT(");
        if (aEConcat.getLeftOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getLeftOperand();
            stack = new Stack<AEValueExpr>();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            boolean bl2 = true;
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(aEValueExpr.acceptVisitor(this));
                bl2 = false;
            }
        } else {
            stringBuilder.append(aEConcat.getLeftOperand().acceptVisitor(this));
        }
        if (aEConcat.getRightOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getRightOperand();
            stack = new Stack();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                stringBuilder.append(", ").append(aEValueExpr.acceptVisitor(this));
            }
        } else {
            stringBuilder.append(", ").append(aEConcat.getRightOperand().acceptVisitor(this));
        }
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CONCAT, stringBuilder.toString(), stringBuilder.toString(), null, aEConcat.getColumn()));
        this.m_processingBinaryValue = bl;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
        String string = "COUNT(*)";
        this.saveFullColumnRef(new SelectNode(SelectType.COUNTSTAR, string, string, null, aECountStarAggrFn.getColumn()));
        return string;
    }

    @Override
    public String visit(AECrossJoin aECrossJoin) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IAENode> iterator = aECrossJoin.getChildItr();
        IAENode iAENode = iterator.next();
        IAENode iAENode2 = iterator.next();
        if (iAENode2 instanceof AEJoin || iAENode2 instanceof AECrossJoin) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HYC00", "Driver not capable", "Impala only supports left associative joins"});
            throw errorException;
        }
        stringBuilder.append(iAENode.acceptVisitor(this));
        stringBuilder.append(" CROSS JOIN ");
        stringBuilder.append(iAENode2.acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEDelete aEDelete) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        this.m_processingDeleteTable = true;
        stringBuilder.append(aEDelete.getTable().acceptVisitor(this));
        AEBooleanExpr aEBooleanExpr = aEDelete.getCondition();
        if (!(aEBooleanExpr instanceof AEBooleanTrue)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(aEBooleanExpr.acceptVisitor(this));
        }
        this.m_processingDeleteTable = false;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEDistinct aEDistinct) throws ErrorException {
        this.m_hasDistinct = true;
        return aEDistinct.getOperand().acceptVisitor(this);
    }

    @Override
    public String visit(AEDivide aEDivide) throws ErrorException {
        boolean bl = this.m_processingBinaryValue;
        this.m_processingBinaryValue = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEDivide.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" / ");
        stringBuilder.append(aEDivide.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString(), stringBuilder.toString(), null, aEDivide.getColumn()));
        this.m_processingBinaryValue = bl;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
        String string = null;
        String string2 = aEGeneralAggrFn.getSetQuantifier().name();
        this.m_processingGeneralAggrFn = true;
        string = string2.equalsIgnoreCase("ALL") ? aEGeneralAggrFn.getAggrFnId().name() + "(" + aEGeneralAggrFn.getOperand().acceptVisitor(this) + ")" : aEGeneralAggrFn.getAggrFnId().name() + "(" + aEGeneralAggrFn.getSetQuantifier().name() + " " + aEGeneralAggrFn.getOperand().acceptVisitor(this) + ")";
        this.m_processingGeneralAggrFn = false;
        return string;
    }

    @Override
    public String visit(AEInPredicate aEInPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((AEValueExpr)aEInPredicate.getLeftOperand().getChild(0)).getTypeMetadata().isBooleanType();
        stringBuilder.append("(");
        stringBuilder.append(((AEValueExpr)aEInPredicate.getLeftOperand().getChild(0)).acceptVisitor(this));
        stringBuilder.append(" IN ");
        Iterator<? extends IAENode> iterator = aEInPredicate.getRightOperand().getChildItr();
        if (iterator.hasNext()) {
            if (bl) {
                String string = iterator.next().acceptVisitor(this);
                stringBuilder.append("(").append(this.getInPredicatevalue(string));
                while (iterator.hasNext()) {
                    string = iterator.next().acceptVisitor(this);
                    stringBuilder.append(", ").append(this.getInPredicatevalue(string));
                }
            } else {
                stringBuilder.append("(").append(iterator.next().acceptVisitor(this));
                while (iterator.hasNext()) {
                    stringBuilder.append(", ").append(iterator.next().acceptVisitor(this));
                }
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append("( )");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEInsert aEInsert) throws ErrorException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO TABLE ");
        this.m_processingInsertTable = true;
        AETable aETable = aEInsert.getTable();
        String string = aETable.acceptVisitor(this);
        stringBuilder.append(string);
        this.m_dmlTargetTableMetadata = aETable;
        AEValueExprList aEValueExprList = aEInsert.getInsertColumns();
        if (0 != aEValueExprList.getNumChildren()) {
            int n;
            object = new ArrayList();
            Iterator iterator = aEValueExprList.getChildItr();
            while (iterator.hasNext()) {
                AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
                if (!(aEValueExpr instanceof AEColumnReference)) continue;
                n = ((AEColumnReference)aEValueExpr).getColumnNum();
                ((ArrayList)object).add(n);
            }
            this.m_orderMap = new HashMap();
            int n2 = aETable.getColumnCount();
            for (n = 0; n < n2; ++n) {
                this.m_orderMap.put(n, ((ArrayList)object).indexOf(n));
            }
        }
        this.m_processingInsertTable = false;
        this.m_processingInsertExpression = true;
        object = aEInsert.getRelationalExpr().acceptVisitor(this);
        this.m_processingInsertExpression = false;
        stringBuilder.append((String)object);
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEJoin aEJoin) throws ErrorException {
        this.m_innerJoinState = JoinState.TRIGGER;
        if (!this.m_subqueryState.equals("NULL")) {
            this.m_subqueryState = "IGNORE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = aEJoin.getLeftOperand().acceptVisitor(this);
        String string2 = aEJoin.getRightOperand().acceptVisitor(this);
        AEJoin.AEJoinType aEJoinType = this.m_currentJoinType = aEJoin.getJoinType();
        String string3 = aEJoin.getJoinCondition().acceptVisitor(this);
        JoinNode joinNode = null;
        boolean bl = false;
        if (null != this.m_joinsForSyntheticProjection) {
            for (JoinNode joinNode2 : this.m_joinsForSyntheticProjection) {
                if (joinNode2.getChild() != aEJoin) continue;
                bl = true;
                joinNode = joinNode2;
                stringBuilder.append(joinNode.getWrapperPrefix());
                break;
            }
        }
        switch (aEJoinType) {
            case INNER_JOIN: {
                if (this.m_launchExtraWhereClause) {
                    this.m_innerJoinState = JoinState.IGNORE;
                    stringBuilder.append(string).append(" CROSS JOIN ").append(string2).append(" WHERE ( ").append(string3).append(" )").toString();
                    break;
                }
                this.m_innerJoinState = JoinState.IGNORE;
                stringBuilder.append(string).append(" JOIN ").append(string2).append(" ON ( ").append(string3).append(" )").toString();
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.m_innerJoinState = JoinState.IGNORE;
                Object object = " LEFT JOIN ";
                if (!this.m_serverVersionUtils.hqlSupportsDefaultOuterJoin(this.m_serverVersion)) {
                    object = " LEFT OUTER JOIN ";
                }
                stringBuilder.append(string).append((String)object).append(string2).append(" ON ( ").append(string3).append(" )").toString();
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.m_innerJoinState = JoinState.IGNORE;
                Object object = " RIGHT JOIN ";
                if (!this.m_serverVersionUtils.hqlSupportsDefaultOuterJoin(this.m_serverVersion)) {
                    object = " RIGHT OUTER JOIN ";
                }
                stringBuilder.append(string).append((String)object).append(string2).append(" ON ( ").append(string3).append(" )").toString();
                break;
            }
            default: {
                Object object = " FULL JOIN ";
                if (!this.m_serverVersionUtils.hqlSupportsDefaultOuterJoin(this.m_serverVersion)) {
                    object = " FULL OUTER JOIN ";
                }
                this.m_innerJoinState = JoinState.IGNORE;
                stringBuilder.append(string).append((String)object).append(string2).append(" ON ( ").append(string3).append(" )").toString();
            }
        }
        if (bl) {
            stringBuilder.append(joinNode.getWrapperSuffix());
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AELikePredicate aELikePredicate) throws ErrorException {
        String string = null;
        String string2 = null;
        if (aELikePredicate.hasEscapeChar()) {
            boolean bl;
            AEValueExpr aEValueExpr = aELikePredicate.getEscapeChar();
            if (!(aEValueExpr instanceof AELiteral) || ((AELiteral)aEValueExpr).getStringValue().length() != 1) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Invalid escape character. Only one character string literals are supported"});
                throw errorException;
            }
            char c = ((AELiteral)aEValueExpr).getStringValue().charAt(0);
            boolean bl2 = bl = c != '\\';
            if (aELikePredicate.getRightOperand() instanceof AELiteral) {
                string2 = ((AELiteral)aELikePredicate.getRightOperand()).getStringValue();
                if (bl) {
                    string2 = this.replaceEscapeChar(string2, c);
                }
                string2 = "'" + HiveQLAENodeVisitor.escapeStringLiteral(string2, false) + "'";
            }
        }
        string = aELikePredicate.getLeftOperand().acceptVisitor(this);
        if (null == string2) {
            string2 = aELikePredicate.getRightOperand().acceptVisitor(this);
        }
        return string + " LIKE " + string2;
    }

    @Override
    public String visit(AELiteral aELiteral) throws ErrorException {
        String string = "";
        switch (aELiteral.getLiteralType()) {
            case CHARSTR: {
                string = "'" + HiveQLAENodeVisitor.escapeStringLiteral(aELiteral.getStringValue(), true) + "'";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string, string, null, aELiteral.getColumn()));
                return string;
            }
            case DECIMAL: 
            case APPROXNUM: 
            case USINT: 
            case SINT: {
                string = aELiteral.getStringValue();
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string, string, null, aELiteral.getColumn()));
                return aELiteral.getStringValue();
            }
            case NULL: {
                string = "NULL";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string, string, null, aELiteral.getColumn()));
                return string;
            }
            case DATE: {
                string = "CAST('" + aELiteral.getStringValue() + "' AS DATE)";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string, string, null, aELiteral.getColumn()));
                return string;
            }
            case TIMESTAMP: {
                string = "CAST('" + aELiteral.getStringValue() + "' AS TIMESTAMP)";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string, string, null, aELiteral.getColumn()));
                return string;
            }
            case DATATYPE: {
                return "";
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Literal type not supported: " + aELiteral.getLiteralType().name()});
        throw errorException;
    }

    @Override
    public String visit(AEMultiply aEMultiply) throws ErrorException {
        boolean bl = this.m_processingBinaryValue;
        this.m_processingBinaryValue = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEMultiply.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" * ");
        stringBuilder.append(aEMultiply.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString(), stringBuilder.toString(), null, aEMultiply.getColumn()));
        this.m_processingBinaryValue = bl;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENot aENot) throws ErrorException {
        return "(NOT " + aENot.getOperand().acceptVisitor(this) + ")";
    }

    @Override
    public String visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(EXISTS ");
        stringBuilder.append(aEExistsPredicate.getOperand().acceptVisitor(this));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENull aENull) throws ErrorException {
        if (this.m_processingSelectList) {
            return "CAST(NULL AS STRING)";
        }
        return "NULL";
    }

    @Override
    public String visit(AENullPredicate aENullPredicate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(aENullPredicate.getOperand().acceptVisitor(this));
        stringBuilder.append(" IS NULL)");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENegate aENegate) throws ErrorException {
        this.m_processingNegateFn = true;
        String string = "-(" + this.visitChildren(aENegate) + ")";
        this.m_processingNegateFn = false;
        this.saveFullColumnRef(new SelectNode(SelectType.GNEGATE, "GNEGATE TEMP RESULT", string, null, aENegate.getColumn()));
        return string;
    }

    @Override
    public String visit(AEOr aEOr) throws ErrorException {
        this.m_containORoperatorInJoin = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        Iterator<IAENode> iterator = aEOr.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        stringBuilder.append(string).append(" OR ");
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.append(" )").toString();
    }

    @Override
    public String visit(AEProject aEProject) throws ErrorException {
        Object object;
        Object object2;
        if (this.m_processingInsertExpression) {
            object2 = new TableAliasGenerator(aEProject);
            this.m_generatedTableAlias = ((TableAliasGenerator)object2).getGeneratedTableAlias();
            object = new ChildJoinPredicateAnalyzer(aEProject, this.m_generatedTableAlias, this.m_serverVersionUtils, this.m_serverVersion, this.m_settings);
            this.m_joinsForSyntheticProjection = ((ChildJoinPredicateAnalyzer)object).getSyntheticJoinProjections();
        }
        object2 = new StringBuilder("SELECT ");
        if (this.m_hasDistinct) {
            ((StringBuilder)object2).append("DISTINCT ");
            this.m_hasDistinct = false;
        }
        object = aEProject.getChildItr();
        String string = object.next().acceptVisitor(this);
        SelectListAnalyzer selectListAnalyzer = new SelectListAnalyzer(aEProject);
        this.m_processingSelectList = true;
        String string2 = ((IAENode)object.next()).acceptVisitor(this);
        this.m_processingSelectList = false;
        this.m_canReplaceListWithStar = selectListAnalyzer.canReplaceListWithStar();
        if (!this.m_hasDistinct && this.m_canReplaceListWithStar && null == this.m_joinsForSyntheticProjection && !this.m_isBuildSubQueryForOrderBy) {
            string2 = "*";
        }
        return ((StringBuilder)object2).append(string2).append(" FROM ").append(string).toString();
    }

    @Override
    public String visit(AEProxyColumn aEProxyColumn) throws ErrorException {
        if (aEProxyColumn.getResolvedQueryScope().hasAggregate()) {
            return ((AEValueExpr)aEProxyColumn.getResolvedQueryScope().getAggregateList().getChild(aEProxyColumn.getColumnNumber())).acceptVisitor(this);
        }
        return "";
    }

    @Override
    public String visit(AEParameter aEParameter) throws ErrorException {
        ParameterInputValue parameterInputValue = this.m_batchMode && this.m_processingInsertValue && this.m_processingInsertExpression ? this.m_currentContext.getInputs().get(aEParameter.getIndex() - 1) : this.m_params.getInputs().get(aEParameter.getIndex() - 1);
        DataWrapper dataWrapper = null;
        try {
            dataWrapper = parameterInputValue.isPushed() ? this.m_executor.getPushedParam(1, aEParameter.getIndex()).getData() : parameterInputValue.getData();
            if (dataWrapper.isNull()) {
                if (this.m_processingSelectList) {
                    return "CAST(NULL AS STRING)";
                }
                return "NULL";
            }
            switch (dataWrapper.getType()) {
                case -5: {
                    return dataWrapper.getBigInt().toString();
                }
                case 3: {
                    return dataWrapper.getDecimal().toString();
                }
                case 8: {
                    return String.valueOf(dataWrapper.getDouble());
                }
                case 6: {
                    return String.valueOf(dataWrapper.getFloat());
                }
                case 4: {
                    return String.valueOf(dataWrapper.getInteger());
                }
                case -6: {
                    return String.valueOf(dataWrapper.getTinyInt());
                }
                case 2: {
                    return dataWrapper.getNumeric().toString();
                }
                case 7: {
                    return String.valueOf(dataWrapper.getReal());
                }
                case 5: {
                    return String.valueOf(dataWrapper.getSmallInt());
                }
                case -7: 
                case 16: {
                    return String.valueOf(dataWrapper.getBoolean());
                }
                case -2: {
                    return HiveQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getBinary()), true);
                }
                case -3: {
                    return "'" + HiveQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getVarBinary()), true) + "'";
                }
                case -4: {
                    return "'" + HiveQLAENodeVisitor.escapeStringLiteral(new String(dataWrapper.getLongVarBinary()), true) + "'";
                }
                case -8: 
                case 1: {
                    return "'" + HiveQLAENodeVisitor.escapeStringLiteral(dataWrapper.getChar(), true) + "'";
                }
                case -10: 
                case -1: {
                    return "'" + HiveQLAENodeVisitor.escapeStringLiteral(dataWrapper.getLongVarChar(), true) + "'";
                }
                case -9: 
                case 12: {
                    return "'" + HiveQLAENodeVisitor.escapeStringLiteral(dataWrapper.getVarChar(), true) + "'";
                }
                case 91: {
                    return dataWrapper.getDate().toString();
                }
                case 93: {
                    return "CAST( '" + dataWrapper.getTimestamp().toString() + "' AS TIMESTAMP)";
                }
                case -11: 
                case 92: {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR_PARAMETER_DATATYPE_NOT_SUPPORTED.name(), new String[]{"42000", "Syntax error or access violation", "Parameter type not supported"});
                    throw errorException;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR_PARAMETER_DATATYPE_NOT_SUPPORTED.name(), new String[]{"42000", "Syntax error or access violation", "Interval types are not supported"});
                    throw errorException;
                }
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR_PARAMETER_DATATYPE_NOT_SUPPORTED.name(), new String[]{"HY000", "General error", "Unexpected datatype returned from parameter"});
            throw errorException;
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR_PARAMETER_DATATYPE_NOT_SUPPORTED.name(), new String[]{"HY000", "General error", "Unexpected error accessing parameter data"}, (Throwable)exception);
            throw errorException;
        }
    }

    @Override
    public String visit(AEQuery aEQuery) throws ErrorException {
        TableAliasGenerator tableAliasGenerator = new TableAliasGenerator(aEQuery);
        this.m_generatedTableAlias = tableAliasGenerator.getGeneratedTableAlias();
        ChildJoinPredicateAnalyzer childJoinPredicateAnalyzer = new ChildJoinPredicateAnalyzer(aEQuery, this.m_generatedTableAlias, this.m_serverVersionUtils, this.m_serverVersion, this.m_settings);
        this.m_joinsForSyntheticProjection = childJoinPredicateAnalyzer.getSyntheticJoinProjections();
        return this.visitChildren(aEQuery);
    }

    @Override
    public String visit(AERename aERename) throws ErrorException {
        this.m_processingRename = true;
        String string = aERename.getOperand().acceptVisitor(this);
        String string2 = aERename.getName();
        if (!(null == this.m_settings || this.m_settings.m_automaticColumnRename || this.m_processingOrderBySubquery || this.m_processingOrderBySelectList || this.m_processingOrderByFromClause || this.m_processingOrderBySortList || this.m_processingOrderByList || aERename.getParent().getParent().getParent() instanceof AESubQuery || !string2.toUpperCase().startsWith(EXPR_COL_NAME) || !string2.substring(EXPR_COL_NAME.length()).matches("^\\d+$"))) {
            return string;
        }
        String string3 = " ";
        string3 = this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, string3).equals("` `") ? "` `" : "` ";
        if (!string.contains(string3)) {
            string = string + " " + this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aERename.getLabel());
        }
        this.m_processingRename = false;
        if (null == this.m_columnFullNameRef.get(this.m_currentColumnNumber) || null != this.m_columnFullNameRef.get(this.m_currentColumnNumber) && !this.m_columnFullNameRef.get(this.m_currentColumnNumber).getSubqueryColumnName().contains(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aERename.getLabel()))) {
            this.saveFullColumnRef(new SelectNode(SelectType.RENAME, this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aERename.getLabel()), this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aERename.getLabel()), null, aERename.getColumn()));
        }
        return string;
    }

    @Override
    public String visit(AESearchedCase aESearchedCase) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("(CASE ");
        stringBuilder.append((String)this.visit(aESearchedCase.getWhenClauseList()));
        AEValueExpr aEValueExpr = aESearchedCase.getElseClause();
        if (null != aEValueExpr) {
            stringBuilder.append(" ELSE ").append(aEValueExpr.acceptVisitor(this));
        }
        stringBuilder.append(" END)");
        this.saveFullColumnRef(new SelectNode(SelectType.SEARCH, stringBuilder.toString(), stringBuilder.toString(), null, aESearchedCase.getColumn()));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESimpleCase aESimpleCase) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("(CASE ");
        stringBuilder.append(aESimpleCase.getCaseOperand().acceptVisitor(this));
        stringBuilder.append((String)this.visit(aESimpleCase.getWhenClauseList()));
        AEValueExpr aEValueExpr = aESimpleCase.getElseOperand();
        stringBuilder.append(" ELSE ").append(aEValueExpr.acceptVisitor(this));
        stringBuilder.append(" END)");
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
        return " WHEN " + aESimpleWhenClause.getWhenExpression().acceptVisitor(this) + " THEN " + aESimpleWhenClause.getThenExpression().acceptVisitor(this);
    }

    @Override
    public String visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WHEN ").append(aESearchedWhenClause.getWhenCondition().acceptVisitor(this));
        stringBuilder.append(" THEN ").append(aESearchedWhenClause.getThenExpression().acceptVisitor(this));
        this.saveFullColumnRef(new SelectNode(SelectType.SEARCH, stringBuilder.toString(), stringBuilder.toString(), null, null));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEScalarFn aEScalarFn) throws ErrorException {
        boolean bl = this.m_processingScalarFn;
        this.m_processingScalarFn = true;
        String string = new ScalarFunctionTranslator(this, ScalarFunctionTranslator.SERVER_TYPE.HIVE, this.m_serverVersionUtils, this.m_serverVersion).translateScalarFunction(aEScalarFn);
        this.m_processingScalarFn = bl;
        this.saveFullColumnRef(new SelectNode(SelectType.RENAME, string, string, null, aEScalarFn.getColumn()));
        return string;
    }

    @Override
    public String visit(AESelect aESelect) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IAENode> iterator = aESelect.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        if (this.m_launchExtraWhereClause) {
            stringBuilder.append(string);
            if (aESelect.getOperand() instanceof AEAggregate) {
                stringBuilder.append(" HAVING ").append(iterator.next().acceptVisitor(this));
            } else {
                stringBuilder.append(" AND ( ").append(iterator.next().acceptVisitor(this)).append(" )");
            }
            this.m_launchExtraWhereClause = false;
        } else {
            stringBuilder.append(string);
            if (aESelect.getOperand() instanceof AEAggregate) {
                stringBuilder.append(" HAVING ");
            } else {
                stringBuilder.append(" WHERE ");
            }
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESetClauseList aESetClauseList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = aESetClauseList.getChildItr();
        this.m_processingUpdateColumnSelection = true;
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(((AESetClause)iterator.next()).acceptVisitor(this));
        }
        this.m_processingUpdateColumnSelection = false;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESetClause aESetClause) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEColumnReference aEColumnReference = aESetClause.getLeftOperand();
        stringBuilder.append(aEColumnReference.acceptVisitor(this));
        stringBuilder.append(" = ");
        AEValueExpr aEValueExpr = aESetClause.getRightOperand();
        stringBuilder.append(aEValueExpr.acceptVisitor(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESort aESort) throws ErrorException {
        Object object;
        boolean bl = false;
        if (this.m_hasDistinct) {
            bl = true;
        }
        OrderBySubqueryAnalyzer orderBySubqueryAnalyzer = new OrderBySubqueryAnalyzer(aESort, this.m_serverVersionUtils, this.m_serverVersion, this.m_settings.m_supportsDefaultOrderBy);
        this.m_processingOrderNode = true;
        StringBuilder stringBuilder = new StringBuilder();
        AEProject aEProject = (AEProject)aESort.getOperand();
        if (this.m_isBuildSubQueryForOrderByFromAETop || this.m_isBuildSubQueryForOrderByFromAESort) {
            stringBuilder.append(aEProject.acceptVisitor(this));
            this.m_isBuildSubQueryForOrderByFromAETop = false;
        } else {
            this.m_isBuildSubQueryForOrderBy = orderBySubqueryAnalyzer.isBuildOrderBySubqueryFromAESort();
            stringBuilder.append(this.visitProject(aEProject, aESort.getColumnCount()));
        }
        stringBuilder.append(" ORDER BY ");
        boolean bl2 = true;
        this.m_processingOrderByList = true;
        for (AESortSpec aESortSpec : aESort.getSortSpecs()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            AEValueExpr aEValueExpr = (AEValueExpr)aEProject.getProjectionList().getChild(aESortSpec.getColumnNumber());
            if (!(aEValueExpr instanceof AERename)) {
                stringBuilder.append(aEValueExpr.acceptVisitor(this));
            } else {
                stringBuilder.append(aEValueExpr.getName());
            }
            stringBuilder.append(aESortSpec.isAscending() ? " ASC" : " DESC");
        }
        this.m_processingOrderByList = false;
        boolean bl3 = this.m_isBuildSubQueryForOrderByFromAESort = orderBySubqueryAnalyzer.isBuildOrderBySubqueryFromAESort() && this.m_processingOrderNode && !this.m_canReplaceListWithStar;
        if (this.m_hasSubquery) {
            if (!this.m_subqueryState.equals("NULL") && this.m_isBuildSubQueryForOrderByFromAESort) {
                object = null;
                this.m_processingOrderBySubquery = true;
                object = this.subqueryBuildHelperVersion13(aESort, bl);
                this.m_processingOrderBySubquery = false;
                return object;
            }
            return stringBuilder.toString();
        }
        if (this.m_isBuildSubQueryForOrderByFromAESort) {
            object = null;
            this.m_processingOrderBySubquery = true;
            object = this.subqueryBuildHelperVersion13(aESort, bl);
            this.m_processingOrderBySubquery = false;
            return object;
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESubtract aESubtract) throws ErrorException {
        boolean bl = this.m_processingBinaryValue;
        this.m_processingBinaryValue = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aESubtract.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" - ");
        stringBuilder.append(aESubtract.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString(), stringBuilder.toString(), null, aESubtract.getColumn()));
        this.m_processingBinaryValue = bl;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AESubQuery aESubQuery) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(1000);
        this.m_hasSubquery = true;
        this.m_subqueryState = "TRIGGER";
        if (JoinState.NULL != this.m_innerJoinState) {
            this.m_innerJoinState = JoinState.IGNORE;
        }
        if (aESubQuery.hasDerivedColumnList()) {
            IAENode iAENode;
            AETreeWalker aETreeWalker = new AETreeWalker(aESubQuery);
            AEProject aEProject = null;
            int n = 0;
            while (aETreeWalker.hasNext()) {
                iAENode = aETreeWalker.next();
                if (iAENode instanceof AEProject) {
                    aEProject = (AEProject)iAENode;
                    break;
                }
                if (!(iAENode instanceof AESort)) continue;
                n = ((AESort)iAENode).getColumnCount();
            }
            if (null == aEProject) {
                throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"HY000", "General error", "AETree structure"});
            }
            iAENode = aEProject.getProjectionList();
            Iterator iterator = ((AbstractAENodeList)iAENode).getChildItr();
            int n2 = 0;
            n2 = n > 0 ? n : ((AbstractAENodeList)iAENode).getNumChildren();
            assert (n2 == aESubQuery.getColumnCount());
            for (int i = 0; i < n2; ++i) {
                AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
                String string = aESubQuery.getColumn(i).getName();
                if (aEValueExpr instanceof AERename) {
                    ((AERename)aEValueExpr).setName(string);
                    continue;
                }
                AERename aERename = new AERename(string, aEValueExpr);
                ((AbstractAENodeList)iAENode).replaceNode(aERename, i);
            }
        }
        stringBuilder.append("(");
        stringBuilder.append(aESubQuery.getOperand().acceptVisitor(this));
        stringBuilder.append(")");
        if (aESubQuery.hasCorrelationName()) {
            stringBuilder.append(" ");
            stringBuilder.append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aESubQuery.getTableName()));
        }
        this.m_subqueryState = "NULL";
        if (JoinState.IGNORE == this.m_innerJoinState) {
            this.m_innerJoinState = JoinState.TRIGGER;
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETableConstructor aETableConstructor) throws ErrorException {
        Iterator<Object> iterator;
        StringBuilder stringBuilder = new StringBuilder(" VALUES ");
        this.m_processingInsertValue = true;
        this.m_insertValues = new ArrayList();
        if (this.m_batchMode) {
            iterator = this.m_batchparams.contextIterator();
            while (iterator.hasNext()) {
                this.m_currentContext = (ExecutionContext)iterator.next();
                Iterator<? extends IAENode> iterator2 = aETableConstructor.getChildItr();
                while (iterator2.hasNext()) {
                    iterator2.next().acceptVisitor(this);
                }
            }
        } else {
            iterator = aETableConstructor.getChildItr();
            while (iterator.hasNext()) {
                ((IAENode)iterator.next()).acceptVisitor(this);
            }
        }
        boolean bl = null != this.m_orderMap;
        boolean bl2 = true;
        for (ArrayList<String> arrayList : this.m_insertValues) {
            if (bl2) {
                stringBuilder.append(" ( ");
                bl2 = false;
            } else {
                stringBuilder.append(" , ( ");
            }
            boolean bl3 = true;
            int n = bl ? this.m_orderMap.size() : arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuilder.append(" , ");
                }
                int n2 = bl ? this.m_orderMap.get(i) : i;
                if (-1 != n2) {
                    String string = arrayList.get(n2);
                    if (this.m_dmlTargetTableMetadata != null && n2 < this.m_dmlTargetTableMetadata.getColumnCount()) {
                        IColumn iColumn = this.m_dmlTargetTableMetadata.getColumn(n2);
                        switch (iColumn.getTypeMetadata().getType()) {
                            case 16: {
                                string = string.equals("0") ? "FALSE" : "TRUE";
                            }
                        }
                    }
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder.append(" NULL ");
            }
            stringBuilder.append(" ) ");
        }
        this.m_processingInsertValue = false;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETable aETable) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEQTableName aEQTableName = aETable.getBaseQTableName();
        if (aEQTableName.hasSchemaName()) {
            stringBuilder.append('`').append(aEQTableName.getSchemaName()).append("`.");
        }
        stringBuilder.append('`').append(aEQTableName.getTableName()).append('`');
        if (this.m_processingInsertTable || this.m_processingDeleteTable || this.m_processingUpdateTable) {
            return stringBuilder.toString();
        }
        if (aETable.hasCorrelationName()) {
            stringBuilder.append(' ').append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, aETable.getCorrelationName()));
        } else if (this.m_generatedTableAlias.containsKey(aETable)) {
            stringBuilder.append(' ').append(this.m_serverVersionUtils.supportsBackTickedAliases(this.m_serverVersion, this.m_generatedTableAlias.get(aETable)));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AETop aETop) throws ErrorException {
        if (aETop.isPercent()) {
            // empty if block
        }
        Iterator<IAENode> iterator = aETop.getChildItr();
        String string = iterator.next().acceptVisitor(this);
        String string2 = iterator.next().acceptVisitor(this);
        String string3 = null;
        if (iterator.hasNext()) {
            string3 = iterator.next().acceptVisitor(this);
        }
        String string4 = null == string3 ? "LIMIT " + string2 : "LIMIT " + string3 + "," + string2;
        String string5 = string + " " + string4;
        if (this.m_isBuildSubQueryForOrderByFromAESort) {
            this.m_isBuildSubQueryForOrderByFromAESort = false;
            return string5;
        }
        OrderBySubqueryAnalyzer orderBySubqueryAnalyzer = new OrderBySubqueryAnalyzer(aETop, this.m_serverVersionUtils, this.m_serverVersion, this.m_settings.m_supportsDefaultOrderBy);
        this.m_isBuildSubQueryForOrderByFromAETop = orderBySubqueryAnalyzer.isBuildOrderBySubqueryFromAESort();
        if (this.m_isBuildSubQueryForOrderByFromAETop) {
            this.m_isBuildSubQueryForOrderBy = this.m_isBuildSubQueryForOrderByFromAETop;
        }
        boolean bl = this.m_isBuildSubQueryForOrderByFromAETop = this.m_isBuildSubQueryForOrderByFromAETop && this.m_processingOrderNode && !this.m_canReplaceListWithStar;
        if (this.m_hasSubquery) {
            if (!this.m_subqueryState.equals("NULL") && this.m_isBuildSubQueryForOrderByFromAETop) {
                this.m_processingOrderBySubquery = true;
                string5 = this.subqueryBuildHelperVersion12(aETop, string4);
                this.m_processingOrderBySubquery = false;
                return string5;
            }
            return string5;
        }
        if (this.m_isBuildSubQueryForOrderByFromAETop) {
            this.m_processingOrderBySubquery = true;
            string5 = this.subqueryBuildHelperVersion12(aETop, string4);
            this.m_processingOrderBySubquery = false;
            return string5;
        }
        return string5;
    }

    @Override
    public String visit(AEUpdate aEUpdate) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("UPDATE ");
        this.m_processingUpdateTable = true;
        AETable aETable = aEUpdate.getTable();
        stringBuilder.append(aETable.acceptVisitor(this));
        stringBuilder.append(" SET ");
        AESetClauseList aESetClauseList = aEUpdate.getSetClauses();
        stringBuilder.append(aESetClauseList.acceptVisitor(this));
        AEBooleanExpr aEBooleanExpr = aEUpdate.getUpdateCondition();
        if (!(aEBooleanExpr instanceof AEBooleanTrue)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(aEBooleanExpr.acceptVisitor(this));
        }
        this.m_processingUpdateTable = false;
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEUnion aEUnion) throws ErrorException {
        String string = aEUnion.getLeftOperand().acceptVisitor(this);
        String string2 = aEUnion.getRightOperand().acceptVisitor(this);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" ");
        if (aEUnion.isAllOptPresent() || this.m_settings.m_convertUnionToUnionAll) {
            stringBuilder.append("UNION ALL");
        } else {
            stringBuilder.append("UNION");
        }
        stringBuilder.append(" ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEValueExprList aEValueExprList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator iterator = aEValueExprList.getChildItr();
        if (this.m_processingInsertValue && this.m_processingInsertExpression) {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                arrayList.add(((AEValueExpr)iterator.next()).acceptVisitor(this));
            }
            this.m_insertValues.add(arrayList);
        } else {
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(((AEValueExpr)iterator.next()).acceptVisitor(this));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AENodeList<? extends IAENode> aENodeList) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = aENodeList.getChildItr();
        if (iterator.hasNext()) {
            stringBuilder.append(((IAENode)iterator.next()).acceptVisitor(this));
            while (iterator.hasNext()) {
                stringBuilder.append(" ").append(((IAENode)iterator.next()).acceptVisitor(this));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String defaultVisit(IAENode iAENode) throws ErrorException {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{"42000", "Syntax error or access violation", iAENode.getLogString() + " is not supported"});
        throw errorException;
    }

    protected String findJoinNodeReference(AEColumnReference aEColumnReference, IColumn iColumn, JoinNode joinNode) {
        if (null != aEColumnReference.getParent() && aEColumnReference.getParent() instanceof AEValueExprList && null != aEColumnReference.getParent().getParent() && aEColumnReference.getParent().getParent() instanceof AEBooleanExpr) {
            String string;
            if (this.findNodeWithJoinRef(aEColumnReference, joinNode.getParent(), AEJoin.class)) {
                String string2 = this.getSyntheticColumnReferenceName(aEColumnReference, iColumn, joinNode);
                if (null != string2) {
                    return string2;
                }
            } else if (this.findNodeWithJoinRef(aEColumnReference, joinNode.getParent(), AESelect.class) && null != (string = this.getSyntheticColumnReferenceName(aEColumnReference, iColumn, joinNode))) {
                return string;
            }
        } else {
            AEValueExpr aEValueExpr = this.findAEValueExpressionList(aEColumnReference);
            if (null != aEValueExpr.getParent() && aEValueExpr.getParent() instanceof AEValueExprList && null != aEValueExpr.getParent().getParent() && aEValueExpr.getParent().getParent() instanceof AEAggregate) {
                String string;
                AEAggregate aEAggregate = (AEAggregate)aEValueExpr.getParent().getParent();
                if (null != aEColumnReference.getParent().getParent() && aEAggregate.getOperand() instanceof AEJoin && aEAggregate.getOperand() == joinNode.getParent()) {
                    String string3 = this.getSyntheticColumnReferenceName(aEColumnReference, iColumn, joinNode);
                    if (null != string3) {
                        return string3;
                    }
                } else if (null != aEAggregate.getOperand() && aEAggregate.getOperand() instanceof AESelect && null != ((AESelect)aEAggregate.getOperand()).getOperand() && ((AESelect)aEAggregate.getOperand()).getOperand() == joinNode.getParent() && null != (string = this.getSyntheticColumnReferenceName(aEColumnReference, iColumn, joinNode))) {
                    return string;
                }
            }
        }
        return null;
    }

    protected boolean findNodeWithJoinRef(AEColumnReference aEColumnReference, AEJoin aEJoin, Class<? extends AERelationalExpr> clazz) {
        IAENode iAENode = aEColumnReference.getParent();
        if (!(iAENode instanceof AEValueExprList)) {
            return false;
        }
        for (iAENode = iAENode.getParent(); null != iAENode; iAENode = iAENode.getParent()) {
            if (clazz.isInstance(iAENode)) {
                if (clazz.equals(AEJoin.class)) {
                    return iAENode == aEJoin;
                }
                return ((AEUnaryRelationalExpr)AEUnaryRelationalExpr.class.cast(iAENode)).getOperand() == aEJoin;
            }
            if (!(iAENode instanceof AEBooleanExpr)) break;
        }
        return false;
    }

    protected String getSyntheticColumnReferenceName(AEColumnReference aEColumnReference, IColumn iColumn, JoinNode joinNode) {
        for (JoinColumnNode joinColumnNode : joinNode.getPredicateColumns()) {
            if (joinColumnNode.getColumn() != iColumn) continue;
            this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, joinColumnNode.getColumnReferenceName(), joinColumnNode.getColumnReferenceName(), aEColumnReference, aEColumnReference.getColumn()));
            return joinColumnNode.getColumnReferenceName();
        }
        return null;
    }

    private String buildQualifiedColumnName(AEColumnReference aEColumnReference, String string) {
        String string2 = aEColumnReference.getNamedRelationalExpr().getCorrelationName();
        IColumn iColumn = aEColumnReference.getNamedRelationalExpr().getBaseColumn(aEColumnReference.getColumnNum());
        String string3 = null;
        if (!(null == this.m_selectConcatColumnRef || this.m_processingRename || this.m_processingScalarFn || this.m_processingNegateFn || this.m_processingGeneralAggrFn || this.m_processingBinaryValue)) {
            for (IColumn object2 : this.m_selectConcatColumnRef) {
                if (object2 != aEColumnReference.getColumn()) continue;
                if (null != string2 && string2.length() > 0) {
                    string3 = "`" + string2 + iColumn.getName() + "`";
                    break;
                }
                string3 = "`" + string + iColumn.getName() + "`";
                break;
            }
        }
        Object object3 = null;
        if (null != this.m_columnFullNameRefPersisting && !this.m_processingOrderBySubquery && (!this.m_processingScalarFn && !this.m_processingNegateFn && !this.m_processingGeneralAggrFn && !this.m_processingRename || this.m_hasSubquery && this.m_processingOrderBySelectList)) {
            for (SelectNode selectNode : this.m_columnFullNameRefPersisting) {
                if (null == selectNode || aEColumnReference.getColumn() != selectNode.getOriginalColumnMetadata()) continue;
                object3 = selectNode.getSubqueryColumnName();
                break;
            }
        }
        if (null != string3 && this.m_processingOrderBySortList && !this.m_processingOrderByFromClause && !this.m_processingSelectList && !this.m_processingOrderBySelectList) {
            return " " + string3 + " ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (null != object3) {
            if (((String)object3).equals(string3)) {
                return " " + string3 + " ";
            }
            stringBuilder.append("`").append(string).append("`.").append((String)object3);
        } else {
            stringBuilder.append("`").append(string).append("`.`").append(iColumn.getName()).append("`");
            if (null != string3 && (this.m_processingSelectList || this.m_processingOrderBySelectList)) {
                this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, string3, stringBuilder.toString(), aEColumnReference, aEColumnReference.getColumn()));
                stringBuilder.append(" ").append(string3);
            } else {
                this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, "`" + iColumn.getName() + "`", stringBuilder.toString(), aEColumnReference, aEColumnReference.getColumn()));
            }
        }
        return stringBuilder.toString();
    }

    private static String escapeStringLiteral(String string, boolean bl) {
        if (bl) {
            return string.replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"");
        }
        return string.replace("'", "\\'").replace("\"", "\\\"");
    }

    private AEValueExpr findAEValueExpressionList(AEColumnReference aEColumnReference) {
        IAENode iAENode = aEColumnReference;
        while (!(iAENode.getParent() instanceof AEValueExprList)) {
            iAENode = iAENode.getParent();
        }
        if (iAENode instanceof AEValueExpr) {
            return iAENode;
        }
        return aEColumnReference;
    }

    private String orderBySelectListBuilder(String string) {
        Object object;
        int n = this.m_currentColumnNumber;
        ArrayList<SelectNode> arrayList = new ArrayList<SelectNode>();
        for (int i = 0; i <= n && null != (object = this.m_columnFullNameRef.get(i)); ++i) {
            arrayList.add((SelectNode)object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (arrayList.size() > 0) {
            object = this.orderByColumnTypeAnalysis((SelectNode)arrayList.get(0), 0, string);
            stringBuilder.append((String)object);
            for (int i = 1; i < arrayList.size(); ++i) {
                object = this.orderByColumnTypeAnalysis((SelectNode)arrayList.get(i), i, string);
                stringBuilder.append(", ").append((String)object);
            }
        }
        return stringBuilder.toString();
    }

    private String orderByColumnTypeAnalysis(SelectNode selectNode, int n, String string) {
        if (null != selectNode) {
            if (selectNode.getType() == SelectType.GNEGATE) {
                return string + "." + "`_c" + n + "`";
            }
            if (selectNode.getType() == SelectType.LITERAL) {
                return selectNode.getSubqueryColumnName();
            }
            if (SelectType.RENAME == selectNode.getType() && selectNode.getOriginalColumnName().substring(1).toUpperCase().contains(EXPR_COL_NAME) && selectNode.getOriginalColumnName().substring(EXPR_COL_NAME.length() + 1).matches("^\\d+`$")) {
                return string + "." + selectNode.getSubqueryColumnName() + " AS " + selectNode.getOriginalColumnName();
            }
            return string + "." + selectNode.getSubqueryColumnName();
        }
        return "";
    }

    private String replaceEscapeChar(String string, char c) {
        string = string.replace("\\", "\\\\");
        StringBuilder stringBuilder = new StringBuilder(30);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuilder.append('\\');
                if (++i >= string.length()) continue;
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private String subqueryBuildHelperVersion12(AETop aETop, String string) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<IAENode> iterator = aETop.getChildItr();
        String string2 = iterator.next().acceptVisitor(this);
        String string3 = UUID.randomUUID().toString().substring(0, 8);
        String string4 = "`ORDERBYLIST_" + string3 + "`";
        String string5 = string2 + " " + string;
        this.m_currentSelectList = this.orderBySelectListBuilder(string4);
        stringBuilder.append("SELECT ");
        if (this.m_hasDistinct) {
            stringBuilder.append("DISTINCT ");
            this.m_hasDistinct = false;
        }
        stringBuilder.append(this.m_currentSelectList).append(" FROM ( ").append(string5).append(" ) ").append(string4);
        return stringBuilder.toString();
    }

    private String subqueryBuildHelperVersion13(AESort aESort, boolean bl) throws ErrorException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = this.m_hasDistinct;
        if (bl) {
            this.m_hasDistinct = true;
        }
        AEProject aEProject = (AEProject)aESort.getOperand();
        stringBuilder.append(aEProject.acceptVisitor(this));
        stringBuilder.append(" ORDER BY ");
        boolean bl3 = true;
        for (AESortSpec object22 : aESort.getSortSpecs()) {
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(", ");
            }
            object = (AEValueExpr)aEProject.getProjectionList().getChild(object22.getColumnNumber());
            if (!(object instanceof AERename)) {
                this.m_processingOrderBySortList = true;
                stringBuilder.append(object.acceptVisitor(this));
                this.m_processingOrderBySortList = false;
            } else {
                stringBuilder.append(((AEValueExpr)object).getName());
            }
            stringBuilder.append(object22.isAscending() ? " ASC" : " DESC");
        }
        String string = UUID.randomUUID().toString().substring(0, 8);
        String string2 = "`ORDERBYLIST_" + (String)string + "`";
        object = new StringBuilder();
        this.m_currentSelectList = this.orderBySelectListBuilder(string2);
        ((StringBuilder)object).append("SELECT ");
        ((StringBuilder)object).append(this.m_currentSelectList).append(" FROM ( ").append(stringBuilder.toString()).append(" ) ").append(string2);
        this.m_hasDistinct = bl2;
        return ((StringBuilder)object).toString();
    }

    private void saveFullColumnRef(SelectNode selectNode) {
        if (!this.m_processingOrderByList && !this.m_processingScalarFn && (this.m_processingOrderBySelectList || this.m_processingSelectList && this.m_processingOrderByFromClause && this.m_hasSubquery)) {
            this.m_columnFullNameRef.put(this.m_currentColumnNumber, selectNode);
            this.m_columnFullNameRefPersisting.add(selectNode);
        }
    }

    private String visitProject(AEProject aEProject, int n) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (this.m_hasDistinct) {
            stringBuilder.append("DISTINCT ");
            this.m_hasDistinct = false;
        }
        this.m_selectConcatColumnRef = new ArrayList<IColumn>();
        for (int i = 0; i < aEProject.getColumnCount(); ++i) {
            this.m_selectConcatColumnRef.add(aEProject.getColumn(i));
        }
        if (null != aEProject.getOperand()) {
            AERelationalExpr aERelationalExpr = aEProject.getOperand();
            if (aEProject.getOperand() instanceof AEAggregate) {
                aERelationalExpr = ((AEAggregate)aERelationalExpr).getOperand();
            }
            for (int i = 0; i < aERelationalExpr.getColumnCount(); ++i) {
                this.m_selectConcatColumnRef.add(aERelationalExpr.getColumn(i));
            }
        }
        Iterator<IAENode> iterator = aEProject.getChildItr();
        StringBuilder stringBuilder2 = new StringBuilder();
        this.m_processingOrderByFromClause = true;
        String string = iterator.next().acceptVisitor(this);
        this.m_processingOrderByFromClause = false;
        this.m_processingOrderBySelectList = true;
        IAENode iAENode = iterator.next();
        Iterator<? extends IAENode> iterator2 = iAENode.getChildItr();
        String string2 = iterator2.next().acceptVisitor(this);
        stringBuilder2.append(string2);
        int n2 = 1;
        while (n2 < n) {
            this.m_currentColumnNumber = n2++;
            String string3 = iterator2.next().acceptVisitor(this);
            stringBuilder2.append(", ").append(string3);
        }
        this.m_currentSelectList = stringBuilder2.toString();
        this.m_processingOrderBySelectList = false;
        return stringBuilder.append(stringBuilder2.toString()).append(" FROM ").append(string).toString();
    }

    private String visitChildren(IAENode iAENode) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    private String getInPredicatevalue(String string) {
        if (string.trim().equalsIgnoreCase("1")) {
            return "true";
        }
        if (string.trim().equalsIgnoreCase("0")) {
            return "false";
        }
        return string;
    }

    private static enum JoinState {
        NULL,
        TRIGGER,
        IGNORE;

    }
}

