/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.core;

import com.cloudera.impala.dsi.core.interfaces.IEnvironment;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.HiveServerType;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.impala.core.ImpalaJDBCEnvironment;
import com.cloudera.impala.impala.core.ImpalaJDBCServerVersionUtils;
import com.cloudera.impala.impala.dataengine.ImpalaCustomScalarHelper;
import com.cloudera.impala.jdbc.common.ProductInfoHandler;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.File;

public class ImpalaJDBCDSIConnection
extends HiveJDBCCommonConnection {
    public ImpalaJDBCDSIConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iEnvironment);
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException {
        super.establishConnection(connSettingRequestMap, n);
        this.m_settings.m_optimizedInsert = true;
        Variant variant = this.getOptionalSetting("OptimizedInsert", connSettingRequestMap);
        if (null != variant) {
            try {
                if (variant.getInt() == 1) {
                    this.m_settings.m_optimizedInsert = true;
                } else if (variant.getInt() == 0) {
                    this.m_settings.m_optimizedInsert = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
            }
        }
        this.m_definedSettings.put("CastStringLiteralsForInsert", true);
        variant = this.getOptionalSetting("CastStringLiteralsForInsert", connSettingRequestMap);
        int n2 = -1;
        if (null != variant) {
            block24: {
                try {
                    n2 = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block24;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), "CastStringLiteralsForInsert"}));
                }
            }
            if (1 == n2) {
                this.m_settings.m_castStringLiteralForInsert = true;
            }
            if (0 == n2) {
                this.m_settings.m_castStringLiteralForInsert = false;
            }
        } else {
            this.m_settings.m_castStringLiteralForInsert = true;
        }
        this.m_definedSettings.put("CastStringParamsForInsert", true);
        variant = this.getOptionalSetting("CastStringParamsForInsert", connSettingRequestMap);
        n2 = -1;
        if (null != variant) {
            block25: {
                try {
                    n2 = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block25;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), "CastStringParamsForInsert"}));
                }
            }
            if (1 == n2) {
                this.m_settings.m_castStringParamsForInsert = true;
            }
            if (0 == n2) {
                this.m_settings.m_castStringParamsForInsert = false;
            }
        } else {
            this.m_settings.m_castStringParamsForInsert = true;
        }
        this.m_settings.m_supportTimeOnlyTimestamp = true;
        variant = this.getOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap);
        if (null != variant) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_supportTimeOnlyTimestamp = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_TYPE_ERR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_ERR.name()));
            }
        }
    }

    @Override
    protected boolean isPortRequired() {
        return false;
    }

    @Override
    protected void setImplementationDefaultSettings() {
        this.m_settings.m_platformVersionUtils = new ImpalaJDBCServerVersionUtils();
        this.m_settings.m_platformDefaultUID = "impala";
        this.m_settings.m_platformDelegationUIDPropertyKey = "impala.doas.user";
        this.m_settings.m_platformCatalog = "Impala";
        this.m_settings.m_dbmsName = "Impala";
        this.m_settings.m_enableDirectResults = false;
        this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = false;
        this.m_settings.m_setKeyValueQueryResultSet = true;
        this.m_settings.m_cteQueryResultSet = false;
    }

    @Override
    protected ProductInfoHandler getProductInfoHandler() {
        String string = null;
        try {
            Variant variant = this.getProperty(170);
            string = variant.getString();
        }
        catch (Exception exception) {
            string = "";
        }
        return new ProductInfoHandler("SimbaApacheImpalaJDBCDriver.lic", "Simba Apache Impala JDBC Driver", string, HiveJDBCCommonDriver.class);
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            return ((ImpalaJDBCEnvironment)this.getParentEnvironment()).getLog();
        }
        return this.m_log;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (this.m_settings.m_serverSSLSettings.m_deleteTrustStoreAtConnectionClose) {
            ImpalaJDBCDSIConnection.deleteAltusTrustStore(this.m_settings.m_serverSSLSettings.m_sslTrustStore, this.m_log);
        }
        super.close();
    }

    @Override
    protected void setDriverSpecificSettings() {
        this.m_settings.m_stringColumnSize = Short.MAX_VALUE;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        this.verifyOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("OptimizedInsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseSasl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap, connSettingResponseMap);
        if (null == hiveJDBCSettings.m_authMech) {
            hiveJDBCSettings.m_authMech = AuthMech.NOAUTH;
        } else {
            bl = true;
        }
        if (HiveServerType.HiveServer2 == hiveJDBCSettings.m_hiveServerType) {
            if (AuthMech.NOAUTH_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
            }
            if (AuthMech.SASL_PLAIN_UIDPWD_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
            if (AuthMech.UIDPWD == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyRequiredSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyOptionalSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                this.verifyOptionalSetting("KrbRealm", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbHostFQDN", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbServiceName", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("krbAuthType", connSettingRequestMap, connSettingResponseMap);
            }
            if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                this.verifyOptionalSetting("SSLKeyStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLKeyStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap, connSettingResponseMap);
            }
        }
        return connSettingResponseMap;
    }

    @Override
    protected String getConnectionLogFileName() {
        return "Impala_connection_";
    }

    @Override
    protected void doReset() throws ErrorException {
        this.setImplementationDefaultSettings();
    }

    @Override
    public IHiveCustomScalarFnFactory getScalarFnHelper() {
        return new ImpalaCustomScalarHelper();
    }

    @Override
    protected void setDefaultProperties() throws ErrorException {
        super.setDefaultProperties();
        try {
            this.setProperty(1012, new Variant(5, (short)1));
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }

    @Override
    protected void setDefaultPort() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_settings.m_port = TransportMode.HTTP == this.m_settings.m_transportMode ? 28000 : 21050;
    }

    public static void deleteAltusTrustStore(String string, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, string, iLogger);
        try {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                file.delete();
                LogUtilities.logInfo("deleted altus trust store", iLogger);
            }
        }
        catch (Exception exception) {
            LogUtilities.logWarning("Exception occurred while cleaning up Altus trust store: " + exception.getMessage(), iLogger);
        }
    }
}

