/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.http.impl.client;

import com.cloudera.impala.jdbc4.internal.apache.http.HttpException;
import com.cloudera.impala.jdbc4.internal.apache.http.HttpHost;
import com.cloudera.impala.jdbc4.internal.apache.http.HttpRequest;
import com.cloudera.impala.jdbc4.internal.apache.http.annotation.Contract;
import com.cloudera.impala.jdbc4.internal.apache.http.annotation.ThreadingBehavior;
import com.cloudera.impala.jdbc4.internal.apache.http.client.ClientProtocolException;
import com.cloudera.impala.jdbc4.internal.apache.http.client.config.RequestConfig;
import com.cloudera.impala.jdbc4.internal.apache.http.client.methods.CloseableHttpResponse;
import com.cloudera.impala.jdbc4.internal.apache.http.client.methods.Configurable;
import com.cloudera.impala.jdbc4.internal.apache.http.client.methods.HttpExecutionAware;
import com.cloudera.impala.jdbc4.internal.apache.http.client.methods.HttpRequestWrapper;
import com.cloudera.impala.jdbc4.internal.apache.http.client.protocol.HttpClientContext;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.ClientConnectionManager;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.ClientConnectionRequest;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.HttpClientConnectionManager;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.ManagedClientConnection;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.routing.HttpRoute;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.scheme.SchemeRegistry;
import com.cloudera.impala.jdbc4.internal.apache.http.impl.DefaultConnectionReuseStrategy;
import com.cloudera.impala.jdbc4.internal.apache.http.impl.client.CloseableHttpClient;
import com.cloudera.impala.jdbc4.internal.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.cloudera.impala.jdbc4.internal.apache.http.impl.execchain.MinimalClientExec;
import com.cloudera.impala.jdbc4.internal.apache.http.params.BasicHttpParams;
import com.cloudera.impala.jdbc4.internal.apache.http.params.HttpParams;
import com.cloudera.impala.jdbc4.internal.apache.http.protocol.BasicHttpContext;
import com.cloudera.impala.jdbc4.internal.apache.http.protocol.HttpContext;
import com.cloudera.impala.jdbc4.internal.apache.http.protocol.HttpRequestExecutor;
import com.cloudera.impala.jdbc4.internal.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

