/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.http.impl.cookie;

import com.cloudera.impala.jdbc4.internal.apache.http.annotation.Contract;
import com.cloudera.impala.jdbc4.internal.apache.http.annotation.ThreadingBehavior;
import com.cloudera.impala.jdbc4.internal.apache.http.cookie.CommonCookieAttributeHandler;
import com.cloudera.impala.jdbc4.internal.apache.http.cookie.Cookie;
import com.cloudera.impala.jdbc4.internal.apache.http.cookie.CookieOrigin;
import com.cloudera.impala.jdbc4.internal.apache.http.cookie.MalformedCookieException;
import com.cloudera.impala.jdbc4.internal.apache.http.cookie.SetCookie;
import com.cloudera.impala.jdbc4.internal.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.cloudera.impala.jdbc4.internal.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

