/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.jute;

import com.cloudera.impala.jdbc4.internal.apache.jute.BinaryOutputArchive;
import com.cloudera.impala.jdbc4.internal.apache.jute.CsvOutputArchive;
import com.cloudera.impala.jdbc4.internal.apache.jute.OutputArchive;
import com.cloudera.impala.jdbc4.internal.apache.jute.Record;
import com.cloudera.impala.jdbc4.internal.apache.jute.XmlOutputArchive;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class RecordWriter {
    private OutputArchive archive;
    private static HashMap archiveFactory = RecordWriter.constructFactory();

    private static OutputArchive getBinaryArchive(OutputStream out) {
        return new BinaryOutputArchive(new DataOutputStream(out));
    }

    private static OutputArchive getCsvArchive(OutputStream out) throws IOException {
        try {
            return new CsvOutputArchive(out);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Unsupported encoding UTF-8");
        }
    }

    private static OutputArchive getXmlArchive(OutputStream out) throws IOException {
        return new XmlOutputArchive(out);
    }

    static HashMap constructFactory() {
        HashMap<String, Method> factory = new HashMap<String, Method>();
        Class[] params = new Class[]{OutputStream.class};
        try {
            factory.put("binary", BinaryOutputArchive.class.getDeclaredMethod("getArchive", params));
            factory.put("csv", CsvOutputArchive.class.getDeclaredMethod("getArchive", params));
            factory.put("xml", XmlOutputArchive.class.getDeclaredMethod("getArchive", params));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return factory;
    }

    private static OutputArchive createArchive(OutputStream out, String format) throws IOException {
        Method factory = (Method)archiveFactory.get(format);
        if (factory != null) {
            Object[] params = new Object[]{out};
            try {
                return (OutputArchive)factory.invoke(null, params);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordWriter(OutputStream out, String format) throws IOException {
        this.archive = RecordWriter.createArchive(out, format);
    }

    public void write(Record r) throws IOException {
        r.serialize(this.archive, "");
    }
}

