/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.ser.std;

import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.core.JsonGenerator;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.JavaType;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.JsonMappingException;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.JsonNode;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.SerializationFeature;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.SerializerProvider;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.cloudera.impala.jdbc4.internal.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

public class StdKeySerializer
extends StdSerializer<Object> {
    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializerProvider provider) throws IOException {
        String str;
        Class<?> cls = value.getClass();
        if (cls == String.class) {
            str = (String)value;
        } else if (cls.isEnum()) {
            Enum en = (Enum)value;
            str = provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? en.toString() : en.name();
        } else {
            if (value instanceof Date) {
                provider.defaultSerializeDateKey((Date)value, g);
                return;
            }
            str = cls == Class.class ? ((Class)value).getName() : value.toString();
        }
        g.writeFieldName(str);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectStringFormat(typeHint);
    }
}

