/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.materializer;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETAllQuantifiedComparison;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETAnd;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETAnyQuantifiedComparison;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETComparison;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETExistsPredicate;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETInSQPredicate;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETLike;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETNot;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETNullPredicate;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETOr;
import com.cloudera.impala.sqlengine.executor.etree.bool.ETTrue;
import com.cloudera.impala.sqlengine.executor.etree.bool.functor.comp.BooleanFunctorFactory;
import com.cloudera.impala.sqlengine.executor.etree.bool.functor.comp.IBooleanCompFunctor;
import com.cloudera.impala.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.materializer.ConvMaterializeUtil;
import com.cloudera.impala.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.cloudera.impala.sqlengine.executor.materializer.ETValueExprMaterializer;
import com.cloudera.impala.sqlengine.executor.materializer.MaterializerBase;
import com.cloudera.impala.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.impala.sqlengine.executor.queryplan.IQueryPlan;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.LinkedList;

public class ETBoolExprMaterializer
extends MaterializerBase<ETBooleanExpr> {
    public ETBoolExprMaterializer(IQueryPlan iQueryPlan, MaterializerContext materializerContext) {
        super(iQueryPlan, materializerContext);
    }

    @Override
    public ETBooleanExpr visit(AEAnd aEAnd) throws ErrorException {
        return new ETAnd(aEAnd.getLeftOperand().acceptVisitor(this), aEAnd.getRightOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AEOr aEOr) throws ErrorException {
        return new ETOr(aEOr.getLeftOperand().acceptVisitor(this), aEOr.getRightOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AENot aENot) throws ErrorException {
        return new ETNot(aENot.getOperand().acceptVisitor(this));
    }

    @Override
    public ETBooleanExpr visit(AEComparison aEComparison) throws ErrorException {
        if (aEComparison.getLeftOperand().getNumChildren() != 1 || aEComparison.getRightOperand().getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Compare value list");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)aEComparison.getLeftOperand().getChild(0);
        AEValueExpr aEValueExpr2 = (AEValueExpr)aEComparison.getRightOperand().getChild(0);
        IColumn iColumn = aEComparison.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = this.materializeExpr(aEValueExpr, iColumn);
        ETValueExpr eTValueExpr2 = this.materializeExpr(aEValueExpr2, iColumn);
        IBooleanCompFunctor iBooleanCompFunctor = BooleanFunctorFactory.getBoolCompFunctor(aEComparison.getComparisonOp(), iColumn.getTypeMetadata());
        return new ETComparison(iColumn, eTValueExpr, eTValueExpr2, iBooleanCompFunctor);
    }

    @Override
    public ETBooleanExpr visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
        if (aEQuantifiedComparison.getLeftOperand().getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Row value constructor not supported in predicates.");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)aEQuantifiedComparison.getLeftOperand().getChild(0);
        AERelationalExpr aERelationalExpr = aEQuantifiedComparison.getRightOperand();
        IColumn iColumn = aEQuantifiedComparison.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = this.materializeExpr(aEValueExpr, iColumn);
        ETRelationalExpr eTRelationalExpr = this.materializeExpr(aERelationalExpr, iColumn);
        IBooleanCompFunctor iBooleanCompFunctor = BooleanFunctorFactory.getBoolCompFunctor(aEQuantifiedComparison.getComparisonOp(), iColumn.getTypeMetadata());
        if (AEQuantifiedComparison.QuantifierType.ALL == aEQuantifiedComparison.getQuantifierType()) {
            return new ETAllQuantifiedComparison(iColumn, eTValueExpr, eTRelationalExpr, iBooleanCompFunctor);
        }
        return new ETAnyQuantifiedComparison(iColumn, eTValueExpr, eTRelationalExpr, iBooleanCompFunctor);
    }

    @Override
    public ETBooleanExpr visit(AELikePredicate aELikePredicate) throws ErrorException {
        AEValueExpr aEValueExpr = aELikePredicate.getEscapeChar();
        AEValueExpr aEValueExpr2 = aELikePredicate.getLeftOperand();
        AEValueExpr aEValueExpr3 = aELikePredicate.getRightOperand();
        IColumn iColumn = aELikePredicate.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = null;
        if (aEValueExpr != null) {
            eTValueExpr = this.materializeExpr(aEValueExpr, iColumn);
        }
        ETValueExpr eTValueExpr2 = this.materializeExpr(aEValueExpr2, iColumn);
        ETValueExpr eTValueExpr3 = this.materializeExpr(aEValueExpr3, iColumn);
        return new ETLike(iColumn, eTValueExpr2, eTValueExpr3, eTValueExpr);
    }

    @Override
    public ETBooleanExpr visit(AEInPredicate aEInPredicate) throws ErrorException {
        Object object;
        Object object2;
        AEValueExprList aEValueExprList = aEInPredicate.getLeftOperand();
        if (aEValueExprList.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("IN predicate with multiple columns on as left operand.");
        }
        IColumn iColumn = aEInPredicate.getCoercedColumnMetadata();
        ETValueExpr eTValueExpr = this.materializeExpr((AEValueExpr)aEValueExprList.getChild(0), iColumn);
        IAENode iAENode = aEInPredicate.getRightOperand();
        if (iAENode instanceof AERelationalExpr) {
            assert (1 == ((AERelationalExpr)iAENode).getColumnCount());
            ETRelationalExpr eTRelationalExpr = this.materializeExpr((AERelationalExpr)iAENode, iColumn);
            IBooleanCompFunctor iBooleanCompFunctor = BooleanFunctorFactory.getBoolCompFunctor(AEComparisonType.EQUAL, iColumn.getTypeMetadata());
            return new ETInSQPredicate(iColumn, eTValueExpr, eTRelationalExpr, iBooleanCompFunctor);
        }
        if (!(iAENode instanceof AEValueExprList)) {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        LinkedList<ETComparison> linkedList = new LinkedList<ETComparison>();
        Iterator iterator = ((AEValueExprList)iAENode).getChildItr();
        while (iterator.hasNext()) {
            object2 = this.materializeExpr((AEValueExpr)iterator.next(), iColumn);
            object = BooleanFunctorFactory.getBoolCompFunctor(AEComparisonType.EQUAL, iColumn.getTypeMetadata());
            linkedList.add(new ETComparison(iColumn, eTValueExpr, (ETValueExpr)object2, (IBooleanCompFunctor)object));
        }
        if (linkedList.size() == 0) {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }
        object2 = linkedList.iterator();
        object = (ETBooleanExpr)object2.next();
        while (object2.hasNext()) {
            object = new ETOr((ETBooleanExpr)object, (ETBooleanExpr)object2.next());
        }
        return object;
    }

    @Override
    public ETBooleanExpr visit(AENullPredicate aENullPredicate) throws ErrorException {
        AEValueExprList aEValueExprList = aENullPredicate.getOperand();
        if (aEValueExprList.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("IS NULL predicate on multiple column.");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(0);
        ETValueExpr eTValueExpr = this.materializeExpr(aEValueExpr, null);
        return new ETNullPredicate(eTValueExpr, aEValueExpr.getColumn());
    }

    @Override
    public ETBooleanExpr visit(AEBooleanTrue aEBooleanTrue) throws ErrorException {
        return new ETTrue();
    }

    @Override
    public ETBooleanExpr visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
        ETRelationalExpr eTRelationalExpr = this.materializeExpr(aEExistsPredicate.getOperand(), null);
        return new ETExistsPredicate(eTRelationalExpr);
    }

    protected ETValueExprMaterializer createValueExprMaterializer() {
        return new ETValueExprMaterializer(this.getQueryPlan(), this.getContext());
    }

    protected ETRelationalExprMaterializer createRelationalExprMaterializer() {
        return new ETRelationalExprMaterializer(this.getQueryPlan(), this.getContext());
    }

    private ETRelationalExpr materializeExpr(AERelationalExpr aERelationalExpr, IColumn iColumn) throws ErrorException {
        ETRelationalExprMaterializer eTRelationalExprMaterializer = this.createRelationalExprMaterializer();
        ETRelationalExpr eTRelationalExpr = aERelationalExpr.acceptVisitor(eTRelationalExprMaterializer);
        if (iColumn == null) {
            return eTRelationalExpr;
        }
        return ConvMaterializeUtil.makeNewRelationConvertNode(iColumn, eTRelationalExpr, aERelationalExpr.getDataNeeded(0), false, this.getContext());
    }

    private ETValueExpr materializeExpr(AEValueExpr aEValueExpr, IColumn iColumn) throws ErrorException {
        ETValueExprMaterializer eTValueExprMaterializer = this.createValueExprMaterializer();
        ETValueExpr eTValueExpr = aEValueExpr.acceptVisitor(eTValueExprMaterializer);
        if (iColumn == null) {
            return eTValueExpr;
        }
        return ConvMaterializeUtil.addConversionNodeWhenNeeded(eTValueExpr, aEValueExpr.getColumn(), iColumn, this.getContext());
    }
}

