/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.math.BigInteger;

public final class RSAAlgorithm {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "RSAAlgorithm");
    private static final PrintWriter err = Debug.getOutput();
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private static void debug(String string) {
        err.println("RSAAlgorithm: " + string);
    }

    public static BigInteger rsa(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        if (bigInteger4 != null) {
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            if (!bigInteger6.equals(bigInteger5.modInverse(bigInteger4))) {
                bigInteger8 = bigInteger5;
                bigInteger5 = bigInteger4;
                bigInteger4 = bigInteger8;
            }
            if ((bigInteger8 = bigInteger.mod(bigInteger4).modPow(bigInteger3.mod(bigInteger4.subtract(ONE)), bigInteger4)).equals(bigInteger7 = bigInteger.mod(bigInteger5).modPow(bigInteger3.mod(bigInteger5.subtract(ONE)), bigInteger5))) {
                return bigInteger7;
            }
            BigInteger bigInteger9 = bigInteger8.subtract(bigInteger7).mod(bigInteger4).multiply(bigInteger6).mod(bigInteger4);
            return bigInteger5.multiply(bigInteger9).add(bigInteger7);
        }
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }

    public static BigInteger rsa(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.modPow(bigInteger3, bigInteger2);
    }

    private RSAAlgorithm() {
    }
}

